---
generated_at: 2026-02-05 10:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：3-メモリアロケーションプロファイルレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **サンプリングのオーバーヘッド影響**：定量的データなし

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/Profile/src/Allocs.jl` 行19-22（RawBacktrace構造体）
- E-02: `stdlib/Profile/src/Allocs.jl` 行25-31（RawAlloc構造体）
- E-03: `stdlib/Profile/src/Allocs.jl` 行34-37（RawResults構造体）
- E-04: `stdlib/Profile/src/Allocs.jl` 行132-138（Alloc構造体）
- E-05: `stdlib/Profile/src/Allocs.jl` 行140-142（AllocResults構造体）
- E-06: `stdlib/Profile/src/Allocs.jl` 行72-77（@profileマクロ）
- E-07: `stdlib/Profile/src/Allocs.jl` 行96-98（start関数）
- E-08: `stdlib/Profile/src/Allocs.jl` 行125-128（fetch関数）
- E-09: `stdlib/Profile/src/Allocs.jl` 行164-173（load_type関数）
- E-10: `stdlib/Profile/src/Allocs.jl` 行185-192（decode関数）
- E-11: `stdlib/Profile/src/Allocs.jl` 行203-223（stacktrace_memoized関数）
- E-12: `stdlib/Profile/src/Allocs.jl` 行243-268（print関数群）
- E-13: `stdlib/Profile/src/Allocs.jl` 行286-319（parse_flat関数）
- E-14: `stdlib/Profile/src/Allocs.jl` 行321-333（flat関数）
- E-15: `stdlib/Profile/src/Allocs.jl` 行335-403（tree!関数）
- E-16: `stdlib/Profile/src/Allocs.jl` 行405-420（tree関数）
- E-17: `stdlib/Profile/src/Allocs.jl` 行160-162（特殊型定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RawAllocはC構造体jl_raw_alloc_tに対応 | E-02 | ○ |
| C-02 | デフォルトsample_rateは0.1 | E-06 (行76) | ○ |
| C-03 | sample_rate=1.0で全アロケーション記録 | E-06 (docstring行45) | ○ |
| C-04 | startでjl_start_alloc_profileをccall | E-07 | ○ |
| C-05 | fetchでjl_fetch_alloc_profileをccall | E-08 | ○ |
| C-06 | load_typeで特殊型（CorruptType, BufferType, UnknownType）処理 | E-09, E-17 | ○ |
| C-07 | decodeでRawResults→AllocResults変換 | E-10 | ○ |
| C-08 | stacktrace_memoizedでバックトレースメモ化 | E-11 | ○ |
| C-09 | printがProfile.printに委譲 | E-12 | ○ |
| C-10 | フラット形式でparse_flatを使用 | E-13, E-14 | ○ |
| C-11 | ツリー形式でtree!を使用 | E-15, E-16 | ○ |
| C-12 | カウント値がバイト数（r.size） | E-13 (行297), E-15 (行340) | ○ |
| C-13 | Total snapshotsはlength(data) | E-14 (行330), E-16 (行417) | ○ |
| C-14 | Total bytesはroot.count（ツリー）/ totalbytes（フラット） | E-14 (行331), E-16 (行418) | ○ |
| C-15 | combine=falseでArgumentError | E-14 (行322), E-16 (行406) | ○ |
| C-16 | Julia 1.8で追加された機能 | E-06 (docstring行69-70) | ○ |
| C-17 | Julia 1.11以降で全型情報が報告 | E-06 (docstring行59-67) | ○ |
| C-18 | Alloc.taskはunrootedポインタ | E-04 (行136) | ○ |
| C-19 | Profile.Allocs.printとProfile.printは別関数 | E-12 (行1, 3) | ○ |
| C-20 | デフォルト出力形式はツリー | E-12 (行255) | ○ |
| C-21 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |
| C-22 | サンプリングのオーバーヘッド定量データ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：大量アロケーション時の出力所要時間に関するデータなし
  - 候補：ベンチマーク結果 / CI テストログ
- サンプリングオーバーヘッド：sample_rate に応じたプログラム実行速度への影響の定量データなし
  - 候補：ベンチマーク結果 / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造の記述はソースコードと一致
- 0: 低リスク - 処理フローの記述はソースコードの呼び出し順序と一致
- 1: 中リスク - サンプリングオーバーヘッドの影響範囲が不明

## 6) レビュアーチェックリスト（最小）
- [ ] RawAlloc の C 構造体マッピングが正しいか
- [ ] load_type の特殊型処理が正しいか
- [ ] カウント値がサンプル数ではなくバイト数である記述が正しいか
- [ ] print 関数の委譲チェーンが正しいか
