---
generated_at: 2026-02-05 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：4-ヒープスナップショット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Chrome DevTools 互換性の詳細仕様**：JSON スキーマの詳細はC実装側にあり未確認
  2. **assemble_snapshot の内部処理**：heapsnapshot_reassemble.jl の詳細未読

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/Profile/src/Profile.jl` 行1375-1406（take_heap_snapshot docstring）
- E-02: `stdlib/Profile/src/Profile.jl` 行1407-1419（take_heap_snapshot(filepath)関数）
- E-03: `stdlib/Profile/src/Profile.jl` 行1420-1427（take_heap_snapshot(io)関数）
- E-04: `stdlib/Profile/src/Profile.jl` 行1428-1452（_stream_heap_snapshot関数）
- E-05: `stdlib/Profile/src/Profile.jl` 行1453-1469（take_heap_snapshot(; dir)関数）
- E-06: `stdlib/Profile/src/Profile.jl` 行1488（heapsnapshot_reassemble.jl include）
- E-07: `stdlib/Profile/src/Profile.jl` 行21（JULIA_PROFILE_PEEK_HEAP_SNAPSHOT環境変数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .heapsnapshot形式はChrome DevTools互換 | E-01 | ○ |
| C-02 | デフォルトファイル名は{pid}_{timestamp}.heapsnapshot | E-05 (行1454) | ○ |
| C-03 | streaming=trueで4ファイル分割出力 | E-04 | ○ |
| C-04 | 4ファイルは.nodes, .edges, .strings, .metadata.json | E-04 (行1430-1434) | ○ |
| C-05 | streaming=falseでassemble_snapshot後にcleanup | E-02 (行1415-1416) | ○ |
| C-06 | redact_data=trueがデフォルト | E-01, E-02 | ○ |
| C-07 | all_one=falseがデフォルト | E-05 (行1453) | ○ |
| C-08 | カレントディレクトリに書き込めない場合tempdirにフォールバック | E-05 (行1458-1463) | ○ |
| C-09 | ccallでjl_gc_take_heap_snapshotを呼び出し | E-04 (行1439-1443) | ○ |
| C-10 | 引数は4ファイルハンドル+all_one+redact_data | E-04 (行1439-1443) | ○ |
| C-11 | IO版はtempdirに一時ファイルを作成 | E-03 (行1423-1424) | ○ |
| C-12 | streaming=trueの使用を推奨 | E-01 (行1398-1405) | ○ |
| C-13 | 非streaming時もパートファイルが保存される | E-01 (行1402-1405) | ○ |
| C-14 | JULIA_PROFILE_PEEK_HEAP_SNAPSHOTでシグナル対応 | E-07 | ○ |
| C-15 | @_lock_iosでファイルIOをロック | E-04 (行1435-1438) | ○ |
| C-16 | heapsnapshot_reassemble.jlをinclude | E-06 | ○ |
| C-17 | Chrome DevTools JSON スキーマの詳細 | **根拠なし** | △ |
| C-18 | assemble_snapshotの内部処理詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Chrome DevTools のヒープスナップショット JSON スキーマの詳細仕様：C 実装側（`jl_gc_take_heap_snapshot`）で生成されるため Julia コードからは確認不可
  - 候補：`src/gc-heap-snapshot.cpp` / Chrome DevTools Protocol ドキュメント
- `assemble_snapshot` の内部処理：`heapsnapshot_reassemble.jl` の詳細読み込みが必要
  - 候補：`stdlib/Profile/src/heapsnapshot_reassemble.jl`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エントリーポイントと分岐ロジックはソースコードと一致
- 0: 低リスク - ファイル名生成ロジックはソースコードと一致
- 1: 中リスク - JSON スキーマの詳細は C 実装依存で Julia 側から確認困難
- 2: 高リスク - redact_data=false 使用時のセキュリティリスク（機密データ漏洩）

## 6) レビュアーチェックリスト（最小）
- [ ] ストリーミングモードの 4 ファイル名パターンがソースコードと一致しているか
- [ ] デフォルトファイル名の生成ロジックが正しいか
- [ ] redact_data のデフォルト値と動作がソースコードと一致しているか
- [ ] tempdir フォールバックの条件が正しいか
