---
generated_at: 2026-02-05 10:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-@timeレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特に優先的なレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `base/timing.jl` 行4-75（GC_Num構造体）
- E-02: `base/timing.jl` 行80-90（GC_Diff構造体）
- E-03: `base/timing.jl` 行95-108（GC_Diff コンストラクタ）
- E-04: `base/timing.jl` 行110-112（gc_alloc_count関数）
- E-05: `base/timing.jl` 行200-208（prettyprint_getunits関数）
- E-06: `base/timing.jl` 行241-250（format_bytes関数）
- E-07: `base/timing.jl` 行252-303（time_print関数）
- E-08: `base/timing.jl` 行334-406（@timeマクロ + docstring）
- E-09: `base/timing.jl` 行730-758（@timedマクロ）
- E-10: `base/timing.jl` 行92-93（gc_total_bytes関数）
- E-11: `base/timing.jl` 行114-119（cumulative_compile_time_ns関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @timeは@timedに展開される | E-08 (行400) | ○ |
| C-02 | 実行時間は小数6桁で表示 | E-07 (行254) | ○ |
| C-03 | GC_Num構造体でGC統計取得 | E-01 | ○ |
| C-04 | GC_Diffで差分計算 | E-02, E-03 | ○ |
| C-05 | gc_alloc_count = malloc + realloc + poolalloc + bigalloc | E-04 | ○ |
| C-06 | gc_total_bytes = allocd + deferred_alloc + total_allocd | E-10 | ○ |
| C-07 | GC時間%の計算式 100*gctime/elapsedtime | E-07 (行278) | ○ |
| C-08 | コンパイル時間%の計算式 | E-07 (行291) | ○ |
| C-09 | リコンパイル%が1%未満なら"<1"表示 | E-07 (行296) | ○ |
| C-10 | ロック競合数表示（Julia 1.11） | E-07 (行280-286), E-08 (docstring行363-364) | ○ |
| C-11 | 説明文字列オプション（Julia 1.8） | E-08 (行398-406, docstring行358-359) | ○ |
| C-12 | prettyprint_getunitsで単位変換 | E-05 | ○ |
| C-13 | format_bytesでバイト数フォーマット | E-06 | ○ |
| C-14 | バイト単位は1024進 | E-06 (行242-243) | ○ |
| C-15 | @timedでforce_compileが呼ばれる | E-09 (行732) | ○ |
| C-16 | lock_profilingで競合カウント開始 | E-09 (行733) | ○ |
| C-17 | cumulative_compile_timingで計測開始 | E-09 (行737) | ○ |
| C-18 | try-finallyで計測完了保証 | E-09 (行739-745) | ○ |
| C-19 | 出力はstdoutへ | E-07 (行252), E-08 (行403) | ○ |
| C-20 | msg引数がnilの場合は右寄せスペース | E-07 (行257-260) | ○ |
| C-21 | 括弧は何か出力がある場合のみ | E-07 (行262-263) | ○ |
| C-22 | Ryu.writefixedで数値フォーマット | E-07 (行254, 278, 291) | ○ |
| C-23 | @showtime は式自体も出力 | E-08, `base/timing.jl` 行408-427 | ○ |
| C-24 | @timedはNamedTupleを返す | E-09 (行747-757) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし。全項目がソースコードで確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり
- 0: 低リスク - 出力フォーマットの記述が詳細で正確

## 6) レビュアーチェックリスト（最小）
- [ ] time_print のフォーマット文字列がソースコードと一致しているか
- [ ] GC_Diff の差分計算ロジックが正しいか
- [ ] @timed の計測開始・終了ポイントが正しいか
