---
generated_at: 2026-02-05 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-@timevレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特に優先的なレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `base/timing.jl` 行305-322（timev_print関数）
- E-02: `base/timing.jl` 行210-215（padded_nonzero_print関数）
- E-03: `base/timing.jl` 行429-479（@timevマクロ + docstring）
- E-04: `base/timing.jl` 行252-303（time_print関数）
- E-05: `base/timing.jl` 行80-90（GC_Diff構造体）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @timevは@timedに展開後timev_printを呼び出す | E-03 (行473, 476) | ○ |
| C-02 | timev_printは最初にtime_printを呼び出す | E-01 (行309) | ○ |
| C-03 | elapsed time (ns)を出力 | E-01 (行310) | ○ |
| C-04 | gc time (ns)を出力 | E-01 (行311) | ○ |
| C-05 | bytes allocatedを出力 | E-01 (行312) | ○ |
| C-06 | pool allocsを出力 | E-01 (行313) | ○ |
| C-07 | non-pool GC allocsを出力 | E-01 (行314) | ○ |
| C-08 | malloc() callsは0でない場合のみ表示 | E-01 (行315), E-02 (行211) | ○ |
| C-09 | realloc() callsは0でない場合のみ表示 | E-01 (行316), E-02 (行211) | ○ |
| C-10 | free() callsはmalloc > 0の場合のみ表示 | E-01 (行318) | ○ |
| C-11 | minor collections = pause - full_sweep | E-01 (行319) | ○ |
| C-12 | full collectionsを出力 | E-01 (行321) | ○ |
| C-13 | padded_nonzero_printは19文字幅パディング | E-02 (行212) | ○ |
| C-14 | always_print引数で表示制御 | E-02 (行210-211) | ○ |
| C-15 | Julia 1.8で説明文字列オプション追加 | E-03 (docstring行440-441) | ○ |
| C-16 | @timeの詳細版として位置付け | E-03 (docstring行433-436) | ○ |
| C-17 | compile_times引数はタプル | E-01 (行305, 307-308) | ○ |
| C-18 | msg引数はtimev_printに渡される | E-01 (行309) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし。全項目がソースコードで確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり
- 0: 低リスク - 出力項目の記述が timev_print のソースコードと完全一致

## 6) レビュアーチェックリスト（最小）
- [ ] timev_print の出力項目順序がソースコードと一致しているか
- [ ] padded_nonzero_print の表示条件が正しいか
- [ ] minor collections の計算式が正しいか
