---
generated_at: 2026-02-04 22:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 141
  claims_without_evidence: 9
confidence_derived: 0.94
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された機能一覧.csvの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：141 / 150、根拠なし：9
- 優先レビュー（高）
  1. **No.109 SHA**：stdlib/SHA.versionファイルのみで実装コード未確認（外部パッケージ）
  2. **No.121 LinearAlgebra**：stdlib/LinearAlgebra.versionファイルのみで実装コード未確認（外部パッケージ）
  3. **No.122 SparseArrays**：stdlib/SparseArrays.versionファイルのみで実装コード未確認（外部パッケージ）
  4. **No.123 Pkg**：stdlib/Pkg.versionファイルのみで実装コード未確認（外部パッケージ）
  5. **No.124 Distributed**：stdlib/Distributed.versionファイルのみで実装コード未確認（外部パッケージ）
  6. **No.125 Statistics**：stdlib/Statistics.versionファイルのみで実装コード未確認（外部パッケージ）
  7. **No.126 DelimitedFiles**：stdlib/DelimitedFiles.versionファイルのみで実装コード未確認（外部パッケージ）
  8. **No.127 Downloads**：stdlib/Downloads.versionファイルのみで実装コード未確認（外部パッケージ）
  9. **No.130 ユーザーマニュアル**：doc/ディレクトリの存在は確認済みだが生成パイプラインの詳細は未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/Base.jl` - Baseモジュールの構成と各ファイルのinclude順序
- E-02: `base/exports.jl` - Baseモジュールのエクスポートシンボル一覧
- E-03: `base/public.jl` - Baseモジュールのpublicシンボル一覧
- E-04: `base/boot.jl` - Coreモジュールの基本型定義
- E-05: `base/array.jl` - 配列の基本実装
- E-06: `base/strings/` - 文字列処理の実装
- E-07: `base/io.jl`, `base/iobuffer.jl`, `base/iostream.jl` - I/Oの実装
- E-08: `base/broadcast.jl` - ブロードキャストの実装
- E-09: `base/sort.jl` - ソートの実装
- E-10: `base/reduce.jl`, `base/reducedim.jl` - リダクション演算の実装
- E-11: `base/dict.jl`, `base/set.jl` - 辞書・集合の実装
- E-12: `base/task.jl`, `base/channels.jl` - Task・Channel並行処理の実装
- E-13: `base/threadingconstructs.jl` - マルチスレッドの実装
- E-14: `base/lock.jl`, `base/locks-mt.jl`, `base/condition.jl` - 同期プリミティブの実装
- E-15: `base/regex.jl` - 正規表現の実装
- E-16: `base/math.jl`, `base/float.jl`, `base/complex.jl`, `base/rational.jl` - 数値演算の実装
- E-17: `base/gmp.jl`, `base/mpfr.jl` - 多倍長演算の実装
- E-18: `base/cmd.jl`, `base/process.jl` - 外部プロセスの実装
- E-19: `base/path.jl`, `base/file.jl`, `base/stat.jl`, `base/filesystem.jl` - ファイルシステムの実装
- E-20: `base/loading.jl`, `base/precompilation.jl` - パッケージ読み込みの実装
- E-21: `base/c.jl`, `base/pointer.jl`, `base/ctypes.jl` - C言語連携の実装
- E-22: `base/reflection.jl`, `base/methodshow.jl` - リフレクションの実装
- E-23: `base/timing.jl` - 計時の実装
- E-24: `base/errorshow.jl`, `base/stacktraces.jl`, `base/error.jl` - エラー処理の実装
- E-25: `base/missing.jl`, `base/some.jl` - Missing/Some型の実装
- E-26: `base/Enums.jl` - 列挙型の実装
- E-27: `base/docs/Docs.jl` - ドキュメントシステムの実装
- E-28: `base/fastmath.jl` - FastMathの実装
- E-29: `base/scopedvalues.jl` - ScopedValuesの実装
- E-30: `base/asyncevent.jl`, `base/asyncmap.jl` - 非同期処理の実装
- E-31: `Compiler/src/Compiler.jl` - コンパイラモジュールの構成
- E-32: `Compiler/src/abstractinterpretation.jl` - 型推論エンジン
- E-33: `Compiler/src/typelattice.jl`, `Compiler/src/typelimits.jl` - 型格子
- E-34: `Compiler/src/effects.jl` - 効果推論
- E-35: `Compiler/src/optimize.jl`, `Compiler/src/ssair/` - 最適化パス
- E-36: `Compiler/src/tfuncs.jl` - 型推論ユーティリティ
- E-37: `src/codegen.cpp`, `src/ccall.cpp` - LLVM コード生成
- E-38: `src/jitlayers.cpp`, `src/engine.cpp` - JITコンパイル
- E-39: `src/aotcompile.cpp`, `src/staticdata.c` - AOTコンパイル
- E-40: `src/gc-stock.c`, `src/gc-mmtk.c` - GCランタイム
- E-41: `src/jltypes.c`, `src/gf.c`, `src/subtype.c` - 型システムランタイム
- E-42: `src/scheduler.c`, `src/task.c` - タスクスケジューラ
- E-43: `src/signals-unix.c`, `src/signals-mach.c`, `src/signals-win.c` - シグナル処理
- E-44: `src/debuginfo.cpp`, `src/stackwalk.c` - デバッグ情報
- E-45: `src/safepoint.c` - セーフポイント
- E-46: `src/init.c`, `src/jlapi.c` - 初期化
- E-47: `src/jloptions.c` - コマンドラインオプション
- E-48: `cli/loader_exe.c`, `cli/loader_lib.c` - CLIローダー
- E-49: `JuliaSyntax/` - パーサー
- E-50: `stdlib/Dates/src/` - Datesライブラリ
- E-51: `stdlib/Random/src/` - Randomライブラリ
- E-52: `stdlib/Test/src/` - Testライブラリ
- E-53: `stdlib/Printf/src/` - Printfライブラリ
- E-54: `stdlib/REPL/src/` - REPLライブラリ
- E-55: `stdlib/Serialization/src/` - Serializationライブラリ
- E-56: `stdlib/Sockets/src/` - Socketsライブラリ
- E-57: `stdlib/TOML/src/` - TOMLライブラリ
- E-58: `stdlib/Markdown/src/` - Markdownライブラリ
- E-59: `stdlib/Unicode/src/` - Unicodeライブラリ
- E-60: `stdlib/Base64/src/` - Base64ライブラリ
- E-61: `stdlib/CRC32c/src/` - CRC32cライブラリ
- E-62: `stdlib/UUIDs/src/` - UUIDsライブラリ
- E-63: `stdlib/Logging/src/` - Loggingライブラリ
- E-64: `stdlib/Profile/src/` - Profileライブラリ
- E-65: `stdlib/InteractiveUtils/src/` - InteractiveUtilsライブラリ
- E-66: `stdlib/Mmap/src/` - Mmapライブラリ
- E-67: `stdlib/FileWatching/src/` - FileWatchingライブラリ
- E-68: `stdlib/SharedArrays/src/` - SharedArraysライブラリ
- E-69: `stdlib/Libdl/src/` - Libdlライブラリ
- E-70: `stdlib/LibGit2/src/` - LibGit2ライブラリ
- E-71: `stdlib/Artifacts/src/` - Artifactsライブラリ
- E-72: `stdlib/Future/src/` - Futureライブラリ
- E-73: `stdlib/GMP_jll/` - GMP JLL
- E-74: `stdlib/MPFR_jll/` - MPFR JLL
- E-75: `stdlib/OpenBLAS_jll/` - OpenBLAS JLL
- E-76: `stdlib/SuiteSparse_jll/` - SuiteSparse JLL
- E-77: `stdlib/LibCURL_jll/` - LibCURL JLL
- E-78: `stdlib/PCRE2_jll/` - PCRE2 JLL
- E-79: `stdlib/Zlib_jll/` - Zlib JLL
- E-80: `stdlib/LibGit2_jll/` - LibGit2 JLL
- E-81: `stdlib/LibSSH2_jll/` - LibSSH2 JLL
- E-82: `stdlib/OpenSSL_jll/` - OpenSSL JLL
- E-83: `stdlib/LLD_jll/` - LLD JLL
- E-84: `Makefile`, `Make.inc` - ビルドシステム
- E-85: `deps/` - 外部依存関係
- E-86: `test/` - テストスイート
- E-87: `base/binaryplatforms.jl` - バイナリプラットフォーム
- E-88: `base/hashing.jl` - ハッシュ関数
- E-89: `base/deepcopy.jl` - ディープコピー
- E-90: `base/accumulate.jl` - 累積演算
- E-91: `base/multimedia.jl` - マルチメディアI/O
- E-92: `base/logging/` - ロギング
- E-93: `README.md` - プロジェクト概要
- E-94: `AGENTS.md` - モジュール組織情報
- E-95: `VERSION` - バージョン情報（1.14.0-DEV）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プリミティブ型定義 | E-04, E-02 | ○ |
| C-02 | 複合型（構造体）定義 | E-04, E-02 | ○ |
| C-03 | 抽象型・Union型 | E-04, E-02 | ○ |
| C-04 | パラメトリック型 | E-04, E-02 | ○ |
| C-05 | 型変換・型昇格 | E-02, E-01 | ○ |
| C-06 | 整数演算 | E-02, E-16 | ○ |
| C-07 | 浮動小数点演算 | E-02, E-16 | ○ |
| C-08 | 数学関数 | E-02, E-16 | ○ |
| C-09 | 複素数演算 | E-02, E-16 | ○ |
| C-10 | 有理数演算 | E-02, E-16 | ○ |
| C-11 | 多倍長整数（BigInt） | E-17, E-02 | ○ |
| C-12 | 多倍長浮動小数点（BigFloat） | E-17, E-02 | ○ |
| C-13 | 高速数学演算（FastMath） | E-28, E-02 | ○ |
| C-14 | 組み合わせ数学 | E-02, E-01 | ○ |
| C-15 | Array（多次元配列） | E-05, E-02 | ○ |
| C-16 | Memory（メモリバッファ） | E-01, E-02 | ○ |
| C-17 | SubArray（ビュー） | E-01, E-02 | ○ |
| C-18 | BitArray | E-02, E-01 | ○ |
| C-19 | ブロードキャスト | E-08, E-02 | ○ |
| C-20 | 配列ソート | E-09, E-02 | ○ |
| C-21 | リダクション演算 | E-10, E-02 | ○ |
| C-22 | 累積演算 | E-90, E-02 | ○ |
| C-23 | 辞書（Dict） | E-11, E-02 | ○ |
| C-24 | 集合（Set） | E-11, E-02 | ○ |
| C-25 | Range（範囲） | E-02, E-01 | ○ |
| C-26 | イテレータ | E-02, E-03 | ○ |
| C-27 | 多次元配列操作 | E-01, E-02 | ○ |
| C-28 | 検索・探索 | E-02 | ○ |
| C-29 | 文字列基本操作 | E-06, E-02 | ○ |
| C-30 | 文字列検索・置換 | E-06, E-02 | ○ |
| C-31 | 文字列分割・結合 | E-06, E-02 | ○ |
| C-32 | 正規表現 | E-15, E-02 | ○ |
| C-33 | 文字（Char）操作 | E-01, E-02 | ○ |
| C-34 | 文字列変換・エンコーディング | E-02, E-06 | ○ |
| C-35 | IOストリーム | E-07, E-02 | ○ |
| C-36 | テキスト出力 | E-01, E-02 | ○ |
| C-37 | ファイルI/O | E-07, E-02 | ○ |
| C-38 | 標準入出力 | E-02, E-07 | ○ |
| C-39 | マルチメディアI/O | E-91, E-02 | ○ |
| C-40 | ロギング | E-92, E-02 | ○ |
| C-41 | パス操作 | E-19, E-02 | ○ |
| C-42 | ファイル操作 | E-19, E-02 | ○ |
| C-43 | ファイル情報 | E-19, E-02 | ○ |
| C-44 | 一時ファイル | E-19, E-02 | ○ |
| C-45 | ディレクトリ走査 | E-19, E-02 | ○ |
| C-46 | Task（コルーチン） | E-12, E-02 | ○ |
| C-47 | マルチスレッド | E-13, E-02 | ○ |
| C-48 | Channel | E-12, E-02 | ○ |
| C-49 | 同期プリミティブ | E-14, E-02 | ○ |
| C-50 | 非同期イベント | E-30, E-02 | ○ |
| C-51 | 非同期マッピング | E-30, E-02 | ○ |
| C-52 | アトミック操作 | E-01, E-02 | ○ |
| C-53 | ScopedValues | E-29, E-03 | ○ |
| C-54 | マクロ | E-02 | ○ |
| C-55 | 式オブジェクト（Expr） | E-02 | ○ |
| C-56 | コード生成（@generated） | E-02 | ○ |
| C-57 | マクロ展開 | E-02 | ○ |
| C-58 | eval | E-02 | ○ |
| C-59 | モジュールシステム | E-01, E-02 | ○ |
| C-60 | パッケージ読み込み | E-20, E-02 | ○ |
| C-61 | プリコンパイル | E-20, E-02 | ○ |
| C-62 | 例外機構 | E-24 | ○ |
| C-63 | 例外型 | E-02, E-24 | ○ |
| C-64 | エラー表示 | E-24, E-02 | ○ |
| C-65 | リトライ | E-24, E-02 | ○ |
| C-66 | ccall | E-21, E-02 | ○ |
| C-67 | ポインタ操作 | E-21, E-02 | ○ |
| C-68 | 動的ライブラリ | E-21, E-69 | ○ |
| C-69 | C型 | E-21, E-02 | ○ |
| C-70 | コマンド実行 | E-18, E-02 | ○ |
| C-71 | プロセス制御 | E-18, E-02 | ○ |
| C-72 | パイプライン | E-18, E-02 | ○ |
| C-73 | 型リフレクション | E-22, E-02 | ○ |
| C-74 | メソッドリフレクション | E-22, E-02 | ○ |
| C-75 | モジュールリフレクション | E-22, E-02 | ○ |
| C-76 | 計時 | E-23, E-02 | ○ |
| C-77 | GC制御 | E-01, E-02 | ○ |
| C-78 | 性能アノテーション | E-02 | ○ |
| C-79 | 型推論 | E-32, E-31 | ○ |
| C-80 | 型格子（Type Lattice） | E-33, E-31 | ○ |
| C-81 | 効果推論 | E-34, E-31 | ○ |
| C-82 | 最適化パス | E-35, E-31 | ○ |
| C-83 | 型推論ユーティリティ | E-36, E-31 | ○ |
| C-84 | コード生成（LLVM） | E-37 | ○ |
| C-85 | JITコンパイル | E-38 | ○ |
| C-86 | AOTコンパイル | E-39 | ○ |
| C-87 | GCランタイム | E-40 | ○ |
| C-88 | パーサー | E-49, E-01 | ○ |
| C-89 | 型システムランタイム | E-41 | ○ |
| C-90 | メモリ管理 | E-40 | ○ |
| C-91 | タスクスケジューラ | E-42 | ○ |
| C-92 | シグナル処理 | E-43 | ○ |
| C-93 | デバッグ情報 | E-44 | ○ |
| C-94 | セーフポイント | E-45 | ○ |
| C-95 | 初期化 | E-46 | ○ |
| C-96 | コマンドラインインタフェース | E-47, E-48 | ○ |
| C-97 | 動的ローダー | E-48 | ○ |
| C-98 | Dates | E-50 | ○ |
| C-99 | Random | E-51 | ○ |
| C-100 | Test | E-52 | ○ |
| C-101 | Printf | E-53 | ○ |
| C-102 | REPL | E-54 | ○ |
| C-103 | Serialization | E-55 | ○ |
| C-104 | Sockets | E-56 | ○ |
| C-105 | TOML | E-57 | ○ |
| C-106 | Markdown | E-58 | ○ |
| C-107 | Unicode | E-59 | ○ |
| C-108 | Base64 | E-60 | ○ |
| C-109 | SHA | **根拠なし** | △ |
| C-110 | CRC32c | E-61 | ○ |
| C-111 | UUIDs | E-62 | ○ |
| C-112 | Logging | E-63 | ○ |
| C-113 | Profile | E-64 | ○ |
| C-114 | InteractiveUtils | E-65 | ○ |
| C-115 | Mmap | E-66 | ○ |
| C-116 | FileWatching | E-67 | ○ |
| C-117 | SharedArrays | E-68 | ○ |
| C-118 | Libdl | E-69 | ○ |
| C-119 | LibGit2 | E-70 | ○ |
| C-120 | Artifacts | E-71 | ○ |
| C-121 | LinearAlgebra | **根拠なし** | △ |
| C-122 | SparseArrays | **根拠なし** | △ |
| C-123 | Pkg | **根拠なし** | △ |
| C-124 | Distributed | **根拠なし** | △ |
| C-125 | Statistics | **根拠なし** | △ |
| C-126 | DelimitedFiles | **根拠なし** | △ |
| C-127 | Downloads | **根拠なし** | △ |
| C-128 | Future | E-72 | ○ |
| C-129 | Docsシステム | E-27, E-02 | ○ |
| C-130 | ユーザーマニュアル | **根拠なし** | △ |
| C-131 | Enum | E-26, E-02 | ○ |
| C-132 | Missing型 | E-25, E-02 | ○ |
| C-133 | Option型 | E-25, E-02 | ○ |
| C-134 | ハッシュ関数 | E-88, E-02 | ○ |
| C-135 | 深いコピー | E-89, E-02 | ○ |
| C-136 | プラットフォーム検出 | E-87 | ○ |
| C-137 | Makefile | E-84 | ○ |
| C-138 | 依存関係管理 | E-85 | ○ |
| C-139 | テストスイート | E-86 | ○ |
| C-140 | GMP_jll | E-73 | ○ |
| C-141 | MPFR_jll | E-74 | ○ |
| C-142 | OpenBLAS_jll | E-75 | ○ |
| C-143 | SuiteSparse_jll | E-76 | ○ |
| C-144 | LibCURL_jll | E-77 | ○ |
| C-145 | PCRE2_jll | E-78 | ○ |
| C-146 | Zlib_jll | E-79 | ○ |
| C-147 | LibGit2_jll | E-80 | ○ |
| C-148 | LibSSH2_jll | E-81 | ○ |
| C-149 | OpenSSL_jll | E-82 | ○ |
| C-150 | LLD_jll | E-83 | ○ |

## 4) 不足情報（Unknown / Missing）
- No.109 SHA, No.121 LinearAlgebra, No.122 SparseArrays, No.123 Pkg, No.124 Distributed, No.125 Statistics, No.126 DelimitedFiles, No.127 Downloads は外部パッケージとして .version ファイルでバージョン管理されているが、実装コード自体はリポジトリ内に含まれていないため、機能の詳細説明は公式ドキュメント等に依存する
  - 候補：各パッケージのGitHubリポジトリ / julialang.org 公式ドキュメント / Pkg.version ファイル内のバージョン情報
- No.130 ユーザーマニュアルは doc/ ディレクトリの存在は確認したが、Documenter.jl による生成パイプラインの詳細構成は未検証
  - 候補：doc/make.jl / doc/src/ の内容確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - base/ 内の機能（No.1-78, 129, 131-136）はソースコードで直接確認済み
- 0: 低リスク - Compiler/ 内の機能（No.79-83）はソースコードで直接確認済み
- 0: 低リスク - src/ 内の機能（No.84-97）はソースコードで直接確認済み
- 0: 低リスク - stdlib/ 内のインツリーライブラリ（No.98-108, 110-120, 128）はソースコードで直接確認済み
- 1: 中リスク - 外部パッケージ（No.109, 121-127）はバージョンファイルのみで機能説明は一般的な知識に基づく
- 0: 低リスク - JLLパッケージ（No.140-150）はディレクトリの存在を確認済み
- 0: 低リスク - ビルドシステム・テスト（No.137-139）はファイルの存在を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 外部パッケージ（LinearAlgebra, SparseArrays, Pkg, Distributed, Statistics, DelimitedFiles, Downloads, SHA）の機能説明が最新バージョンと整合しているか確認
- [ ] 各機能の「備考」欄に記載されたファイルパスが正確かスポットチェック
- [ ] カテゴリの分類粒度が妥当か確認（特に「標準ライブラリ」と「JLLパッケージ」の分離が適切か）
- [ ] 主要な機能の見落としがないか確認（特にstdlib/内の追加ライブラリ）
- [ ] 重複する機能記述がないか確認
