# 機能設計書 114-InteractiveUtils

## 概要

本ドキュメントは、Julia標準ライブラリ `InteractiveUtils` モジュールの機能設計を記述する。@code_warntype、@code_llvm、@code_native、clipboard、edit等の対話的開発ユーティリティを提供するモジュールである。

### 本機能の処理概要

**業務上の目的・背景**：Juliaの開発者は、型推論の結果確認、生成コードの検査、エディタ連携などの対話的な開発支援ツールを必要とする。InteractiveUtilsモジュールは、REPL環境での対話的な開発を効率化するためのユーティリティ群を提供する。特に型安定性の確認（@code_warntype）やコンパイラ生成コードの確認（@code_llvm, @code_native）は、パフォーマンスチューニングにおいて不可欠なツールである。

**機能の利用シーン**：型推論結果の確認（@code_warntype）、LLVM IR の確認（@code_llvm）、ネイティブアセンブリの確認（@code_native）、低レベルコードの確認（@code_lowered, @code_typed）、クリップボード操作（clipboard）、エディタ起動（edit）、メソッド一覧の確認（methodswith, methods）、サブタイプ探索（subtypes）、ワークスペース情報の表示（varinfo）。

**主要な処理内容**：
1. コード検査マクロ：@code_warntype, @code_llvm, @code_native, @code_lowered, @code_typed でコンパイラの各段階の出力を表示
2. クリップボード操作：clipboard()でOS固有のクリップボード読み書き
3. エディタ連携：edit()でデフォルトエディタを起動しソースファイルを開く
4. 型システム探索：subtypes(), supertypes()で型階層を調査
5. メソッド探索：methodswith(), methods()でメソッドを検索
6. ワークスペース情報：varinfo()で現在のスコープの変数情報を表示
7. コンパイル追跡：@time_imports, @trace_compile, @trace_dispatch（Base からre-export）

**関連システム・外部連携**：Juliaコンパイラ（Base.Compiler）、OS固有のクリップボードコマンド（pbcopy/pbpaste on macOS、xsel/xclip on Linux）、エディタプロセス。

**権限による制御**：特になし。ただしクリップボード操作はOSのアクセス制御に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | REPL | 主画面 | 全ての対話的ユーティリティの実行環境 |

## 機能種別

開発支援ユーティリティ / コード分析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| f | Function | Yes (コード検査時) | 検査対象の関数 | 汎用関数であること（Core.Builtinは不可） |
| types | Tuple of Types | Yes (コード検査時) | 引数の型タプル | 有効なJulia型であること |
| x | Any | Yes (clipboard書込時) | クリップボードに書き込む内容 | print可能な値 |
| path | String | No (edit時) | 編集対象のファイルパス | 有効なファイルパス |
| line | Integer | No (edit時) | ジャンプ先の行番号 | 正の整数 |

### 入力データソース

- ユーザーのREPL入力
- Julia関数オブジェクトと引数型情報
- OSクリップボード（読み取り時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 型推論結果 | テキスト | @code_warntypeの色付き出力（不安定な型は赤で強調） |
| LLVM IR | テキスト | @code_llvmの構文ハイライト付きLLVM中間表現 |
| ネイティブコード | テキスト | @code_nativeのアセンブリ出力 |
| 低レベルIR | テキスト | @code_loweredのSSA形式IR |
| 型付きIR | テキスト | @code_typedの型注釈付きIR |
| クリップボード内容 | String | clipboard()の戻り値 |

### 出力先

- 標準出力（IOストリーム）
- OSクリップボード（clipboard(x)）
- エディタプロセス（edit()）

## 処理フロー

### 処理シーケンス

```
1. @code_warntype f(args...) の実行
   └─ マクロが関数fと引数型を抽出
   └─ ArgInfo構造体を構築（関数シグネチャの解決）
   └─ Base.code_typed()でIRと型情報を取得
   └─ 型安定性を分析し色付きで表示
2. clipboard(x) の実行
   └─ OS検出（macOS/Linux/Windows/その他）
   └─ OS固有のクリップボードコマンドを実行
   └─ データをパイプで渡す
3. edit(path, line) の実行
   └─ JULIA_EDITOR/VISUAL/EDITOR環境変数からエディタを決定
   └─ エディタプロセスを起動
```

### フローチャート

```mermaid
flowchart TD
    A["@code_warntype f(args...)"] --> B["関数と引数型を抽出"]
    B --> C["ArgInfo構造体を構築"]
    C --> D["Base.code_typed()呼び出し"]
    D --> E["型情報を分析"]
    E --> F{"型安定?"}
    F -->|安定| G["シアン色で表示"]
    F -->|不安定| H["赤色で強調表示"]
    G --> I["終了"]
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-114-01 | 型安定性警告 | Union型やCore.Box型は不安定として赤色で強調表示 | @code_warntype使用時 |
| BR-114-02 | クリップボードOS検出 | macOS: pbcopy/pbpaste, Linux: xsel/xclip/wl-copy | clipboard()使用時 |
| BR-114-03 | エディタ優先順位 | JULIA_EDITOR > VISUAL > EDITOR の順で検索 | edit()使用時 |
| BR-114-04 | 構文ハイライト | @code_llvm, @code_nativeは構文ハイライト付きで表示 | highlighting設定が有効時 |

### 計算ロジック

- @code_warntypeの型安定性判定: `Base.isdispatchelem(type)` がfalseかつ`type == Core.Box`の場合に不安定と判定
- 予期されるUnion型（`Base.Compiler.IRShow.is_expected_union`）は軽度の警告色で表示

## データベース操作仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentError | 引数エラー | Core.Builtin型の関数を渡した場合 | 汎用関数を使用する |
| - | クリップボード失敗 | xsel/xclipが未インストール | 適切なクリップボードツールをインストール |
| - | エディタ起動失敗 | EDITOR環境変数が未設定 | JULIA_EDITORまたはEDITOR環境変数を設定 |

### リトライ仕様

リトライ不要。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- コード検査マクロはコンパイラを呼び出すため、複雑な関数では数秒かかる場合がある
- clipboard()はOS外部コマンドを呼び出すため、ミリ秒オーダーの遅延がある

## セキュリティ考慮事項

- clipboard()はOSのクリップボードにアクセスするため、機密情報の漏洩に注意
- edit()は外部プロセスを起動するため、EDITOR環境変数の信頼性を確認すること

## 備考

- InteractiveUtilsは対話的環境（REPL）で自動的にusingされる
- @time_imports, @trace_compile, @trace_dispatchはBase内で定義され、InteractiveUtilsからre-exportされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ArgInfo構造体とハイライト設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | codeview.jl | `stdlib/InteractiveUtils/src/codeview.jl` | **4-8行目**: highlighting辞書（warntype/llvm/nativeの有効無効設定） |
| 1-2 | codeview.jl | `stdlib/InteractiveUtils/src/codeview.jl` | **23-43行目**: ArgInfo構造体 -- 関数と引数型をラップし、OpaqueClosure対応 |

**読解のコツ**: ArgInfoはコード検査マクロの共通基盤。関数オブジェクトと型タプルからメソッドシグネチャを解決する。

#### Step 2: エントリーポイントを理解する

マクロ定義ファイルとメインモジュールファイル。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | モジュール定義、export宣言、include文で構成ファイルを確認 |
| 2-2 | macros.jl | `stdlib/InteractiveUtils/src/macros.jl` | **1-80行目**: マクロラッパー群の共通基盤。typesof_expr、extract_where_parameters等のヘルパー |

**主要処理フロー**:
1. **macros.jl 12行目**: `typesof_expr` -- 引数から型タプルを構築するヘルパー
2. **macros.jl 40-43行目**: `extract_where_parameters` -- where句のパラメータを抽出
3. **codeview.jl 52-65行目**: `warntype_type_printer` -- 型安定性に基づく色付き表示

#### Step 3: クリップボード操作を理解する

OS固有の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | clipboard.jl | `stdlib/InteractiveUtils/src/clipboard.jl` | **5-31行目**: macOSのpbcopy/pbpaste実装。tmux内での`reattach-to-user-namespace`対応 |
| 3-2 | clipboard.jl | `stdlib/InteractiveUtils/src/clipboard.jl` | **33-49行目**: Linux/FreeBSDのxsel/xclip/wl-clipboard対応 |

### プログラム呼び出し階層図

```
@code_warntype f(args...)
    |
    +-- macros.jl: @code_warntype マクロ展開
    |   +-- typesof_expr(args)           # 型タプル構築
    |
    +-- codeview.jl: code_warntype(io, f, types)
        +-- ArgInfo(f, types)            # シグネチャ解決
        +-- Base.code_typed(...)         # コンパイラ呼び出し
        +-- print_warntype_codeinfo()    # 色付き出力
            +-- warntype_type_printer()  # 型安定性判定

clipboard(x)
    |
    +-- clipboard.jl: OS判定
        +-- macOS: open(pipeline(pbcopy), "w")
        +-- Linux: open(pipeline(xsel/xclip/wl-copy), "w")
        +-- Windows: ccall
```

### データフロー図

```
[入力]               [処理]                          [出力]

関数+型情報    ───▶  @code_warntype              ───▶  色付きIR表示
                     Base.code_typed()                  (stdout)
                     型安定性分析

テキスト       ───▶  clipboard(x)               ───▶  OSクリップボード
                     OS固有コマンド実行

ファイルパス   ───▶  edit(path, line)            ───▶  エディタプロセス
                     EDITOR環境変数参照
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | ソース | メインモジュール定義。export、include |
| macros.jl | `stdlib/InteractiveUtils/src/macros.jl` | ソース | コード検査マクロの定義（@code_warntype等） |
| codeview.jl | `stdlib/InteractiveUtils/src/codeview.jl` | ソース | コード表示ロジック、ハイライト、ArgInfo |
| clipboard.jl | `stdlib/InteractiveUtils/src/clipboard.jl` | ソース | OS固有クリップボード操作 |
| editless.jl | `stdlib/InteractiveUtils/src/editless.jl` | ソース | edit()とless()の実装 |
| Project.toml | `stdlib/InteractiveUtils/Project.toml` | 設定 | パッケージ依存関係定義 |
