# 機能設計書 123-Pkg

## 概要

本ドキュメントは、Julia標準ライブラリの Pkg パッケージマネージャに関する機能設計書である。Pkg はパッケージの追加・削除・更新・依存解決・インスタンス化などのパッケージ管理コマンドを提供する外部パッケージとして Julia に同梱されている。

### 本機能の処理概要

Pkg は Julia のパッケージエコシステムの中核を成すパッケージマネージャである。パッケージの検索・追加・削除・更新・依存関係解決・環境管理を提供し、再現性のある開発環境構築を可能にする。

**業務上の目的・背景**：ソフトウェア開発においてパッケージ管理は不可欠であり、依存関係の解決、バージョン管理、再現可能な環境構築を自動化する。Pkg はTOML形式のマニフェストファイル（Project.toml / Manifest.toml）により、プロジェクトの依存関係を宣言的に管理する。これによりチーム開発やCI/CDにおける環境の再現性を保証する。

**機能の利用シーン**：新規パッケージの追加（`add`）、不要パッケージの削除（`rm`）、パッケージの更新（`update`）、環境のインスタンス化（`instantiate`）、パッケージの開発モード追加（`develop`）、レジストリの管理、Artifactsの管理など。REPLの`]`キーでPkgモードに遷移して対話的に操作することも可能。

**主要な処理内容**：
1. パッケージの追加・削除・更新（add / rm / update）
2. 依存関係の解決（resolve）
3. 環境のインスタンス化（instantiate）
4. Project.toml / Manifest.toml の管理
5. パッケージレジストリの管理
6. Artifactsシステムによるバイナリ依存関係の管理
7. パッケージの開発モード（develop / free）

**関連システム・外部連携**：General Registry（パッケージレジストリ）、GitHub/GitLab等のGitリポジトリ、Artifactsシステム、TOMLパーサー、LibGit2、Downloads。

**権限による制御**：ファイルシステムの書き込み権限が必要（~/.julia/ ディレクトリ）。プライベートレジストリではSSH鍵やトークンによる認証が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | Pkgモード（pkg>） | 主機能 | Pkg.jlのadd/rm/update/resolve/instantiate等のパッケージ管理コマンド実行 |

## 機能種別

データ連携 / CRUD操作（パッケージ管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pkg | String/PackageSpec | Yes | パッケージ名またはPackageSpec | レジストリに存在するか確認 |
| version | VersionSpec | No | バージョン制約 | セマンティックバージョニング形式 |
| url | String | No | GitリポジトリURL | 有効なURL形式 |
| rev | String | No | Gitリビジョン（ブランチ/タグ/SHA） | 有効なGit参照 |
| path | String | No | ローカルパス（develop時） | 有効なファイルパス |

### 入力データソース

REPL Pkgモードからの対話的入力、またはJuliaコードからのAPI呼び出し。Project.toml / Manifest.toml からのプロジェクト設定読み込み。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Project.toml | TOMLファイル | プロジェクトの依存関係宣言 |
| Manifest.toml | TOMLファイル | 解決済み依存関係の完全なスナップショット |
| パッケージソース | ディレクトリ | ダウンロード・展開されたパッケージソースコード |
| Artifacts | ディレクトリ | ダウンロードされたバイナリアーティファクト |

### 出力先

`~/.julia/` ディレクトリ配下（packages/、artifacts/、registries/等）。プロジェクトディレクトリのProject.toml / Manifest.toml。

## 処理フロー

### 処理シーケンス

```
1. コマンド解析（REPLモードまたはAPI呼び出し）
   └─ PackageSpecの構築
2. レジストリ検索・パッケージ情報取得
   └─ General Registry からのパッケージメタデータ取得
3. 依存関係解決（SAT ソルバベース）
   └─ バージョン制約を満たす依存関係グラフの構築
4. パッケージダウンロード・インストール
   └─ Git clone またはtarball取得
5. Manifest.toml の更新
   └─ 解決済み依存関係の永続化
6. プリコンパイル（必要に応じて）
   └─ パッケージイメージの生成
```

### フローチャート

```mermaid
flowchart TD
    A[Pkg.add コマンド] --> B[レジストリ検索]
    B --> C[依存関係解決]
    C --> D{解決成功?}
    D -->|Yes| E[パッケージダウンロード]
    D -->|No| F[ResolverError]
    E --> G[Manifest.toml更新]
    G --> H[プリコンパイル]
    H --> I[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-123-01 | セマンティックバージョニング | パッケージバージョンはSemVer準拠 | すべてのバージョン指定 |
| BR-123-02 | 互換性ルール | [compat]セクションでの互換性制約遵守 | 依存関係解決時 |
| BR-123-03 | 環境分離 | プロジェクト環境は独立したProject.toml/Manifest.tomlで管理 | 環境操作時 |
| BR-123-04 | レジストリ優先度 | 複数レジストリがある場合は登録順序で優先度決定 | パッケージ検索時 |

### 計算ロジック

依存関係解決はSATソルバベースのアルゴリズムを使用。バージョン制約をブール充足可能性問題に変換して解決する。

## データベース操作仕様

### 操作別データベース影響一覧

データベースは使用しない。TOMLファイルベースの設定管理。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ResolverError | 依存関係の解決不可能 | バージョン制約の緩和、conflictの確認 |
| - | PkgError | パッケージが見つからない | パッケージ名・レジストリ設定を確認 |
| - | DownloadError | パッケージのダウンロード失敗 | ネットワーク接続・URLを確認 |
| - | PrecompileError | プリコンパイル失敗 | パッケージの互換性・依存関係を確認 |

### リトライ仕様

ダウンロード失敗時は自動リトライが実装されている（Downloads.jl経由）。

## トランザクション仕様

Manifest.tomlの更新はアトミックな書き込み（一時ファイル経由のリネーム）で行われる。

## パフォーマンス要件

依存関係解決のパフォーマンスはパッケージ数とバージョン制約の複雑さに依存。大規模プロジェクトでも数秒以内に解決することが期待される。

## セキュリティ考慮事項

- パッケージソースの整合性はGit SHA1ハッシュで検証
- Artifactsのチェックサムはcontent-hashで検証
- プライベートレジストリ/リポジトリへのアクセスにはSSH鍵またはトークンが必要

## 備考

- Pkg は外部パッケージ（https://github.com/JuliaLang/Pkg.jl）として管理されている
- Julia本体には `stdlib/Pkg.version` ファイルでバージョン管理されている
- コミットSHA1: adbb0f68b6cec6a9bf443c16890980286d5cfffa
- REPLの`]`キーでPkgモードに遷移可能
- doc/make.jl のEXT_STDLIB_DOCS（49行目）にPkgが含まれ、basedocs.mdが使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: パッケージ参照設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Pkg.version | `stdlib/Pkg.version` | ブランチ(master)・SHA1・Git URL(JuliaLang/Pkg.jl)の管理方法 |

**読解のコツ**: Pkg.version ファイルのSHA1が実際にJuliaに同梱されるPkgのバージョンを特定する。

#### Step 2: REPL統合を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | 画面機能マッピング.csv | `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` | **34-38行目**: Pkgモード（画面No.5）の関連機能定義 |

**主要処理フロー**:
1. **34行目**: `]`キー押下でPkgモード遷移
2. **36行目**: require/importによるPkg.jlモジュールの遅延読み込み
3. **38行目**: TOMLパーサーによるProject.toml/Manifest.toml読み書き

#### Step 3: ドキュメント統合を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | make.jl | `doc/make.jl` | **49行目**: `EXT_STDLIB_DOCS = ["Pkg"]` - Pkgは特別扱いでbasedocs.mdを使用 |
| 3-2 | make.jl | `doc/make.jl` | **373-378行目**: PkgのDocTestSetupで`using Pkg, Pkg.Artifacts`が設定 |

### プログラム呼び出し階層図

```
REPLで「]」キー押下
    |
    +-- REPL.Pkgモード起動
    |       +-- Base.require("Pkg") [遅延読み込み]
    |
    +-- Pkg モジュール
            |
            +-- Pkg.add(pkg)
            |       +-- レジストリ検索
            |       +-- 依存関係解決 (Resolver)
            |       +-- ダウンロード (Downloads.jl)
            |       +-- Manifest.toml更新
            |       +-- プリコンパイル
            |
            +-- Pkg.rm(pkg)
            +-- Pkg.update()
            +-- Pkg.resolve()
            +-- Pkg.instantiate()
            +-- Pkg.develop(pkg)
            +-- Pkg.Artifacts (バイナリ依存管理)
```

### データフロー図

```
[入力]                   [処理]                        [出力]

コマンド入力      ──> PackageSpec構築          ──> 解析済みコマンド
レジストリ        ──> 依存関係解決(SAT)        ──> 解決済みバージョンマップ
Git/tarball       ──> ダウンロード・展開        ──> パッケージソース
Project.toml      ──> TOML解析               ──> 依存関係宣言
                       |
                       v
                  Manifest.toml更新         ──> 永続化された解決結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Pkg.version | `stdlib/Pkg.version` | 設定 | パッケージバージョン管理 |
| make.jl | `doc/make.jl` | ビルドスクリプト | ドキュメント生成設定（EXT_STDLIB_DOCS） |
| 画面機能マッピング.csv | `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` | 設計書 | Pkgモード画面の機能マッピング |
