# 機能設計書 126-DelimitedFiles

## 概要

本ドキュメントは、Julia標準ライブラリの DelimitedFiles パッケージに関する機能設計書である。DelimitedFiles は CSV/TSV ファイルの読み書き（readdlm / writedlm）を提供する外部パッケージとして Julia に同梱されている。

### 本機能の処理概要

DelimitedFiles は、区切り文字で構造化されたテキストファイル（CSV、TSV等）のI/O機能を提供する。行列やベクトルのデータをテキストファイルとして読み書きするための簡潔なインタフェースを提供し、データのインポート・エクスポートを容易にする。

**業務上の目的・背景**：CSV/TSVファイルはデータ交換の最も一般的なフォーマットの一つであり、スプレッドシート・データベースエクスポート・科学計測データ等で広く使用されている。DelimitedFiles はこれらのファイルをJuliaの配列として効率的に読み込み、またJuliaの配列データをCSV/TSV形式で出力する機能を提供する。

**機能の利用シーン**：実験データのCSV読み込み、計算結果のCSV出力、データベースエクスポートファイルの処理、スプレッドシートデータの読み込み、ログファイルの解析など。

**主要な処理内容**：
1. 区切り文字ファイルの読み込み（readdlm）
2. 区切り文字ファイルへの書き出し（writedlm）
3. 型推論による自動型変換
4. ヘッダ行の処理
5. カスタム区切り文字のサポート
6. コメント行のスキップ

**関連システム・外部連携**：ファイルシステム、IOストリーム。

**権限による制御**：ファイルの読み書き権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面に直接関連する操作はない（ライブラリとして利用） |

## 機能種別

データ連携（ファイルI/O）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| source | String/IO | Yes | 読み込み元のファイルパスまたはIOストリーム | ファイル存在確認 |
| delim | Char | No | 区切り文字（デフォルト: コンマまたは空白） | 任意の文字 |
| T | Type | No | 要素の型（デフォルト: 自動推論） | 有効な型 |
| eol | Char | No | 行末文字（デフォルト: '\n'） | 任意の文字 |
| header | Bool | No | ヘッダ行の有無（デフォルト: false） | true/false |
| skipstart | Int | No | スキップする先頭行数 | 非負整数 |
| comments | Bool | No | コメント行処理（デフォルト: false） | true/false |
| comment_char | Char | No | コメント文字（デフォルト: '#'） | 任意の文字 |

### 入力データソース

ファイルシステム上のCSV/TSVファイル、またはIOストリーム。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| data | Matrix{T} | 読み込まれたデータ行列 |
| header | Vector{AbstractString} | ヘッダ行の文字列ベクトル（header=true時） |

### 出力先

readdlm: 呼び出し元への戻り値。writedlm: ファイルまたはIOストリーム。

## 処理フロー

### 処理シーケンス

```
1. ファイル/IOストリームのオープン
   └─ open() によるファイルアクセス
2. ヘッダ行・コメント行の処理
   └─ header=trueの場合は最初の行をヘッダとして分離
3. データ行の解析
   └─ 区切り文字で分割、型変換
4. 行列への格納
   └─ Matrix{T} の構築
5. 結果の返却
   └─ (data, header) のタプルまたは data のみ
```

### フローチャート

```mermaid
flowchart TD
    A[ファイルオープン] --> B{header=true?}
    B -->|Yes| C[ヘッダ行読み込み]
    B -->|No| D[データ読み込み開始]
    C --> D
    D --> E[行ごとに区切り文字で分割]
    E --> F[型変換]
    F --> G[Matrix構築]
    G --> H[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-126-01 | 自動区切り推論 | 拡張子.csvの場合はカンマ、それ以外は空白を区切りとして推論 | delim未指定時 |
| BR-126-02 | 型推論 | データ内容から自動的に数値型/文字列型を推論 | T未指定時 |
| BR-126-03 | 矩形データ | すべての行が同じ列数であることを期待 | readdlm |
| BR-126-04 | エンコーディング | UTF-8エンコーディングを想定 | テキストファイル読み書き |

### 計算ロジック

特筆すべき計算ロジックはない。テキスト解析とデータ変換が主な処理。

## データベース操作仕様

### 操作別データベース影響一覧

データベースは使用しない。ファイルI/Oのみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | SystemError | ファイルが存在しない/読み取り不可 | ファイルパス・権限を確認 |
| - | ArgumentError | 不正な引数 | 引数の妥当性を確認 |
| - | 型変換エラー | データが指定型に変換不可 | データ内容・型指定を確認 |

### リトライ仕様

リトライは不要。

## トランザクション仕様

トランザクションは使用しない。ファイル書き込みは逐次的。

## パフォーマンス要件

大規模ファイルではメモリ使用量に注意。ファイル全体をメモリに読み込むため、利用可能メモリ以上のファイルは処理不可。

## セキュリティ考慮事項

- ファイルパスのバリデーション（パストラバーサル防止）
- 信頼できないソースからのCSVファイル読み込み時はデータ内容の検証が必要

## 備考

- DelimitedFiles は外部パッケージ（https://github.com/JuliaData/DelimitedFiles.jl）として管理されている
- Julia本体には `stdlib/DelimitedFiles.version` ファイルでバージョン管理されている
- コミットSHA1: aac8c59e58cbf961fa15baf4d866901d9d1e6980
- JuliaData組織のリポジトリで管理されている
- より高機能なCSV処理にはCSV.jlパッケージの使用が推奨される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: パッケージ参照設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DelimitedFiles.version | `stdlib/DelimitedFiles.version` | ブランチ(main)・SHA1・Git URL(JuliaData/DelimitedFiles.jl)の管理方法 |

**読解のコツ**: DelimitedFiles はJuliaData組織のリポジトリで管理されている。ブランチ名がmasterではなくmainである点に注意。

#### Step 2: 基盤となるI/O機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | iostream.jl | `base/iostream.jl` | ファイル読み書きの基盤となるIOStream型の理解 |
| 2-2 | io.jl | `base/io.jl` | read/write/readline等のI/O基本関数 |

### プログラム呼び出し階層図

```
using DelimitedFiles
    |
    +-- Base.require("DelimitedFiles")
    |
    +-- DelimitedFiles モジュール
            |
            +-- readdlm(source, delim, T; kwargs...)
            |       +-- open(source) [ファイルの場合]
            |       +-- 行ごとの読み込み
            |       +-- 区切り文字分割
            |       +-- 型変換
            |       +-- Matrix{T} 構築
            |
            +-- writedlm(dest, data, delim; kwargs...)
                    +-- open(dest, "w") [ファイルの場合]
                    +-- 行ごとの書き出し
                    +-- 区切り文字挿入
```

### データフロー図

```
[入力]                   [処理]                        [出力]

CSVファイル       ──> readdlm()解析            ──> Matrix{T}
Matrix{T}        ──> writedlm()書き出し        ──> CSVファイル
IOストリーム      ──> readdlm()解析            ──> Matrix{T}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DelimitedFiles.version | `stdlib/DelimitedFiles.version` | 設定 | パッケージバージョン管理 |
| iostream.jl | `base/iostream.jl` | ソース | I/O基盤 |
| io.jl | `base/io.jl` | ソース | 基本I/O関数 |
