# 機能設計書 127-Downloads

## 概要

本ドキュメントは、Julia標準ライブラリの Downloads パッケージに関する機能設計書である。Downloads は HTTP/HTTPS ファイルダウンロード（download）機能を提供する外部パッケージとして Julia に同梱されている。

### 本機能の処理概要

Downloads は、HTTP/HTTPS プロトコルを使用したファイルのダウンロード機能を提供する。libcurl をバックエンドとして使用し、URLからファイルやデータをダウンロードするための高レベルAPIを提供する。

**業務上の目的・背景**：パッケージのダウンロード、データセットの取得、Web APIからのデータ取得など、ネットワーク経由のリソース取得はプログラミングにおいて頻繁に必要となる操作である。Downloads はlibcurlのJuliaラッパーとして、安全かつ効率的なHTTP/HTTPSダウンロード機能を提供し、Pkgパッケージマネージャのバックエンドとしても使用される。

**機能の利用シーン**：パッケージダウンロード（Pkg経由）、データセットの取得、Webリソースのダウンロード、APIレスポンスの取得、バイナリアーティファクトのダウンロードなど。

**主要な処理内容**：
1. HTTP/HTTPSファイルダウンロード（download）
2. リクエストの実行（request）
3. プログレス表示
4. リダイレクト追跡
5. TLS/SSL接続
6. リトライ機構

**関連システム・外部連携**：LibCURL_jll（libcurl）、OpenSSL_jll（TLS/SSL）、ネットワーク接続。

**権限による制御**：ネットワークアクセス権限が必要。プロキシ設定はシステム環境変数で制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面に直接関連する操作はない（バックエンドライブラリとして利用） |

## 機能種別

データ連携（ネットワークI/O）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| url | String | Yes | ダウンロード元URL | 有効なHTTP/HTTPS URL |
| output | String/IO | No | 保存先ファイルパスまたはIOストリーム | 書き込み可能なパス |
| headers | Vector{Pair} | No | HTTPリクエストヘッダ | 有効なHTTPヘッダ |
| progress | Function | No | プログレスコールバック | 呼び出し可能 |
| verbose | Bool | No | 詳細ログ出力 | true/false |

### 入力データソース

HTTP/HTTPS URL。環境変数による設定（HTTP_PROXY, HTTPS_PROXY等）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| filepath | String | ダウンロードされたファイルのパス |
| response | Response | HTTPレスポンス情報（ステータスコード、ヘッダ等） |
| data | Vector{UInt8} | ダウンロードされたデータのバイト列 |

### 出力先

ファイルシステム上のファイル、またはIOストリーム。

## 処理フロー

### 処理シーケンス

```
1. URL解析・バリデーション
   └─ HTTP/HTTPSスキームの確認
2. libcurl初期化・オプション設定
   └─ TLS/SSL設定、ヘッダ設定、プロキシ設定
3. HTTP接続・リクエスト送信
   └─ libcurl_easy_perform相当
4. リダイレクト追跡（必要に応じて）
   └─ 301/302/307リダイレクトの自動追跡
5. データ受信・保存
   └─ ファイルまたはメモリバッファへの書き込み
6. 結果の返却
   └─ ファイルパスまたはレスポンスオブジェクト
```

### フローチャート

```mermaid
flowchart TD
    A[URL指定] --> B[libcurl初期化]
    B --> C[HTTP接続]
    C --> D{リダイレクト?}
    D -->|Yes| C
    D -->|No| E{ステータスコード}
    E -->|2xx| F[データ受信]
    E -->|4xx/5xx| G[エラー処理]
    F --> H[ファイル保存]
    H --> I[結果返却]
    G --> J{リトライ?}
    J -->|Yes| C
    J -->|No| K[エラースロー]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-127-01 | HTTPS優先 | セキュアな接続（HTTPS）を優先 | URL指定時 |
| BR-127-02 | リダイレクト追跡 | HTTPリダイレクトを自動追跡（上限あり） | 3xxレスポンス時 |
| BR-127-03 | プロキシ対応 | 環境変数によるプロキシ設定を尊重 | HTTP_PROXY等設定時 |
| BR-127-04 | 証明書検証 | SSL/TLS証明書の検証をデフォルトで有効 | HTTPS接続時 |

### 計算ロジック

特筆すべき計算ロジックはない。ネットワークI/O処理。

## データベース操作仕様

### 操作別データベース影響一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RequestError | HTTPリクエスト失敗 | URLとネットワーク接続を確認 |
| - | StatusError | HTTPステータスエラー（4xx/5xx） | URLの妥当性を確認 |
| - | SSL/TLSエラー | 証明書検証失敗 | 証明書設定を確認 |
| - | TimeoutError | 接続/ダウンロードタイムアウト | ネットワーク状態を確認 |

### リトライ仕様

一時的なネットワークエラー時に自動リトライが実装されている。

## トランザクション仕様

トランザクションは使用しない。ダウンロードは一時ファイルへの書き込み後にリネームする安全な方式を採用。

## パフォーマンス要件

ダウンロード速度はネットワーク帯域幅に依存。大きなファイルのダウンロード時はストリーミング書き込みにより、メモリ使用量を抑制。

## セキュリティ考慮事項

- HTTPS（TLS/SSL）による暗号化通信
- 証明書検証によるなりすまし防止
- プロキシ設定による企業ネットワーク対応
- ダウンロードファイルのチェックサム検証は呼び出し元の責任

## 備考

- Downloads は外部パッケージ（https://github.com/JuliaLang/Downloads.jl）として管理されている
- Julia本体には `stdlib/Downloads.version` ファイルでバージョン管理されている
- コミットSHA1: f72cd4d87b424fc48e1137c1fd1fbcec18f49371
- LibCURL_jll がlibcurlバイナリを提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: パッケージ参照設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Downloads.version | `stdlib/Downloads.version` | ブランチ(master)・SHA1・Git URL(JuliaLang/Downloads.jl)の管理方法 |

**読解のコツ**: Downloads は libcurl のJuliaラッパーであり、LibCURL_jll パッケージが実際のlibcurlバイナリを提供する。

#### Step 2: JLL依存関係を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LibCURL_jll | `stdlib/LibCURL_jll/` | libcurlライブラリのバイナリ提供 |
| 2-2 | OpenSSL_jll | `stdlib/OpenSSL_jll/` | TLS/SSL実装の提供 |

### プログラム呼び出し階層図

```
Downloads.download(url, output)
    |
    +-- Downloads.request(url; ...)
    |       +-- libcurl 初期化
    |       +-- SSL/TLS設定
    |       +-- ヘッダ設定
    |       +-- curl_easy_perform (ccall via LibCURL_jll)
    |       +-- リダイレクト追跡
    |       +-- データ受信
    |
    +-- ファイル書き込み
            +-- 一時ファイルへの書き込み
            +-- リネーム（アトミック更新）
```

### データフロー図

```
[入力]                   [処理]                        [出力]

URL             ──> libcurl HTTP(S)リクエスト   ──> レスポンスデータ
ヘッダ/設定      ──> curl_easy_setopt            ──> 設定済みcurlハンドル
レスポンスデータ  ──> ファイル書き込み             ──> ダウンロード済みファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Downloads.version | `stdlib/Downloads.version` | 設定 | パッケージバージョン管理 |
| LibCURL_jll | `stdlib/LibCURL_jll/` | JLLパッケージ | libcurlバイナリ提供 |
| OpenSSL_jll | `stdlib/OpenSSL_jll/` | JLLパッケージ | TLS/SSL実装提供 |
