# 機能設計書 130-ユーザーマニュアル

## 概要

本ドキュメントは、Julia のユーザーマニュアル生成パイプラインに関する機能設計書である。Documenter.jl ベースの HTML/PDF マニュアル生成システムとして `doc/` ディレクトリに実装されている。

### 本機能の処理概要

Julia のユーザーマニュアル生成パイプラインは、Markdown 形式で記述されたドキュメントソースとソースコード中のdocstringを、Documenter.jl を使用してHTML/PDF形式のドキュメントに変換・公開するシステムである。

**業務上の目的・背景**：プログラミング言語のユーザーマニュアルは、言語の普及・学習・開発に不可欠なリソースである。Julia のマニュアルは https://docs.julialang.org で公開されており、Manual（言語仕様）、Base（標準ライブラリAPI）、Standard Library（標準パッケージ）、Developer Documentation（内部実装）の4セクションで構成される。Documenter.jl による自動ビルドとGitHub Pagesへのデプロイにより、ソースコードの変更に追従した最新のドキュメントが常に公開される。

**機能の利用シーン**：Julia公式ドキュメントのビルド・公開、docstringのテスト（doctest）、リンクチェック、ローカルでのドキュメントプレビュー、PDFマニュアルの生成、CI/CDパイプラインでのドキュメントデプロイ。

**主要な処理内容**：
1. Documenter.jl の依存関係インストール（sandboxed depot）
2. 外部stdlibドキュメントのシンボリックリンク作成
3. 外部stdlibのGitリモート情報構築（ソースリンク用）
4. NEWS.md からのリリースノート生成
5. DocTestSetup の設定（各stdlibモジュール用）
6. Documenter.makedocs によるHTML/PDF生成
7. Documenter.deploydocs によるGitHub Pagesデプロイ
8. 外部stdlibのURLリライト（正しいリポジトリへのリンク修正）

**関連システム・外部連携**：Documenter.jl（ドキュメント生成エンジン）、GitHub Pages（デプロイ先）、LibGit2（Gitリモート情報）、Pkg（依存関係管理）、Revise（doctest時のコード変更追跡）。

**権限による制御**：デプロイにはDOCUMENTER_KEY環境変数（SSH鍵）が必要。ローカルビルドには特別な権限不要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面に直接関連する操作はない（ビルドパイプラインとして機能） |

## 機能種別

帳票出力（ドキュメント生成パイプライン）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| doctest | String | No | doctestモード（true/fix/only） | true/fix/only/false |
| linkcheck | String | No | リンクチェック有効化 | true/false |
| revise | String | No | Revise使用（コード変更反映） | true/false |
| deploy | フラグ | No | デプロイ実行 | ARGSに"deploy"を含む |
| pdf | フラグ | No | PDF生成 | ARGSに"pdf"を含む |
| buildroot | String | No | ビルドルートディレクトリ | 有効なパス |
| stdlibdir | String | No | stdlibディレクトリ | 有効なパス |

### 入力データソース

`doc/src/` ディレクトリのMarkdownファイル、ソースコード中のdocstring、`stdlib/*/docs/` のstdlibドキュメント。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTML | HTMLファイル群 | doc/_build/html/en/ に出力 |
| PDF | PDFファイル | doc/_build/pdf/en/ に出力（pdf指定時） |

### 出力先

ローカル: `doc/_build/` ディレクトリ。デプロイ: `docs.julialang.org` GitHubリポジトリ。

## 処理フロー

### 処理シーケンス

```
1. 環境設定
   └─ buildroot / stdlibdir の解決
2. Documenter.jl の依存関係インストール
   └─ Pkg.activate / Pkg.instantiate
3. 外部stdlibドキュメントのリンク作成
   └─ STDLIB_DIR内の各パッケージのdocs/src/index.mdをsymlink
4. 外部stdlibのGitリモート情報構築
   └─ *.versionファイルからGit URL・SHA1を抽出
5. NEWS.md の加工
   └─ GitHub issueリンクの変換
6. DocTestSetup の設定
   └─ 各stdlibモジュール用のusing文設定
7. makedocs の実行
   └─ MarkdownのHTML/PDF変換、doctest実行
8. 外部stdlibのURLリライト
   └─ JuliaLang/julia リポジトリURLを正しい外部リポジトリURLに変換
9. deploydocs の実行（deploy指定時）
   └─ GitHub Pagesへのデプロイ
```

### フローチャート

```mermaid
flowchart TD
    A[make html/pdf/deploy] --> B[Documenter.jl依存インストール]
    B --> C[stdlibドキュメントリンク作成]
    C --> D[Gitリモート情報構築]
    D --> E[NEWS.md加工]
    E --> F[DocTestSetup設定]
    F --> G[makedocs実行]
    G --> H[URLリライト]
    H --> I{deploy指定?}
    I -->|Yes| J[deploydocs実行]
    I -->|No| K[完了]
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-130-01 | EXT_STDLIB_DOCS | Pkgのみが外部stdlibとして特別扱い（basedocs.mdを使用） | stdlibドキュメントリンク作成時 |
| BR-130-02 | バージョン付きデプロイ | タグ付きコミットはバージョン番号でデプロイ、masterはdevでデプロイ | deploydocs実行時 |
| BR-130-03 | リリースブランチ対応 | release-X.Y ブランチは vX.Y-dev としてデプロイ | deploydocs実行時 |
| BR-130-04 | URLリライト | 外部stdlibのGitHub URLを正しいリポジトリに変換 | ビルド後のHTML処理時 |
| BR-130-05 | SparseArrays DocTestSetup | SparseArraysはLinearAlgebraも同時にusingするDocTestSetup | doctest設定時 |

### 計算ロジック

特筆すべき計算ロジックはない。テキスト変換とドキュメント生成が主な処理。

## データベース操作仕様

### 操作別データベース影響一覧

データベースは使用しない。ファイルシステムベースの処理。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DocTestError | doctestの出力不一致 | docstringのコード例を修正 |
| - | LinkCheckError | 壊れたリンクの検出 | リンク先URLを修正 |
| - | MissingKey | *.versionファイルにGIT_URL/SHA1がない | versionファイルを修正 |
| - | Documenter.DeployDecision(all_ok=false) | デプロイ条件不成立 | DOCUMENTER_KEY・ブランチ設定を確認 |

### リトライ仕様

リトライは不要。ビルドエラーは入力データの問題。

## トランザクション仕様

トランザクションは使用しない。

## パフォーマンス要件

フルドキュメントビルドには数分〜15分程度要する。doctestの実行は最も時間がかかる工程（最大15分）。Revise使用時はソースツリーの再ビルドなしでdoctest可能。

## セキュリティ考慮事項

- DOCUMENTER_KEY 環境変数によるデプロイ認証（SSH鍵）
- GitHub Pagesへのデプロイはブランチ・タグのチェックで制御
- 外部stdlibのURLリライトでリポジトリURLの正当性を保証

## 備考

- ドキュメントソースは `doc/src/` に配置
- Manual / Base / Standard Library / Developer Documentation の4セクション構成
- `doc/Makefile` がビルドのエントリーポイント
- `doc/make.jl` がDocumenter.jlを使用した実際のビルドスクリプト
- UnicodeData.txt のダウンロードとチェックサム検証が依存関係に含まれる
- ドキュメントは https://docs.julialang.org で公開
- 外部stdlibリポジトリへのリンク修正に正規表現ベースのURLリライトを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビルドシステムのエントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Makefile | `doc/Makefile` | ビルドターゲット（html/pdf/deploy）の定義。JULIA_EXECUTABLE、DOCUMENTER_OPTIONS の設定方法 |

**読解のコツ**: `doc/Makefile` は `$(JULIAHOME)/Make.inc` をインクルードしてJulia本体のビルド設定を継承する。`JULIA_EXECUTABLE` はビルド済みのjuliaバイナリ。

**主要処理フロー**:
- **62-65行目**: `html` ターゲット。`deps` に依存し、`make.jl` を実行
- **67-71行目**: `pdf` ターゲット。`make.jl` に `pdf` 引数を渡す
- **74-78行目**: `deploy` ターゲット。CI専用。`make.jl` に `deploy` 引数を渡す

#### Step 2: ビルドスクリプトの全体構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | make.jl | `doc/make.jl` | **1-22行目**: buildroot・stdlibdir の解決。コマンドライン引数からの設定 |
| 2-2 | make.jl | `doc/make.jl` | **25-35行目**: Documenter.jl の依存関係インストール。sandboxed depot使用 |

**主要処理フロー**:
- **6-14行目**: `buildroot` の解決。ARGS の `buildroot=...` から取得、なければ `@__DIR__` の親
- **16-22行目**: `stdlibdir` の解決。ARGS の `stdlibdir=...` から取得、なければ `Sys.STDLIB`
- **26行目**: `empty!(DEPOT_PATH)` でdepotをリセット
- **29行目**: `Pkg.activate(documenter_project_dir)` でDocumenter環境を有効化

#### Step 3: 外部stdlibのドキュメント統合を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | make.jl | `doc/make.jl` | **48-70行目**: STDLIB_DOCS構築。各stdlibのdocs/src/index.mdへのsymlink作成 |
| 3-2 | make.jl | `doc/make.jl` | **49行目**: `EXT_STDLIB_DOCS = ["Pkg"]` - Pkgのみbasedocs.mdを使用 |
| 3-3 | make.jl | `doc/make.jl` | **80-140行目**: 外部stdlibのGitリモート情報構築。*.versionファイルのパース |

**主要処理フロー**:
- **50-69行目**: STDLIB_DOCSループ。EXT_STDLIB_DOCSに含まれるパッケージはbasedocs.md、それ以外はindex.mdをソースとする
- **94-140行目**: `documenter_stdlib_remotes` 構築。各versionファイルからGIT_URL・SHA1を抽出し、Documenter.Remotes.GitHubオブジェクトを生成

#### Step 4: DocTestSetupとドキュメント生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | make.jl | `doc/make.jl` | **349-390行目**: DocTestSetupの設定。各stdlibのusing文を設定 |
| 4-2 | make.jl | `doc/make.jl` | **161-303行目**: PAGES構造体の定義。Manual/Base/StdlibDocs/DevDocsの4セクション |
| 4-3 | make.jl | `doc/make.jl` | **415-429行目**: makedocs呼び出し。source, build, modules, format等の設定 |

**主要処理フロー**:
- **361-366行目**: SparseArrays特別設定。`using SparseArrays, LinearAlgebra`
- **373-378行目**: Pkg特別設定。`using Pkg, Pkg.Artifacts`
- **415行目**: `makedocs(...)` 本体。全モジュール・全ページを処理
- **420行目**: `doctest` 引数。`fix`/`only`/`true`/`false` の4モード

#### Step 5: URLリライトとデプロイを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | make.jl | `doc/make.jl` | **432-455行目**: 外部stdlibのURLリライト。正規表現でGitHub URLを修正 |
| 5-2 | make.jl | `doc/make.jl` | **458-486行目**: BuildBotConfig定義。デプロイ条件判定ロジック |
| 5-3 | make.jl | `doc/make.jl` | **513-525行目**: deploydocs呼び出し。バージョン管理付きデプロイ |

**主要処理フロー**:
- **440行目**: `stdlib/(.*)-\w{40}/` パターンでstdlib展開ディレクトリを識別
- **467行目**: `tagged_commit` の場合はバージョン番号でデプロイ
- **473行目**: `master` ブランチの場合はdevurlでデプロイ
- **476行目**: `release-X.Y` ブランチの場合は `vX.Y-dev` でデプロイ

### プログラム呼び出し階層図

```
make html (doc/Makefile)
    |
    +-- make deps (UnicodeData.txt ダウンロード)
    |
    +-- julia make.jl (doc/make.jl)
            |
            +-- Pkg.activate / Pkg.instantiate
            |       +-- Documenter.jl インストール
            |
            +-- stdlibドキュメントリンク作成
            |       +-- STDLIB_DOCS / EXT_STDLIB_DOCS
            |
            +-- documenter_stdlib_remotes 構築
            |       +-- *.version ファイルパース
            |       +-- Documenter.Remotes.GitHub 生成
            |
            +-- NEWS.md 加工
            |       +-- GitHub issueリンク変換
            |
            +-- DocTestSetup 設定
            |       +-- DocMeta.setdocmeta! (各stdlib)
            |
            +-- Documenter.makedocs
            |       +-- Markdown → HTML/PDF 変換
            |       +-- doctest 実行
            |       +-- linkcheck (オプション)
            |
            +-- URLリライト
            |       +-- 外部stdlib URL修正
            |
            +-- Documenter.deploydocs (オプション)
                    +-- BuildBotConfig 判定
                    +-- GitHub Pages デプロイ
```

### データフロー図

```
[入力]                         [処理]                          [出力]

doc/src/*.md            ──> Documenter.makedocs         ──> doc/_build/html/
base/**/*.jl docstring  ──> @autodocs展開               ──> HTMLページ群
stdlib/*/docs/src/      ──> symlinkでdoc/src/stdlib/に統合
*.version               ──> parse_stdlib_version_file   ──> Remotes設定
NEWS.md                 ──> issueリンク変換              ──> src/NEWS.md
_build/html/**/*.html   ──> URLリライト                  ──> 修正済みHTML
修正済みHTML             ──> deploydocs                  ──> docs.julialang.org
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Makefile | `doc/Makefile` | ビルドスクリプト | ビルドエントリーポイント（84行） |
| make.jl | `doc/make.jl` | ビルドスクリプト | Documenter.jl統合（525行） |
| README.md | `doc/README.md` | ドキュメント | ビルド手順の説明 |
| NEWS-update.jl | `doc/NEWS-update.jl` | スクリプト | NEWS.md更新ユーティリティ |
| index.md | `doc/src/index.md` | ドキュメントソース | トップページ |
| doc/src/manual/ | `doc/src/manual/` | ドキュメントソース | Manual セクション（43ファイル） |
| doc/src/base/ | `doc/src/base/` | ドキュメントソース | Base APIリファレンス |
| doc/src/devdocs/ | `doc/src/devdocs/` | ドキュメントソース | 開発者向けドキュメント |
