# 機能設計書 137-Makefile

## 概要

本ドキュメントは、Julia の `Make.inc` / `Makefile` / `stdlib.mk` / `pkgimage.mk` / `sysimage.mk` によるビルドシステムについて、その設計・処理仕様を記述するものである。

### 本機能の処理概要

Julia のビルドシステムは GNU Make をベースとし、C/C++ ランタイム、LLVM、外部依存ライブラリ、Julia 標準ライブラリ、システムイメージの全ビルドプロセスを管理する。Make.inc で共通変数と構成を定義し、トップレベルの Makefile が各サブシステムのビルドを統括する。

**業務上の目的・背景**：Julia は C/C++ ランタイム、LLVM コンパイラ基盤、多数の外部ライブラリ、Julia ソースコードから構成される複雑なプロジェクトであり、これらを一貫してビルド・テスト・インストールするためのビルドシステムが不可欠である。

**機能の利用シーン**：Julia のソースからのビルド（`make -j`）、テスト実行（`make test`）、ドキュメント生成（`make docs`）、依存ライブラリの管理（`make -C deps`）、クリーンビルド（`make clean`）、インストール（`make install`）など。

**主要な処理内容**：
1. `Make.inc` -- 共通ビルド変数・フラグ・プラットフォーム検出の定義
2. `Makefile`（トップレベル）-- ビルドターゲットの定義と依存関係管理
3. `deps/Makefile` -- 外部依存ライブラリのビルド管理
4. `stdlib/Makefile` -- 標準ライブラリのビルド管理
5. `sysimage.mk` -- システムイメージの生成
6. `pkgimage.mk` -- パッケージイメージの生成
7. `src/Makefile` -- C/C++ ランタイムのビルド

**関連システム・外部連携**：GNU Make、C/C++ コンパイラ（gcc/clang）、LLVM ビルドシステム（CMake）、pkg-config、BinaryBuilder、各外部ライブラリのビルドシステム。

**権限による制御**：`make install` はインストール先ディレクトリへの書き込み権限が必要。

## 関連画面

本機能は画面を持たない。コマンドラインから実行するビルドシステムである。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | コマンドラインから make コマンドを実行して利用する |

## 機能種別

ビルドシステム

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Make.user | ファイル | No | ユーザーローカルのビルド設定オーバーライド | Make.inc で include |
| USE_SYSTEM_* | 環境変数/Make変数 | No | システムライブラリ使用フラグ | 0 または 1 |
| JULIA_PRECOMPILE | Make変数 | No | プリコンパイル有効/無効 | 0 または 1（デフォルト: 1） |
| O | コマンドライン | No | ビルド出力ディレクトリ（out-of-tree ビルド） | 有効なパス |

### 入力データソース

ソースコードツリー、Make.user（ユーザー設定）、環境変数。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| julia 実行ファイル | バイナリ | usr/bin/julia |
| libjulia | 共有ライブラリ | usr/lib/libjulia.so (または .dylib / .dll) |
| libjulia-internal | 共有ライブラリ | usr/lib/libjulia-internal.so |
| sys.so | システムイメージ | Julia のプリコンパイル済みシステムイメージ |
| 依存ライブラリ群 | 共有ライブラリ | usr/lib/ 配下の外部ライブラリ |
| 標準ライブラリ | Julia ファイル | usr/share/julia/stdlib/ 配下 |

### 出力先

`$(BUILDROOT)/usr/` 以下のディレクトリ構造。

## 処理フロー

### 処理シーケンス

```
1. make (デフォルトターゲット = $(JULIA_BUILD_MODE))
   └─ release または debug
2. julia-deps
   └─ deps/Makefile による外部ライブラリのビルド
3. julia-base
   └─ base/ のJuliaソースファイルの処理
4. julia-src (C/C++ ランタイム)
   └─ src/ のC/C++ファイルのコンパイル -> libjulia-internal
5. julia-cli
   └─ cli/ のローダーのコンパイル -> julia 実行ファイル
6. julia-stdlib
   └─ stdlib/ の標準ライブラリの処理
7. julia-sysimg
   └─ sysimage.mk によるシステムイメージの生成
8. julia-symlink
   └─ julia 実行ファイルへのシンボリックリンク作成
```

### フローチャート

```mermaid
flowchart TD
    A["make"] --> B["julia-deps"]
    B --> C["julia-base"]
    B --> D["julia-src-release/debug"]
    C --> E["julia-sysimg-release/debug"]
    D --> F["julia-cli-release/debug"]
    B --> G["julia-stdlib"]
    E --> H["julia-symlink"]
    F --> H
    G --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-137-01 | USE_BINARYBUILDER | デフォルトで BinaryBuilder のプリビルトバイナリを使用 | USE_BINARYBUILDER=1 |
| BR-137-02 | USE_SYSTEM_* | 各ライブラリについてシステム版を使用するか選択可能 | 対応する USE_SYSTEM_* 変数 |
| BR-137-03 | ビルドモード | デフォルトは release ビルド。debug ビルドも可能 | JULIA_BUILD_MODE |
| BR-137-04 | out-of-tree ビルド | O=builddir でソースツリー外でのビルドが可能 | O 変数指定時 |
| BR-137-05 | メタ文字禁止 | ビルドパスにシェルメタ文字やシングルクォートを含む場合はエラー | 常時 |
| BR-137-06 | プリコンパイル制御 | JULIA_PRECOMPILE=0 でREPL等の追加プリコンパイルを無効化 | JULIA_PRECOMPILE 変数 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベース操作を行わない。

### 操作別データベース影響一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Make エラー | ビルドパスにシングルクォートが含まれる | パスを変更する |
| - | Make エラー | ビルドパスにシェルメタ文字が含まれる | パスを変更する |
| - | コンパイルエラー | C/C++ コンパイラが見つからない | コンパイラをインストールする |
| - | 依存関係エラー | 外部ライブラリのビルドに失敗 | deps/Makefile のログを確認する |

### リトライ仕様

`make` コマンドの再実行で、未完了のターゲットから再開される（Make のインクリメンタルビルド）。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- `make -j` による並列ビルドをサポート
- インクリメンタルビルドにより、変更のあったファイルのみ再ビルド
- フルビルドは環境に応じて10分〜数時間

## セキュリティ考慮事項

- ビルドプロセスは外部ソースからのライブラリダウンロードを含む（checksums で検証）
- `make install` は指定ディレクトリへのファイル書き込みを行う

## 備考

- `Make.user` ファイルでローカル設定をオーバーライドできる
- `make fix-whitespace` で空白エラーの修正
- `make test` でテストスイートの実行
- `make docs` でドキュメント生成
- LLVM のビルドは最も時間がかかる部分

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 共通設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Make.inc | `Make.inc` | **1-100行目**: 基本変数定義（JULIA_PRECOMPILE, FORCE_ASSERTIONS, OPENBLAS_*, USE_SYSTEM_* フラグ群） |

**読解のコツ**: Make.inc は Julia ビルドの全設定を集約したファイル。`?=` 演算子はデフォルト値の設定（ユーザーが未設定の場合のみ適用）。

#### Step 2: トップレベル Makefile を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Makefile | `Makefile` | **1-4行目**: JULIAHOME の設定と Make.inc の include |
| 2-2 | Makefile | `Makefile` | **26行目**: デフォルトターゲット `$(JULIA_BUILD_MODE)` |
| 2-3 | Makefile | `Makefile` | **89-100行目**: julia-deps / julia-stdlib / julia-base ターゲット |

**主要処理フロー**:
- **26行目**: `default: $(JULIA_BUILD_MODE)` -- release または debug
- **89-91行目**: `julia-deps` -- deps/ のビルド
- **94-96行目**: `julia-stdlib` -- stdlib/ のビルド（julia-deps に依存）
- **98-100行目**: `julia-base` -- base/ の処理（julia-deps に依存）

#### Step 3: ビルドパスのバリデーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Makefile | `Makefile` | **7-21行目**: パスのメタ文字チェック |

### プログラム呼び出し階層図

```
make (default)
    |
    +-- $(JULIA_BUILD_MODE)  [= release or debug]
            |
            +-- julia-deps
            |       └── make -C deps/
            |
            +-- julia-base
            |       └── make -C base/
            |
            +-- julia-src-$(BUILD_MODE)
            |       └── make -C src/
            |
            +-- julia-cli-$(BUILD_MODE)
            |       └── make -C cli/
            |
            +-- julia-stdlib
            |       └── make -C stdlib/
            |
            +-- julia-sysimg-$(BUILD_MODE)
            |       └── sysimage.mk
            |
            +-- julia-symlink
```

### データフロー図

```
[入力]                      [処理]                        [出力]

ソースコード (src/)    --> C/C++ コンパイル           --> libjulia-internal.so
                                                         libjulia.so

cli/loader_exe.c       --> コンパイル・リンク          --> julia (実行ファイル)

base/*.jl              --> Julia パース・コンパイル    --> sys.so (システムイメージ)
stdlib/                --> プリコンパイル

deps/                  --> 外部ライブラリビルド        --> usr/lib/ (依存ライブラリ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Makefile | `Makefile` | ビルド | トップレベルの Make ターゲット定義 |
| Make.inc | `Make.inc` | ビルド | 共通ビルド変数・フラグ定義 |
| deps/Makefile | `deps/Makefile` | ビルド | 外部依存ライブラリのビルド管理 |
| src/Makefile | `src/Makefile` | ビルド | C/C++ ランタイムのビルド |
| base/Makefile | `base/Makefile` | ビルド | base/ のビルド |
| stdlib/Makefile | `stdlib/Makefile` | ビルド | 標準ライブラリのビルド |
| sysimage.mk | `sysimage.mk` | ビルド | システムイメージ生成 |
| pkgimage.mk | `pkgimage.mk` | ビルド | パッケージイメージ生成 |
| cli/Makefile | `cli/Makefile` | ビルド | CLI ローダーのビルド |
