# 機能設計書 138-依存関係管理

## 概要

本ドキュメントは、Julia の `deps/` ディレクトリによる外部 C/C++ ライブラリの取得・パッチ適用・ビルド機能について、その設計・処理仕様を記述するものである。

### 本機能の処理概要

`deps/` ディレクトリは、Julia が依存する外部 C/C++ ライブラリ（GMP, MPFR, LLVM, libuv, PCRE2 等）のソース取得、パッチ適用、ビルド、インストールを管理するビルドシステムである。各ライブラリについて `{lib}.mk` ファイルと `{lib}.version` ファイルが対になり、バージョン管理とビルドルールを提供する。

**業務上の目的・背景**：Julia は多数の外部 C/C++ ライブラリに依存しており、これらを一貫した方法で取得・ビルド・管理する必要がある。BinaryBuilder によるプリビルトバイナリの利用とソースからのビルドの両方をサポートし、プラットフォーム固有の問題にパッチで対応する。

**機能の利用シーン**：Julia のソースビルド（`make -C deps`）、外部ライブラリのバージョン更新、パッチの適用、ソースビルドのデバッグ（`USE_BINARYBUILDER=0`）、チェックサムの更新など。

**主要な処理内容**：
1. ソースアーカイブのダウンロード（`get-{lib}` ターゲット）
2. アーカイブの展開（`extract-{lib}` ターゲット）
3. パッチの適用（`deps/patches/` 配下のパッチファイル）
4. configure（`configure-{lib}` ターゲット）
5. コンパイル（`compile-{lib}` ターゲット）
6. テスト（`check-{lib}` / `fastcheck-{lib}` ターゲット）
7. インストール（`install-{lib}` ターゲット -- staged-install マクロ）
8. BinaryBuilder によるプリビルトバイナリのインストール（`bb-install` マクロ）

**関連システム・外部連携**：GNU Make、各ライブラリのビルドシステム（autoconf / CMake）、BinaryBuilder、チェックサムファイル（`deps/checksums/`）。

**権限による制御**：ビルドディレクトリへの書き込み権限が必要。

## 関連画面

本機能は画面を持たない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | コマンドラインから make コマンドを実行して利用する |

## 機能種別

ビルドシステム / 依存関係管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| USE_BINARYBUILDER | Make変数 | No | BinaryBuilder の使用有無（デフォルト: 1） | 0 または 1 |
| USE_BINARYBUILDER_{LIB} | Make変数 | No | 個別ライブラリでの BB 使用有無 | 0 または 1 |
| USE_SYSTEM_{LIB} | Make変数 | No | システムライブラリの使用有無 | 0 または 1 |

### 入力データソース

`deps/{lib}.version` ファイル（バージョン番号）、`deps/checksums/` ディレクトリ（チェックサムファイル）、`deps/patches/` ディレクトリ（パッチファイル）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 共有ライブラリ | .so / .dylib / .dll | ビルドされた外部ライブラリ |
| ヘッダファイル | .h | インクルードファイル |
| 静的ライブラリ | .a | 一部のライブラリで生成 |

### 出力先

`$(build_prefix)/` 以下（通常は `usr/`）。

## 処理フロー

### 処理シーケンス

```
1. get-{lib}: ソースアーカイブのダウンロード
   └─ JLDOWNLOAD でアーカイブ取得
2. extract-{lib}: アーカイブの展開
   └─ JLCHECKSUM でチェックサム検証 -> tar 展開
3. source-patched: パッチの適用
   └─ deps/patches/{lib}-*.patch の順次適用
4. configure-{lib}: ビルド設定
   └─ ./configure または cmake の実行
5. compile-{lib}: コンパイル
   └─ make / cmake --build の実行
6. check-{lib}: テスト
   └─ make check の実行（ネイティブビルド時のみ）
7. install-{lib}: インストール
   └─ staged-install マクロによるインストール
```

### フローチャート

```mermaid
flowchart TD
    A{"USE_BINARYBUILDER_{LIB} == 1?"} -->|Yes| B["bb-install マクロ"]
    A -->|No| C["get-{lib}: ダウンロード"]
    B --> Z["完了"]
    C --> D["JLCHECKSUM: チェックサム検証"]
    D --> E["extract-{lib}: tar 展開"]
    E --> F["パッチ適用 (patch -p1)"]
    F --> G["configure-{lib}: ./configure"]
    G --> H["compile-{lib}: make"]
    H --> I{"ネイティブビルド?"}
    I -->|Yes| J["check-{lib}: make check"]
    I -->|No| K["スキップ"]
    J --> L["install-{lib}: staged-install"]
    K --> L
    L --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-138-01 | BinaryBuilder 優先 | デフォルトでは BinaryBuilder のプリビルトバイナリを使用 | USE_BINARYBUILDER=1 |
| BR-138-02 | チェックサム検証 | ダウンロードしたアーカイブのチェックサムを検証 | 常時 |
| BR-138-03 | パッチ順序 | パッチはファイル名順に適用される | パッチ存在時 |
| BR-138-04 | ネイティブテスト | テスト（check）はネイティブビルド時のみ実行（クロスコンパイル時はスキップ） | OS == BUILD_OS |
| BR-138-05 | staged-install | インストールはステージングディレクトリを経由して行われる | ソースビルド時 |
| BR-138-06 | バージョンファイル | 各ライブラリのバージョンは {lib}.version ファイルで管理 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベース操作を行わない。

### 操作別データベース影響一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ダウンロードエラー | ネットワーク障害によるダウンロード失敗 | ネットワークを確認し再実行 |
| - | チェックサムエラー | アーカイブのチェックサム不一致 | `make -f contrib/refresh_checksums.mk` で更新 |
| - | パッチ適用エラー | パッチがクリーンに適用できない | パッチを更新する |
| - | configure エラー | 依存ツール不足 | 必要なツールをインストール |
| - | コンパイルエラー | コンパイラやヘッダの不足 | ビルド環境を整備 |

### リトライ仕様

Make のインクリメンタルビルドにより、途中から再開可能。`clean-{lib}` で特定ライブラリをクリーンして再ビルド可能。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- `make -j` による並列ビルド（各ライブラリ内部も並列コンパイル可能）
- BinaryBuilder 使用時はビルド時間が大幅に短縮される
- ソースキャッシュ（`deps/srccache/`）により再ダウンロードを回避

## セキュリティ考慮事項

- ダウンロードしたアーカイブはチェックサムで検証される
- パッチファイルはリポジトリ内で管理され、コードレビュー対象である
- 外部ソースからのダウンロードは HTTPS を使用

## 備考

- `distclean-{lib}` でソースキャッシュを含む完全クリーン
- `getall` ターゲットで全ライブラリのソースをオフライン用にダウンロード
- 主要な依存ライブラリ: GMP, MPFR, LLVM, libuv, PCRE2, OpenSSL, libssh2, libgit2, curl, SuiteSparse, OpenBLAS, blastrampoline, utf8proc, dsfmt, zlib, zstd, patchelf

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Makefile | `deps/Makefile` | **1-14行目**: ディレクトリ変数の設定、Make.inc / tools/*.mk の include |
| 1-2 | Makefile | `deps/Makefile` | **18-27行目**: 構造の説明コメント -- 全ターゲットは get/extract/configure/compile/check/install パターン |
| 1-3 | Makefile | `deps/Makefile` | **34-80行目**: DEP_LIBS リストの構築（条件付き） |

**読解のコツ**: deps/Makefile は条件付きで DEP_LIBS リストにライブラリを追加する。USE_SYSTEM_* が 0 の場合のみ自前ビルド対象となる。

#### Step 2: 個別ライブラリのビルドルールを理解する（GMP を例に）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gmp.mk | `deps/gmp.mk` | **1-2行目**: gmp.version の include |
| 2-2 | gmp.mk | `deps/gmp.mk` | **6-8行目**: GMP_CONFIGURE_OPTS の設定 |
| 2-3 | gmp.mk | `deps/gmp.mk` | **26-33行目**: ダウンロード・展開ルール |
| 2-4 | gmp.mk | `deps/gmp.mk` | **38-49行目**: パッチ適用ルール |
| 2-5 | gmp.mk | `deps/gmp.mk` | **51-65行目**: configure / compile / check ルール |
| 2-6 | gmp.mk | `deps/gmp.mk` | **67-71行目**: staged-install マクロ呼び出し |
| 2-7 | gmp.mk | `deps/gmp.mk` | **89-93行目**: BinaryBuilder 使用時の bb-install マクロ |

**主要処理フロー**:
- **26-27行目**: `$(SRCCACHE)/gmp-$(GMP_VER).tar.bz2` -- JLDOWNLOAD でダウンロード
- **29-33行目**: `source-extracted` -- JLCHECKSUM + tar 展開
- **38-41行目**: `gmp-exception.patch-applied` -- パッチ適用
- **51-55行目**: `build-configured` -- configure 実行
- **57-59行目**: `build-compiled` -- make 実行
- **67-71行目**: `staged-install` -- インストール

#### Step 3: 共通ツールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | common.mk | `deps/tools/common.mk` | staged-install マクロの定義 |
| 3-2 | bb-install.mk | `deps/tools/bb-install.mk` | bb-install マクロの定義（BinaryBuilder 用） |

### プログラム呼び出し階層図

```
deps/Makefile
    |
    +-- include Make.inc
    +-- include tools/common.mk
    +-- include tools/bb-install.mk
    |
    +-- DEP_LIBS リスト構築
    |
    +-- include {lib}.mk (各ライブラリ)
            |
            +-- get-{lib}: JLDOWNLOAD
            +-- extract-{lib}: JLCHECKSUM + tar
            +-- パッチ適用: patch -p1
            +-- configure-{lib}: ./configure or cmake
            +-- compile-{lib}: make
            +-- check-{lib}: make check
            +-- install-{lib}: staged-install or bb-install
```

### データフロー図

```
[入力]                        [処理]                        [出力]

gmplib.org/gmp-6.3.0.tar --> JLDOWNLOAD                --> deps/srccache/gmp-6.3.0.tar.bz2
                          --> JLCHECKSUM                --> 検証済みアーカイブ
                          --> tar 展開                  --> deps/srccache/gmp-6.3.0/
                          --> patch -p1                 --> パッチ適用済みソース
                          --> ./configure               --> build-configured
                          --> make                      --> build-compiled
                          --> staged-install             --> usr/lib/libgmp.so
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Makefile | `deps/Makefile` | ビルド | 依存ライブラリビルドの統括 |
| gmp.mk | `deps/gmp.mk` | ビルド | GMP ライブラリのビルドルール |
| gmp.version | `deps/gmp.version` | 設定 | GMP のバージョン番号 |
| common.mk | `deps/tools/common.mk` | ビルド | staged-install 等の共通マクロ |
| bb-install.mk | `deps/tools/bb-install.mk` | ビルド | BinaryBuilder インストールマクロ |
| git-external.mk | `deps/tools/git-external.mk` | ビルド | Git リポジトリからの取得ルール |
| checksums/ | `deps/checksums/` | 設定 | ダウンロードファイルのチェックサム |
| patches/ | `deps/patches/` | パッチ | 外部ライブラリへのパッチファイル |
