# 機能設計書 143-SuiteSparse_jll

## 概要

本ドキュメントは、Julia標準ライブラリに含まれるSuiteSparse_jllパッケージの機能設計を記述する。SuiteSparse_jllは、SuiteSparseライブラリ群のJLLバイナリラッパーであり、疎行列演算のための複数のネイティブライブラリ（CHOLMOD, UMFPACK, SPQR, KLU, AMD, COLAMD等）をJuliaから利用可能にする。

### 本機能の処理概要

SuiteSparse_jllは、SuiteSparse Cライブラリ群のプリビルドバイナリをJuliaのパッケージシステムを通じて提供するJLLラッパーパッケージである。12個のライブラリコンポーネントそれぞれについて、プラットフォーム別のライブラリ名マッピング、ライブラリ間の内部依存関係の解決、GPLライセンスライブラリの条件付きロードを行う。

**業務上の目的・背景**：JuliaのSparseArraysおよびLinearAlgebra標準ライブラリは、疎行列演算の高性能実装としてSuiteSparseを使用する。SuiteSparse_jllは、CHOLMOD（疎コレスキー分解）、UMFPACK（疎LU分解）、SPQR（疎QR分解）、KLU（回路シミュレーション用疎行列ソルバー）などの重要な疎行列アルゴリズムのバイナリ配布を管理する。科学技術計算・有限要素法・回路シミュレーション等で不可欠なコンポーネントである。

**機能の利用シーン**：疎行列のLU/コレスキー/QR分解、疎行列ソルバー、行列の順序付け（AMD, COLAMD）、回路シミュレーション（KLU）などの操作時にSuiteSparseライブラリが内部的に呼び出される。

**主要な処理内容**：
1. 12個のSuiteSparseライブラリコンポーネントのLazyLibrary定義と依存関係管理
2. プラットフォーム（Windows/macOS/Linux/FreeBSD）に応じたライブラリパスの解決
3. ライブラリ間の内部依存関係（例: libcholmodはlibamd, libcamd, libccolamd等に依存）の定義
4. GPLライセンスライブラリ（libcholmod, librbio, libspqr, libumfpack）の条件付きロード
5. libblastrampoline_jllおよびCompilerSupportLibraries_jllへの外部依存管理

**関連システム・外部連携**：libblastrampoline_jll（BLAS/LAPACKディスパッチ）、CompilerSupportLibraries_jll（C++/GCCランタイム）への依存。上流のSuiteSparseプロジェクト（https://people.engr.tamu.edu/davis/suitesparse.html）のバージョン7.10.1に対応。

**権限による制御**：`Base.USE_GPL_LIBS`フラグにより、GPL-2.0+ライセンスのライブラリ（libcholmod, librbio, libspqr, libumfpack）のロードを制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUI画面を持たない。SparseArrays/LinearAlgebra経由で疎行列演算時に使用される |

## 機能種別

データ連携（ネイティブライブラリバイナリ配布・動的リンク管理・ライセンス条件付きロード）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Sys.KERNEL | Symbol | Yes | 実行プラットフォームのカーネル識別子 | Windows/macOS/Linux/FreeBSDのいずれか |
| Sys.WORD_SIZE | Int | Yes | ポインタサイズ（32/64ビット） | 32または64 |
| Base.USE_GPL_LIBS | Bool | Yes | GPLライブラリの使用許可フラグ | true/false |

### 入力データソース

- プラットフォーム情報: `Sys.iswindows()`, `Sys.isapple()`, `Sys.islinux()`, `Sys.isfreebsd()`
- ワードサイズ: `Sys.WORD_SIZE`（Windows 32bitでの追加依存判定に使用）
- ライセンスフラグ: `Base.USE_GPL_LIBS`

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libamd | LazyLibrary | AMD（Approximate Minimum Degree）ライブラリハンドル |
| libbtf | LazyLibrary | BTF（Block Triangular Form）ライブラリハンドル |
| libcamd | LazyLibrary | CAMD（Constrained AMD）ライブラリハンドル |
| libccolamd | LazyLibrary | CCOLAMD（Constrained COLAMD）ライブラリハンドル |
| libcholmod | LazyLibrary | CHOLMOD（疎コレスキー分解）ライブラリハンドル |
| libcolamd | LazyLibrary | COLAMD（Column AMD）ライブラリハンドル |
| libklu | LazyLibrary | KLU（回路シミュレーション用ソルバー）ライブラリハンドル |
| libldl | LazyLibrary | LDL（簡易LDL分解）ライブラリハンドル |
| librbio | LazyLibrary | RBio（Rutherford-Boeing I/O）ライブラリハンドル |
| libspqr | LazyLibrary | SPQR（疎QR分解）ライブラリハンドル |
| libsuitesparseconfig | LazyLibrary | SuiteSparseConfig（共通設定）ライブラリハンドル |
| libumfpack | LazyLibrary | UMFPACK（疎LU分解）ライブラリハンドル |

### 出力先

- メモリ内グローバル変数としてモジュール内に保持

## 処理フロー

### 処理シーケンス

```
1. モジュール定義（baremodule）
   └─ libblastrampoline_jll, CompilerSupportLibraries_jll をusing
2. 12個のライブラリのLazyLibrary定義
   ├─ libsuitesparseconfig（依存なし・基盤ライブラリ）
   ├─ libldl, libbtf（依存なし）
   ├─ libcolamd, libamd, libcamd, libccolamd, librbio（libsuitesparseconfig依存）
   ├─ libcholmod（libamd, libcamd, libccolamd, libcolamd, libblastrampoline依存）
   ├─ libklu（libamd, libcolamd, libbtf依存）
   ├─ libspqr（libcholmod, libblastrampoline依存）
   └─ libumfpack（libamd, libcholmod, libblastrampoline依存）
3. __init__()実行
   ├─ BSD-3-Clauseライブラリのパス設定（常時）
   ├─ LGPL-2.1+ライブラリのパス設定（常時）
   └─ GPL-2.0+ライブラリのパス設定（USE_GPL_LIBS時のみ）
```

### フローチャート

```mermaid
flowchart TD
    A[モジュールロード] --> B[12個のLazyLibrary定義]
    B --> C["__init__() 実行"]
    C --> D[BSD-3-Clauseライブラリ パス設定]
    D --> E[LGPL-2.1+ライブラリ パス設定]
    E --> F{USE_GPL_LIBS?}
    F -->|true| G[GPL-2.0+ライブラリ パス設定]
    F -->|false| H[GPL ライブラリスキップ]
    G --> I[artifact_dir 設定]
    H --> I
    I --> J[初期化完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-143-01 | ライセンス別ロード | GPL-2.0+ライブラリはUSE_GPL_LIBS=true時のみパス設定 | __init__時 |
| BR-143-02 | 内部依存解決 | libcholmodロード前にlibamd, libcamd, libccolamd, libcolamdをロード | ライブラリロード時 |
| BR-143-03 | Windows 32bit追加依存 | Windows 32bitではlibgcc_sを追加依存に含む | Windows 32bit環境 |
| BR-143-04 | Linux C++依存 | libspqrはLinuxでlibstdcxxとlibgcc_sに追加依存 | Linux環境 |
| BR-143-05 | プリコンパイル | generating_output()時にeager_modeとis_availableをプリコンパイル | システムイメージ生成時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ErrorException | 未対応プラットフォーム | 各ライブラリ定義で`error("SuiteSparse_jll: Library 'xxx' is not available for $(Sys.KERNEL)")` |
| - | DLError | ライブラリファイルが見つからない | dlopen失敗時のOSエラーメッセージ表示 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- LazyLibraryメカニズムにより、各ライブラリは初回使用時まで遅延ロードされる
- eager_mode()で全12ライブラリを一括ロードすることも可能
- プリコンパイル対応によりシステムイメージへの組み込みを最適化

## セキュリティ考慮事項

- GPLライブラリの条件付きロードにより、ライセンス要件に応じた動作制御が可能

## 備考

- バージョン: SuiteSparse 7.10.1+0
- UUID: bea87d4a-7f5b-5778-9afe-8cc45184846c
- ライセンス区分: BSD-3-Clause（libamd, libcamd, libccolamd, libcolamd, libsuitesparseconfig）、LGPL-2.1+（libbtf, libklu, libldl）、GPL-2.0+（libcholmod, librbio, libspqr, libumfpack）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | libdl.jl | `base/libdl.jl` | LazyLibrary構造体のdependenciesフィールド。ライブラリ間依存解決の仕組み |

**読解のコツ**: SuiteSparse_jllは12個のライブラリを管理する最も複雑なJLLパッケージ。ライブラリ間の依存関係ツリーを理解することが重要。libsuitesparseconfig が共通基盤、libblastrampoline がBLAS/LAPACK基盤。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SuiteSparse_jll.jl | `stdlib/SuiteSparse_jll/src/SuiteSparse_jll.jl` | モジュール全体の定義（277行） |

**主要処理フロー**:
1. **4行目**: `baremodule SuiteSparse_jll` - モジュール定義開始
2. **6行目**: `using libblastrampoline_jll` - BLAS/LAPACK依存
3. **7-9行目**: FreeBSD/macOS以外でCompilerSupportLibraries_jllをusing
4. **11行目**: 12個のライブラリシンボルをexport
5. **22-32行目**: libsuitesparseconfig（基盤ライブラリ、依存なし）
6. **150-170行目**: libcholmod（最も多い依存: libsuitesparseconfig, libamd, libcamd, libccolamd, libcolamd, libblastrampoline）
7. **249-270行目**: __init__()でライセンス別にパス設定

#### Step 3: ライセンス制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SuiteSparse_jll.jl | `stdlib/SuiteSparse_jll/src/SuiteSparse_jll.jl` | __init__()のライセンス分岐（249-270行目） |

**主要処理フロー**:
- **250-255行目**: BSD-3-Clauseライブラリ（libamd, libcamd, libccolamd, libcolamd, libsuitesparseconfig）のパス設定 - 常時実行
- **257-260行目**: LGPL-2.1+ライブラリ（libbtf, libklu, libldl）のパス設定 - 常時実行
- **263-268行目**: GPL-2.0+ライブラリ（libcholmod, librbio, libspqr, libumfpack）のパス設定 - `Base.USE_GPL_LIBS`がtrueの場合のみ

### プログラム呼び出し階層図

```
SuiteSparse_jll.__init__()
    |
    +-- BSD-3-Clause ライブラリパス設定
    |       +-- libamd_path, libcamd_path, libccolamd_path, libcolamd_path, libsuitesparseconfig_path
    |
    +-- LGPL-2.1+ ライブラリパス設定
    |       +-- libbtf_path, libklu_path, libldl_path
    |
    +-- [USE_GPL_LIBS] GPL-2.0+ ライブラリパス設定
    |       +-- libcholmod_path, librbio_path, libspqr_path, libumfpack_path
    |
    +-- artifact_dir = dirname(Sys.BINDIR)

ライブラリ依存ツリー:
    libsuitesparseconfig (基盤)
        |
        +-- libcolamd, libamd, libcamd, libccolamd, librbio
        |
        +-- libcholmod (+ libamd, libcamd, libccolamd, libcolamd, libblastrampoline)
        |       |
        |       +-- libspqr (+ libblastrampoline)
        |       +-- libumfpack (+ libamd, libblastrampoline)
        |
        +-- libklu (+ libamd, libcolamd, libbtf)
```

### データフロー図

```
[入力]                              [処理]                              [出力]

Sys.KERNEL (OS種別) -------------> プラットフォーム判定 ----------> 12個のライブラリパス
Sys.WORD_SIZE (32/64) -----------> Windows 32bit判定 ------------> 追加依存(libgcc_s)
Base.USE_GPL_LIBS (ライセンス) --> GPL条件分岐 -----------------> GPL lib ロード可否
libblastrampoline_jll -----------> BLAS/LAPACK依存解決 ----------> CHOLMOD/SPQR/UMFPACK利用可能
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SuiteSparse_jll.jl | `stdlib/SuiteSparse_jll/src/SuiteSparse_jll.jl` | ソース | メインモジュール定義。12個のライブラリのLazyLibrary定義 |
| Project.toml | `stdlib/SuiteSparse_jll/Project.toml` | 設定 | パッケージメタデータ・依存関係・バージョン情報 |
| libdl.jl | `base/libdl.jl` | ソース | LazyLibrary/BundledLazyLibraryPathの基盤実装 |
