# 機能設計書 144-LibCURL_jll

## 概要

本ドキュメントは、Julia標準ライブラリに含まれるLibCURL_jllパッケージの機能設計を記述する。LibCURL_jllは、libcurlライブラリのJLLバイナリラッパーであり、HTTP/HTTPS/FTP等のプロトコルによるデータ転送機能をJuliaから利用可能にする。

### 本機能の処理概要

LibCURL_jllは、libcurl CライブラリのプリビルドバイナリをJuliaのパッケージシステムを通じて提供するJLLラッパーパッケージである。プラットフォーム別のライブラリ名マッピング、複数の依存ライブラリ（zlib, zstd, nghttp2, libssh2, OpenSSL）の自動ロードを行う。

**業務上の目的・背景**：Juliaのパッケージマネージャ（Pkg.jl）やDownloads.jlは、パッケージレジストリの取得やファイルダウンロードにlibcurlを使用する。LibCURL_jllは、このHTTP通信基盤のバイナリ配布と動的リンクを管理し、SSL/TLS対応のセキュアな通信を提供する。パッケージのインストール・更新、レジストリの同期、バイナリアーティファクトのダウンロード等、Juliaのパッケージエコシステムの通信基盤として不可欠である。

**機能の利用シーン**：パッケージのadd/update操作時のレジストリ通信、Downloads.download()によるファイル取得、LibCURL.jlを直接使用したHTTP API呼び出し等で利用される。

**主要な処理内容**：
1. プラットフォーム（Windows/macOS/Linux/FreeBSD）に応じたlibcurl共有ライブラリパスの解決
2. 依存ライブラリチェーン（Zlib, Zstd, nghttp2, LibSSH2, OpenSSL）の自動ロード
3. プラットフォーム別の依存ライブラリ切り替え（WindowsではOpenSSLを使用しない等）
4. `LazyLibrary`メカニズムを用いた遅延ライブラリロード

**関連システム・外部連携**：Zlib_jll（圧縮）、Zstd_jll（圧縮）、nghttp2_jll（HTTP/2）、LibSSH2_jll（SSH）、OpenSSL_jll（SSL/TLS、非Windows環境）への依存。Windows 32bit環境ではCompilerSupportLibraries_jllへの追加依存。上流のcURLプロジェクト（https://curl.se/）のバージョン8.18.0に対応。

**権限による制御**：特になし。全ユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUI画面を持たない。Pkg/Downloads経由でネットワーク通信時に内部的に使用される |

## 機能種別

データ連携（ネイティブライブラリバイナリ配布・動的リンク管理・ネットワーク通信基盤）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Sys.KERNEL | Symbol | Yes | 実行プラットフォームのカーネル識別子 | Windows/macOS/Linux/FreeBSDのいずれか |
| Sys.WORD_SIZE | Int | Yes | ポインタサイズ | 32または64（Windows 32bit判定用） |

### 入力データソース

- プラットフォーム情報: `Sys.iswindows()`, `Sys.isapple()`, `Sys.islinux()`, `Sys.isfreebsd()`
- ワードサイズ: `Sys.WORD_SIZE`（Windows 32bitでの追加依存判定に使用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libcurl | LazyLibrary | libcurl共有ライブラリへのハンドル（遅延ロード） |
| libcurl_path | String | libcurlの絶対ファイルパス |
| artifact_dir | String | アーティファクトディレクトリ |

### 出力先

- メモリ内グローバル変数としてモジュール内に保持

## 処理フロー

### 処理シーケンス

```
1. モジュール定義（baremodule）
   └─ nghttp2_jll, LibSSH2_jll, Zlib_jll, Zstd_jll をusing
   └─ 非WindowsではOpenSSL_jllも追加using
   └─ Windows 32bitではCompilerSupportLibraries_jllも追加using
2. プラットフォーム判定によるライブラリパス決定
   └─ BundledLazyLibraryPathでOS別のlibcurlファイル名を設定
3. LazyLibrary定数の定義
   └─ 依存ライブラリ（libz, libzstd, libnghttp2, libssh2, [libssl, libcrypto], [libgcc_s]）を指定
4. __init__()実行
   └─ libcurl_path, artifact_dir, LIBPATH の設定
```

### フローチャート

```mermaid
flowchart TD
    A[モジュールロード] --> B{プラットフォーム判定}
    B -->|Windows| C["libcurl-4.dll"]
    B -->|macOS| D["libcurl.4.dylib"]
    B -->|Linux/FreeBSD| E["libcurl.so.4"]
    B -->|その他| F[error発生]
    C --> G{Windows 32bit?}
    G -->|Yes| H["deps: libz, libzstd, libnghttp2, libssh2, libgcc_s"]
    G -->|No| I["deps: libz, libzstd, libnghttp2, libssh2"]
    D --> J["deps: libz, libzstd, libnghttp2, libssh2, libssl, libcrypto"]
    E --> J
    H --> K["__init__() 実行"]
    I --> K
    J --> K
    K --> L[初期化完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-144-01 | Windows SSL | WindowsではOS標準のSSL/TLS（WinSSL/Schannel）を使用し、OpenSSLは依存しない | Windows環境 |
| BR-144-02 | 非Windows SSL | macOS/Linux/FreeBSDではOpenSSL_jllのlibsslとlibcryptoに依存 | 非Windows環境 |
| BR-144-03 | HTTP/2サポート | nghttp2_jllを依存に含み、HTTP/2プロトコルをサポート | 全環境 |
| BR-144-04 | 圧縮サポート | Zlib_jllとZstd_jllを依存に含み、コンテンツの圧縮/展開をサポート | 全環境 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ErrorException | 未対応プラットフォーム | `error("LibCURL_jll: Library 'libcurl' is not available for $(Sys.KERNEL)")` |
| - | DLError | ライブラリファイルまたは依存ライブラリが見つからない | dlopen失敗時のOSエラーメッセージ表示 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- LazyLibraryメカニズムにより遅延ロード
- プリコンパイル対応（eager_mode, is_available）

## セキュリティ考慮事項

- SSL/TLSサポートにより、HTTPS通信でのデータ暗号化を提供
- WindowsではOS標準SSL、他プラットフォームではOpenSSL 3.xを使用
- SSH接続のためのlibssh2依存

## 備考

- バージョン: libcurl 8.18.0+0
- UUID: deac9b47-8bc7-5906-a0fe-35ac56dc84c0
- 依存チェーン: LibCURL_jll -> LibSSH2_jll -> OpenSSL_jll, Zlib_jll -> (なし)

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | libdl.jl | `base/libdl.jl` | LazyLibrary構造体のdependenciesフィールド。深い依存チェーンの解決順序 |

**読解のコツ**: LibCURL_jllは6つの依存JLL（Zlib, Zstd, nghttp2, LibSSH2, OpenSSL, CompilerSupportLibraries）を持つ。eager_mode()の実装を見ると依存の全体像がわかる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LibCURL_jll.jl | `stdlib/LibCURL_jll/src/LibCURL_jll.jl` | モジュール全体の定義（72行） |

**主要処理フロー**:
1. **5行目**: `baremodule LibCURL_jll` - モジュール定義開始
2. **6行目**: `using Base, Libdl, nghttp2_jll, LibSSH2_jll, Zlib_jll, Zstd_jll` - 多数の依存をusing
3. **7-9行目**: 非WindowsでOpenSSL_jllを条件付きusing
4. **10-12行目**: Windows 32bitでCompilerSupportLibraries_jllを条件付きusing
5. **24-43行目**: `libcurl` LazyLibrary定数の定義。プラットフォーム別の依存リスト
6. **34-42行目**: 依存ライブラリの条件分岐。WindowsではSSLなし、他ではlibssl+libcrypto追加
7. **45-57行目**: eager_mode()。全依存JLLのeager_mode()を呼び出し後にdlopen(libcurl)
8. **60-65行目**: __init__()。パス変数の設定

#### Step 3: 依存チェーンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LibSSH2_jll.jl | `stdlib/LibSSH2_jll/src/LibSSH2_jll.jl` | libcurlが依存するlibssh2のJLLラッパー |
| 3-2 | OpenSSL_jll.jl | `stdlib/OpenSSL_jll/src/OpenSSL_jll.jl` | SSL/TLS基盤となるOpenSSLのJLLラッパー |
| 3-3 | Zlib_jll.jl | `stdlib/Zlib_jll/src/Zlib_jll.jl` | 圧縮基盤となるzlibのJLLラッパー |

### プログラム呼び出し階層図

```
LibCURL_jll.eager_mode()
    |
    +-- Zlib_jll.eager_mode()
    |       +-- dlopen(libz)
    |
    +-- Zstd_jll.eager_mode()
    |       +-- dlopen(libzstd)
    |
    +-- nghttp2_jll.eager_mode()
    |       +-- dlopen(libnghttp2)
    |
    +-- LibSSH2_jll.eager_mode()
    |       +-- OpenSSL_jll.eager_mode() [非Windows]
    |       |       +-- dlopen(libcrypto), dlopen(libssl)
    |       +-- dlopen(libssh2)
    |
    +-- CompilerSupportLibraries_jll.eager_mode() [Windows 32bit]
    |
    +-- OpenSSL_jll.eager_mode() [非Windows]
    |
    +-- dlopen(libcurl)
```

### データフロー図

```
[入力]                              [処理]                              [出力]

Sys.KERNEL (OS種別) -------------> プラットフォーム判定 ----------> libcurlファイル名
Sys.WORD_SIZE -------------------> Windows 32bit判定 ------------> 追加依存(libgcc_s)
Zlib_jll.libz -------------------> 圧縮依存解決 -----------------> データ圧縮機能
nghttp2_jll.libnghttp2 ---------> HTTP/2依存解決 ----------------> HTTP/2サポート
LibSSH2_jll.libssh2 ------------> SSH依存解決 -------------------> SSH接続機能
OpenSSL_jll.libssl/libcrypto ----> SSL/TLS依存解決 [非Win] ------> HTTPS機能
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LibCURL_jll.jl | `stdlib/LibCURL_jll/src/LibCURL_jll.jl` | ソース | メインモジュール定義。libcurlのLazyLibrary定義 |
| Project.toml | `stdlib/LibCURL_jll/Project.toml` | 設定 | パッケージメタデータ・依存関係・バージョン情報 |
| LibSSH2_jll.jl | `stdlib/LibSSH2_jll/src/LibSSH2_jll.jl` | ソース | SSH依存ライブラリ |
| OpenSSL_jll.jl | `stdlib/OpenSSL_jll/src/OpenSSL_jll.jl` | ソース | SSL/TLS依存ライブラリ |
| Zlib_jll.jl | `stdlib/Zlib_jll/src/Zlib_jll.jl` | ソース | 圧縮依存ライブラリ |
| libdl.jl | `base/libdl.jl` | ソース | LazyLibrary基盤実装 |
