# 機能設計書 145-PCRE2_jll

## 概要

本ドキュメントは、Julia標準ライブラリに含まれるPCRE2_jllパッケージの機能設計を記述する。PCRE2_jllは、PCRE2（Perl Compatible Regular Expressions）ライブラリのJLLバイナリラッパーであり、正規表現マッチング機能をJuliaから利用可能にする。

### 本機能の処理概要

PCRE2_jllは、PCRE2 Cライブラリ（libpcre2-8）のプリビルドバイナリをJuliaのパッケージシステムを通じて提供するJLLラッパーパッケージである。UTF-8エンコーディング対応の正規表現ライブラリをプラットフォーム別に配布する。外部依存なしの単独ライブラリである。

**業務上の目的・背景**：Juliaの正規表現機能（`Regex`型、`r""` リテラル）は内部的にPCRE2ライブラリを使用している。PCRE2_jllは、このPCRE2ライブラリのバイナリ配布と動的リンクを管理し、Perl互換の強力な正規表現エンジンを提供する。文字列パターンマッチング、テキスト処理、データバリデーション等の基本的な文字列操作の基盤として不可欠である。

**機能の利用シーン**：正規表現によるパターンマッチ（`match`関数）、文字列検索（`occursin`）、文字列置換（`replace`）、文字列分割（`split`）など、正規表現を使用するあらゆる文字列操作で利用される。Julia起動時にシステムイメージの一部として自動ロードされる。

**主要な処理内容**：
1. プラットフォーム（Windows/macOS/Linux/FreeBSD）に応じたlibpcre2-8共有ライブラリパスの解決
2. 外部依存なしの単純なLazyLibrary定義
3. `LazyLibrary`メカニズムを用いた遅延ライブラリロード

**関連システム・外部連携**：外部依存なし。Libdlのみ使用。上流のPCRE2プロジェクト（https://github.com/PCRE2Project/pcre2）のバージョン10.47.0に対応。

**権限による制御**：特になし。全ユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUI画面を持たない。正規表現操作時にccall経由で内部的に使用される |

## 機能種別

データ連携（ネイティブライブラリバイナリ配布・動的リンク管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Sys.KERNEL | Symbol | Yes | 実行プラットフォームのカーネル識別子 | Windows/macOS/Linux/FreeBSDのいずれか |

### 入力データソース

- プラットフォーム情報: `Sys.iswindows()`, `Sys.isapple()`, `Sys.islinux()`, `Sys.isfreebsd()`

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libpcre2_8 | LazyLibrary | libpcre2-8共有ライブラリへのハンドル（遅延ロード） |
| libpcre2_8_path | String | libpcre2-8の絶対ファイルパス |
| artifact_dir | String | アーティファクトディレクトリ |

### 出力先

- メモリ内グローバル変数としてモジュール内に保持

## 処理フロー

### 処理シーケンス

```
1. モジュール定義（baremodule）
   └─ Base, Libdl をusing
2. プラットフォーム判定によるライブラリパス決定
   └─ BundledLazyLibraryPathでOS別のlibpcre2-8ファイル名を設定
3. LazyLibrary定数の定義（依存なし）
4. __init__()実行
   └─ libpcre2_8_path, artifact_dir, LIBPATH の設定
```

### フローチャート

```mermaid
flowchart TD
    A[モジュールロード] --> B{プラットフォーム判定}
    B -->|Windows| C["libpcre2-8.dll"]
    B -->|macOS| D["libpcre2-8.0.dylib"]
    B -->|Linux/FreeBSD| E["libpcre2-8.so.0"]
    B -->|その他| F[error発生]
    C --> G[LazyLibrary生成（依存なし）]
    D --> G
    E --> G
    G --> H["__init__() 実行"]
    H --> I[パス変数設定]
    I --> J[初期化完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-145-01 | UTF-8バリアント | libpcre2_8（UTF-8版）のみを提供。16/32ビット版は含まない | 全環境 |
| BR-145-02 | 依存なし | 外部JLL依存を持たない単独ライブラリ | 全環境 |
| BR-145-03 | プリコンパイル対応 | generating_output()時にeager_mode/is_availableをプリコンパイル | システムイメージ生成時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ErrorException | 未対応プラットフォーム | `error("PCRE2_jll: Library 'libpcre2_8' is not available for $(Sys.KERNEL)")` |
| - | DLError | ライブラリファイルが見つからない | dlopen失敗時のOSエラーメッセージ表示 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- LazyLibraryメカニズムにより遅延ロード
- 正規表現はJuliaの基本機能のため、高頻度で呼び出される

## セキュリティ考慮事項

- PCRE2ライブラリ自体がReDoS（Regular Expression Denial of Service）対策のためのバックトラッキング制限機能を提供

## 備考

- バージョン: PCRE2 10.47.0+0
- UUID: efcefdf7-47ab-520b-bdef-62a2eaa19f15
- JuliaBinaryWrappersの上流リポジトリ: https://github.com/JuliaBinaryWrappers/PCRE2_jll.jl
- Juliaの正規表現基盤（base/regex.jl, base/pcre.jl）が直接このライブラリを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | libdl.jl | `base/libdl.jl` | LazyLibrary構造体の基本定義 |

**読解のコツ**: PCRE2_jllは最もシンプルなJLLパッケージの一つ。外部依存がなく、単一ライブラリのみ。JLL構造を理解するための入門として最適。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PCRE2_jll.jl | `stdlib/PCRE2_jll/src/PCRE2_jll.jl` | モジュール全体の定義（46行） |

**主要処理フロー**:
1. **4行目**: `baremodule PCRE2_jll` - モジュール定義開始
2. **5行目**: `using Base, Libdl` - 最小限の依存のみ
3. **7行目**: `export libpcre2_8` - 公開シンボル
4. **17-27行目**: `libpcre2_8` LazyLibrary定数の定義。依存なし
5. **29-31行目**: `eager_mode()` - dlopen(libpcre2_8)のみ
6. **34-39行目**: `__init__()` - パス変数設定
7. **41-44行目**: プリコンパイル指定

#### Step 3: 利用先を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pcre.jl | `base/pcre.jl` | PCRE2のJuliaラッパー。ccallでlibpcre2_8を呼び出す |
| 3-2 | regex.jl | `base/regex.jl` | Regex型の定義。PCRE2を利用した正規表現マッチング |

### プログラム呼び出し階層図

```
PCRE2_jll.__init__()
    |
    +-- libpcre2_8.path (LazyLibrary.path アクセス)
    |       |
    |       +-- BundledLazyLibraryPath("libpcre2-8.so.0")
    |
    +-- artifact_dir = dirname(Sys.BINDIR)
    |
    +-- LIBPATH[] = dirname(libpcre2_8_path)

PCRE2_jll.eager_mode()
    |
    +-- dlopen(libpcre2_8)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Sys.KERNEL (OS種別) ---------> プラットフォーム判定 ---------> ライブラリファイル名
Sys.BINDIR (Juliaパス) ------> BundledLazyLibraryPath ------> libpcre2_8_path
                                      |
                                      v
                               dlopen(libpcre2_8) ---------> ccall利用可能状態
                                                                    |
                                                                    v
                                                             base/pcre.jl から利用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PCRE2_jll.jl | `stdlib/PCRE2_jll/src/PCRE2_jll.jl` | ソース | メインモジュール定義。libpcre2_8のLazyLibrary定義 |
| Project.toml | `stdlib/PCRE2_jll/Project.toml` | 設定 | パッケージメタデータ・バージョン情報 |
| libdl.jl | `base/libdl.jl` | ソース | LazyLibrary基盤実装 |
| pcre.jl | `base/pcre.jl` | ソース | PCRE2 C APIのJuliaラッパー（主要利用先） |
| regex.jl | `base/regex.jl` | ソース | Regex型定義（主要利用先） |
