# 機能設計書 146-Zlib_jll

## 概要

本ドキュメントは、Julia標準ライブラリに含まれるZlib_jllパッケージの機能設計を記述する。Zlib_jllは、zlib圧縮ライブラリのJLLバイナリラッパーであり、deflate圧縮アルゴリズムによるデータ圧縮・展開機能をJuliaから利用可能にする。

### 本機能の処理概要

Zlib_jllは、zlib Cライブラリ（libz）のプリビルドバイナリをJuliaのパッケージシステムを通じて提供するJLLラッパーパッケージである。プラットフォーム別のライブラリ名マッピングを行う。外部JLL依存なしの単独ライブラリである。

**業務上の目的・背景**：zlibは最も広く使用される汎用データ圧縮ライブラリであり、HTTP通信のコンテンツ圧縮（gzip/deflate）、パッケージアーカイブの圧縮、gitオブジェクトの圧縮など、多数のコンポーネントから利用される基盤ライブラリである。Zlib_jllは、libcurl、libgit2、libssh2など他のJLLパッケージの依存先として重要である。

**機能の利用シーン**：HTTP通信でのデータ圧縮/展開、パッケージレジストリの圧縮データの処理、gitオブジェクトの操作、ファイルの圧縮/展開など。多くの場合、他のJLLパッケージの依存ライブラリとして間接的に使用される。

**主要な処理内容**：
1. プラットフォーム（Windows/macOS/Linux/FreeBSD）に応じたlibz共有ライブラリパスの解決
2. 外部依存なしの単純なLazyLibrary定義
3. `LazyLibrary`メカニズムを用いた遅延ライブラリロード

**関連システム・外部連携**：外部JLL依存なし。LibCURL_jll、LibGit2_jll、LibSSH2_jll等から依存される側のライブラリ。上流のzlibプロジェクト（https://zlib.net/）のバージョン1.3.1に対応。

**権限による制御**：特になし。全ユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUI画面を持たない。他のJLLパッケージの依存ライブラリとして使用される |

## 機能種別

データ連携（ネイティブライブラリバイナリ配布・動的リンク管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Sys.KERNEL | Symbol | Yes | 実行プラットフォームのカーネル識別子 | Windows/macOS/Linux/FreeBSDのいずれか |

### 入力データソース

- プラットフォーム情報: `Sys.iswindows()`, `Sys.isapple()`, `Sys.islinux()`, `Sys.isfreebsd()`

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libz | LazyLibrary | libz共有ライブラリへのハンドル（遅延ロード） |
| libz_path | String | libzの絶対ファイルパス |
| artifact_dir | String | アーティファクトディレクトリ |

### 出力先

- メモリ内グローバル変数としてモジュール内に保持

## 処理フロー

### 処理シーケンス

```
1. モジュール定義（baremodule）
   └─ Base, Libdl をusing
2. プラットフォーム判定によるライブラリパス決定
   └─ BundledLazyLibraryPathでOS別のlibzファイル名を設定
3. LazyLibrary定数の定義（依存なし）
4. __init__()実行
   └─ libz_path, artifact_dir, LIBPATH の設定
```

### フローチャート

```mermaid
flowchart TD
    A[モジュールロード] --> B{プラットフォーム判定}
    B -->|Windows| C["libz.dll"]
    B -->|macOS| D["libz.1.dylib"]
    B -->|Linux/FreeBSD| E["libz.so.1"]
    B -->|その他| F[error発生]
    C --> G[LazyLibrary生成（依存なし）]
    D --> G
    E --> G
    G --> H["__init__() 実行"]
    H --> I[パス変数設定]
    I --> J[初期化完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-146-01 | 依存なし | 外部JLL依存を持たない単独ライブラリ | 全環境 |
| BR-146-02 | 被依存ライブラリ | LibCURL_jll, LibGit2_jll, LibSSH2_jll等から依存される | ライブラリロード時 |
| BR-146-03 | プリコンパイル対応 | generating_output()時にeager_mode/is_availableをプリコンパイル | システムイメージ生成時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ErrorException | 未対応プラットフォーム | `error("Zlib_jll: Library 'libz' is not available for $(Sys.KERNEL)")` |
| - | DLError | ライブラリファイルが見つからない | dlopen失敗時のOSエラーメッセージ表示 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- LazyLibraryメカニズムにより遅延ロード
- 多数のJLLパッケージから依存されるため、初回ロードは早期に発生する

## セキュリティ考慮事項

- zlibの脆弱性（バッファオーバーフロー等）はJulia全体に影響するため、バージョン更新が重要

## 備考

- バージョン: zlib 1.3.1+2
- UUID: 83775a58-1f1d-513f-b197-d71354ab007a
- JuliaBinaryWrappersの上流リポジトリ: https://github.com/JuliaBinaryWrappers/Zlib_jll.jl
- Juliaの依存ツリーにおいて最も基盤的なJLLパッケージの一つ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | libdl.jl | `base/libdl.jl` | LazyLibrary構造体の基本定義 |

**読解のコツ**: Zlib_jllはPCRE2_jllと並んで最もシンプルなJLLパッケージ。外部依存なし、単一ライブラリ、46行のコード。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Zlib_jll.jl | `stdlib/Zlib_jll/src/Zlib_jll.jl` | モジュール全体の定義（46行） |

**主要処理フロー**:
1. **4行目**: `baremodule Zlib_jll` - モジュール定義開始
2. **5行目**: `using Base, Libdl` - 最小限の依存
3. **7行目**: `export libz` - 公開シンボル
4. **17-27行目**: `libz` LazyLibrary定数。OS別パス定義
5. **29-31行目**: `eager_mode()` - dlopen(libz)のみ
6. **34-39行目**: `__init__()` - パス変数設定
7. **41-44行目**: プリコンパイル指定

### プログラム呼び出し階層図

```
Zlib_jll.__init__()
    |
    +-- libz.path (LazyLibrary.path アクセス)
    |       |
    |       +-- BundledLazyLibraryPath("libz.so.1")
    |
    +-- artifact_dir = dirname(Sys.BINDIR)
    |
    +-- LIBPATH[] = dirname(libz_path)

Zlib_jll.eager_mode()
    |
    +-- dlopen(libz)

被依存関係:
    LibCURL_jll ----> Zlib_jll (libz)
    LibGit2_jll ----> Zlib_jll (libz)
    LibSSH2_jll ----> Zlib_jll (libz) [FreeBSD/macOS]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Sys.KERNEL (OS種別) ---------> プラットフォーム判定 ---------> ライブラリファイル名
Sys.BINDIR (Juliaパス) ------> BundledLazyLibraryPath ------> libz_path
                                      |
                                      v
                               dlopen(libz) ----------------> ccall利用可能状態
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Zlib_jll.jl | `stdlib/Zlib_jll/src/Zlib_jll.jl` | ソース | メインモジュール定義。libzのLazyLibrary定義 |
| Project.toml | `stdlib/Zlib_jll/Project.toml` | 設定 | パッケージメタデータ・バージョン情報 |
| libdl.jl | `base/libdl.jl` | ソース | LazyLibrary基盤実装 |
