# 機能設計書 147-LibGit2_jll

## 概要

本ドキュメントは、Julia標準ライブラリに含まれるLibGit2_jllパッケージの機能設計を記述する。LibGit2_jllは、libgit2ライブラリのJLLバイナリラッパーであり、Gitリポジトリ操作のためのネイティブライブラリをJuliaから利用可能にする。

### 本機能の処理概要

LibGit2_jllは、libgit2 CライブラリのプリビルドバイナリをJuliaのパッケージシステムを通じて提供するJLLラッパーパッケージである。プラットフォーム別のライブラリ名マッピング、複数の依存ライブラリ（LibSSH2, PCRE2, Zlib, OpenSSL）の自動ロードを行う。

**業務上の目的・背景**：Juliaのパッケージマネージャ（Pkg.jl）は、Gitリポジトリベースのパッケージレジストリの操作にlibgit2を使用している。LibGit2_jllは、このGit操作ライブラリのバイナリ配布と動的リンクを管理し、SSH認証対応のセキュアなGitリポジトリ操作を提供する。パッケージのクローン、フェッチ、チェックアウト等のGit操作の基盤として重要である。

**機能の利用シーン**：パッケージレジストリの同期（Pkg.update()等）、パッケージのクローン、LibGit2.jl標準ライブラリを直接使用したGitリポジトリ操作等で利用される。

**主要な処理内容**：
1. プラットフォーム（Windows/macOS/Linux/FreeBSD）に応じたlibgit2共有ライブラリパスの解決
2. 依存ライブラリ（LibSSH2, PCRE2, Zlib, OpenSSL）の自動ロード
3. プラットフォーム別の依存ライブラリ切り替え（macOSではOpenSSLを使用しない等）
4. `LazyLibrary`メカニズムを用いた遅延ライブラリロード

**関連システム・外部連携**：LibSSH2_jll（SSH接続）、PCRE2_jll（正規表現）、Zlib_jll（圧縮）、OpenSSL_jll（SSL/TLS、Linux/FreeBSD環境）への依存。Windows 32bit環境ではCompilerSupportLibraries_jllへの追加依存。上流のlibgit2プロジェクト（https://libgit2.org/）のバージョン1.9.2に対応。

**権限による制御**：特になし。全ユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUI画面を持たない。LibGit2/Pkg経由でGitリポジトリ操作時に使用される |

## 機能種別

データ連携（ネイティブライブラリバイナリ配布・動的リンク管理・Git操作基盤）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Sys.KERNEL | Symbol | Yes | 実行プラットフォームのカーネル識別子 | Windows/macOS/Linux/FreeBSDのいずれか |
| Sys.WORD_SIZE | Int | Yes | ポインタサイズ | 32または64（Windows 32bit判定用） |

### 入力データソース

- プラットフォーム情報: `Sys.iswindows()`, `Sys.isapple()`, `Sys.islinux()`, `Sys.isfreebsd()`
- ワードサイズ: `Sys.WORD_SIZE`（Windows 32bitでの追加依存判定に使用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libgit2 | LazyLibrary | libgit2共有ライブラリへのハンドル（遅延ロード） |
| libgit2_path | String | libgit2の絶対ファイルパス |
| artifact_dir | String | アーティファクトディレクトリ |

### 出力先

- メモリ内グローバル変数としてモジュール内に保持

## 処理フロー

### 処理シーケンス

```
1. モジュール定義（baremodule）
   └─ LibSSH2_jll, PCRE2_jll, Zlib_jll をusing
   └─ Windows/macOS以外ではOpenSSL_jllも追加using
   └─ Windows 32bitではCompilerSupportLibraries_jllも追加using
2. プラットフォーム判定によるライブラリパス決定
   └─ BundledLazyLibraryPathでOS別のlibgit2ファイル名を設定
3. LazyLibrary定数の定義
   └─ 依存ライブラリ（libssh2, libpcre2_8, libz, [libssl, libcrypto], [libgcc_s]）を指定
4. __init__()実行
   └─ libgit2_path, artifact_dir, LIBPATH の設定
```

### フローチャート

```mermaid
flowchart TD
    A[モジュールロード] --> B{プラットフォーム判定}
    B -->|Windows| C["libgit2.dll"]
    B -->|macOS| D["libgit2.1.9.dylib"]
    B -->|Linux/FreeBSD| E["libgit2.so.1.9"]
    B -->|その他| F[error発生]
    C --> G{Windows 32bit?}
    G -->|Yes| H["deps: libssh2, libgcc_s, libpcre2_8, libz"]
    G -->|No| I["deps: libssh2, libpcre2_8, libz"]
    D --> J["deps: libssh2, libpcre2_8, libz"]
    E --> K["deps: libssh2, libssl, libcrypto, libpcre2_8, libz"]
    H --> L["__init__() 実行"]
    I --> L
    J --> L
    K --> L
    L --> M[初期化完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-147-01 | SSL/TLS依存 | Linux/FreeBSDではOpenSSL_jllのlibsslとlibcryptoに依存 | Linux/FreeBSD環境 |
| BR-147-02 | macOS SSL | macOSではOS標準のSecureTransportを使用し、OpenSSLに依存しない | macOS環境 |
| BR-147-03 | Windows SSL | WindowsではOS標準のWinHTTPを使用し、OpenSSLに依存しない | Windows環境 |
| BR-147-04 | SSH依存 | 全プラットフォームでLibSSH2_jllに依存（SSH経由のGit操作サポート） | 全環境 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ErrorException | 未対応プラットフォーム | `error("LibGit2_jll: Library 'libgit2' is not available for $(Sys.KERNEL)")` |
| - | DLError | ライブラリファイルまたは依存ライブラリが見つからない | dlopen失敗時のOSエラーメッセージ表示 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- LazyLibraryメカニズムにより遅延ロード
- プリコンパイル対応（eager_mode, is_available）

## セキュリティ考慮事項

- SSH認証（LibSSH2）とSSL/TLS（OpenSSL）によるセキュアなGit通信
- Windows/macOSではOS標準のSSL実装を使用

## 備考

- バージョン: libgit2 1.9.2+0
- UUID: e37daf67-58a4-590a-8e99-b0245dd2ffc5
- JuliaBinaryWrappersの上流リポジトリ: https://github.com/JuliaBinaryWrappers/LibGit2_jll.jl
- stdlib/LibGit2/がこのJLLを使用するJuliaラッパー

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | libdl.jl | `base/libdl.jl` | LazyLibrary構造体のdependenciesフィールド |

**読解のコツ**: LibGit2_jllはLibSSH2_jll -> OpenSSL_jll -> Zlib_jllという深い依存チェーンを持つ。eager_mode()の実装を見ると依存の全体像がわかる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LibGit2_jll.jl | `stdlib/LibGit2_jll/src/LibGit2_jll.jl` | モジュール全体の定義（71行） |

**主要処理フロー**:
1. **5行目**: `baremodule LibGit2_jll` - モジュール定義開始
2. **6行目**: `using Base, Libdl, LibSSH2_jll, PCRE2_jll, Zlib_jll` - 依存JLLのusing
3. **7-9行目**: Windows/macOS以外でOpenSSL_jllを条件付きusing
4. **10-12行目**: Windows 32bitでCompilerSupportLibraries_jllを条件付きusing
5. **24-45行目**: `libgit2` LazyLibrary定数。プラットフォーム別のパスと依存リスト
6. **34-44行目**: 依存ライブラリの条件分岐。Win32: +libgcc_s、Linux/FreeBSD: +libssl+libcrypto
7. **47-56行目**: eager_mode()。LibSSH2_jll, OpenSSL_jll, CompilerSupportLibraries_jllのeager_mode()後にdlopen
8. **59-64行目**: __init__()。パス変数の設定

#### Step 3: 依存チェーンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LibSSH2_jll.jl | `stdlib/LibSSH2_jll/src/LibSSH2_jll.jl` | SSH依存ライブラリ。OpenSSL_jllに依存 |
| 3-2 | PCRE2_jll.jl | `stdlib/PCRE2_jll/src/PCRE2_jll.jl` | 正規表現ライブラリ。依存なし |
| 3-3 | Zlib_jll.jl | `stdlib/Zlib_jll/src/Zlib_jll.jl` | 圧縮ライブラリ。依存なし |
| 3-4 | OpenSSL_jll.jl | `stdlib/OpenSSL_jll/src/OpenSSL_jll.jl` | SSL/TLSライブラリ。依存なし |

### プログラム呼び出し階層図

```
LibGit2_jll.eager_mode()
    |
    +-- LibSSH2_jll.eager_mode()
    |       +-- Zlib_jll.eager_mode() [FreeBSD/macOS]
    |       +-- OpenSSL_jll.eager_mode() [非Windows]
    |       +-- dlopen(libssh2)
    |
    +-- OpenSSL_jll.eager_mode() [非Windows/macOS]
    |       +-- dlopen(libcrypto), dlopen(libssl)
    |
    +-- CompilerSupportLibraries_jll.eager_mode() [Windows 32bit]
    |
    +-- dlopen(libgit2)
```

### データフロー図

```
[入力]                              [処理]                              [出力]

Sys.KERNEL (OS種別) -------------> プラットフォーム判定 ----------> libgit2ファイル名
LibSSH2_jll.libssh2 ------------> SSH依存解決 -------------------> SSH接続機能
PCRE2_jll.libpcre2_8 -----------> 正規表現依存解決 ---------------> パターンマッチ機能
Zlib_jll.libz -------------------> 圧縮依存解決 -----------------> データ圧縮機能
OpenSSL_jll.libssl/libcrypto ----> SSL/TLS依存解決 [Linux等] -----> HTTPS機能
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LibGit2_jll.jl | `stdlib/LibGit2_jll/src/LibGit2_jll.jl` | ソース | メインモジュール定義。libgit2のLazyLibrary定義 |
| Project.toml | `stdlib/LibGit2_jll/Project.toml` | 設定 | パッケージメタデータ・依存関係・バージョン情報 |
| LibSSH2_jll.jl | `stdlib/LibSSH2_jll/src/LibSSH2_jll.jl` | ソース | SSH依存ライブラリ |
| PCRE2_jll.jl | `stdlib/PCRE2_jll/src/PCRE2_jll.jl` | ソース | 正規表現依存ライブラリ |
| Zlib_jll.jl | `stdlib/Zlib_jll/src/Zlib_jll.jl` | ソース | 圧縮依存ライブラリ |
| OpenSSL_jll.jl | `stdlib/OpenSSL_jll/src/OpenSSL_jll.jl` | ソース | SSL/TLS依存ライブラリ |
| libdl.jl | `base/libdl.jl` | ソース | LazyLibrary基盤実装 |
