# 機能設計書 148-LibSSH2_jll

## 概要

本ドキュメントは、Julia標準ライブラリに含まれるLibSSH2_jllパッケージの機能設計を記述する。LibSSH2_jllは、libssh2ライブラリのJLLバイナリラッパーであり、SSH2プロトコルによるセキュアな通信機能をJuliaから利用可能にする。

### 本機能の処理概要

LibSSH2_jllは、libssh2 CライブラリのプリビルドバイナリをJuliaのパッケージシステムを通じて提供するJLLラッパーパッケージである。プラットフォーム別のライブラリ名マッピング、依存ライブラリ（OpenSSL, Zlib）の自動ロードを行う。

**業務上の目的・背景**：libssh2はSSH2プロトコルのクライアント実装を提供するライブラリであり、JuliaにおいてはGitリポジトリへのSSH接続（LibGit2_jll経由）やHTTP通信でのSSH認証（LibCURL_jll経由）の基盤として使用される。LibSSH2_jllは、このSSH通信ライブラリのバイナリ配布と動的リンクを管理する。

**機能の利用シーン**：SSH認証を使用したGitリポジトリのクローン・フェッチ（`git@github.com:...`形式のURL）、SCP/SFTPファイル転送、SSH経由のHTTP通信等で間接的に利用される。

**主要な処理内容**：
1. プラットフォーム（Windows/macOS/Linux/FreeBSD）に応じたlibssh2共有ライブラリパスの解決
2. 依存ライブラリ（OpenSSL, Zlib）のプラットフォーム別条件付きロード
3. `LazyLibrary`メカニズムを用いた遅延ライブラリロード

**関連システム・外部連携**：OpenSSL_jll（暗号化基盤、非Windows環境）、Zlib_jll（圧縮、FreeBSD/macOS環境）への依存。Windows 32bit環境ではCompilerSupportLibraries_jllへの追加依存。上流のlibssh2プロジェクト（https://libssh2.org/）のバージョン1.11.3に対応。

**権限による制御**：特になし。全ユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUI画面を持たない。LibGit2/LibCURL経由でSSH通信時に使用される |

## 機能種別

データ連携（ネイティブライブラリバイナリ配布・動的リンク管理・SSH通信基盤）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Sys.KERNEL | Symbol | Yes | 実行プラットフォームのカーネル識別子 | Windows/macOS/Linux/FreeBSDのいずれか |
| Sys.WORD_SIZE | Int | Yes | ポインタサイズ | 32または64（Windows 32bit判定用） |

### 入力データソース

- プラットフォーム情報: `Sys.iswindows()`, `Sys.isapple()`, `Sys.islinux()`, `Sys.isfreebsd()`

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libssh2 | LazyLibrary | libssh2共有ライブラリへのハンドル（遅延ロード） |
| libssh2_path | String | libssh2の絶対ファイルパス |
| artifact_dir | String | アーティファクトディレクトリ |

### 出力先

- メモリ内グローバル変数としてモジュール内に保持

## 処理フロー

### 処理シーケンス

```
1. モジュール定義（baremodule）
   └─ FreeBSD/macOSではZlib_jllをusing
   └─ Windows 32bitではCompilerSupportLibraries_jllをusing
   └─ 非WindowsではOpenSSL_jllをusing
2. プラットフォーム判定によるライブラリパス決定
   └─ BundledLazyLibraryPathでOS別のlibssh2ファイル名を設定
3. LazyLibrary定数の定義
   └─ OS別の依存ライブラリ指定
4. __init__()実行
   └─ libssh2_path, artifact_dir, LIBPATH の設定
```

### フローチャート

```mermaid
flowchart TD
    A[モジュールロード] --> B{プラットフォーム判定}
    B -->|Windows| C["libssh2.dll"]
    B -->|macOS| D["libssh2.1.dylib"]
    B -->|Linux/FreeBSD| E["libssh2.so.1"]
    B -->|その他| F[error発生]
    C --> G{Windows 32bit?}
    G -->|Yes| H["deps: libgcc_s"]
    G -->|No| I["deps: なし"]
    D --> J["deps: libz, libcrypto"]
    E --> K{Linux?}
    K -->|Linux| L["deps: libcrypto"]
    K -->|FreeBSD| M["deps: libz, libcrypto"]
    H --> N["__init__() 実行"]
    I --> N
    J --> N
    L --> N
    M --> N
    N --> O[初期化完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-148-01 | Windows暗号化 | WindowsではOS標準の暗号化ライブラリ（WinCNG）を使用し、OpenSSLに依存しない | Windows環境 |
| BR-148-02 | 非Windows暗号化 | macOS/Linux/FreeBSDではOpenSSL_jllのlibcryptoに依存 | 非Windows環境 |
| BR-148-03 | FreeBSD/macOS圧縮 | FreeBSDとmacOSではZlib_jllのlibzに依存 | FreeBSD/macOS環境 |
| BR-148-04 | Linux圧縮不要 | Linuxではlibzへの直接依存なし（OpenSSL経由で利用される可能性あり） | Linux環境 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ErrorException | 未対応プラットフォーム | `error("LibSSH2_jll: Library 'libssh2' is not available for $(Sys.KERNEL)")` |
| - | DLError | ライブラリファイルが見つからない | dlopen失敗時のOSエラーメッセージ表示 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- LazyLibraryメカニズムにより遅延ロード
- プリコンパイル対応（eager_mode, is_available）

## セキュリティ考慮事項

- SSH2プロトコルによる暗号化通信の提供
- 公開鍵認証・パスワード認証のサポート
- WindowsではOS標準暗号化、他プラットフォームではOpenSSLを使用

## 備考

- バージョン: libssh2 1.11.3+1
- UUID: 29816b5a-b9ab-546f-933c-edad1886dfa8
- JuliaBinaryWrappersの上流リポジトリ: https://github.com/JuliaBinaryWrappers/LibSSH2_jll.jl
- LibGit2_jllとLibCURL_jllの両方から依存される重要な中間ライブラリ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | libdl.jl | `base/libdl.jl` | LazyLibrary構造体のdependenciesフィールド |

**読解のコツ**: LibSSH2_jllの依存関係はプラットフォームごとに大きく異なる。Windows: 依存なし（または32bitでlibgcc_sのみ）、Linux: libcryptoのみ、FreeBSD/macOS: libz+libcrypto。この差異に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LibSSH2_jll.jl | `stdlib/LibSSH2_jll/src/LibSSH2_jll.jl` | モジュール全体の定義（76行） |

**主要処理フロー**:
1. **5行目**: `baremodule LibSSH2_jll` - モジュール定義開始
2. **6行目**: `using Base, Libdl` - 基本依存
3. **7-9行目**: FreeBSD/macOSでZlib_jllを条件付きusing
4. **10-12行目**: Windows 32bitでCompilerSupportLibraries_jllを条件付きusing
5. **13-15行目**: 非WindowsでOpenSSL_jllを条件付きusing
6. **27-48行目**: `libssh2` LazyLibrary定数。プラットフォーム別のパスと依存リスト
7. **37-47行目**: 依存の条件分岐。Windows: 依存なし/libgcc_s、Linux: libcrypto、FreeBSD/macOS: libz+libcrypto
8. **50-61行目**: eager_mode()。条件付きで各依存JLLのeager_mode()を呼び出す
9. **64-69行目**: __init__()。パス変数の設定

### プログラム呼び出し階層図

```
LibSSH2_jll.eager_mode()
    |
    +-- [FreeBSD/macOS] Zlib_jll.eager_mode()
    |       +-- dlopen(libz)
    |
    +-- [Windows 32bit] CompilerSupportLibraries_jll.eager_mode()
    |       +-- dlopen(libgcc_s)
    |
    +-- [非Windows] OpenSSL_jll.eager_mode()
    |       +-- dlopen(libcrypto), dlopen(libssl)
    |
    +-- dlopen(libssh2)

被依存関係:
    LibGit2_jll ----> LibSSH2_jll (libssh2)
    LibCURL_jll ----> LibSSH2_jll (libssh2)
```

### データフロー図

```
[入力]                              [処理]                              [出力]

Sys.KERNEL (OS種別) -------------> プラットフォーム判定 ----------> libssh2ファイル名
OpenSSL_jll.libcrypto -----------> 暗号化依存解決 [非Win] -------> 暗号化機能
Zlib_jll.libz -------------------> 圧縮依存解決 [FreeBSD/macOS] -> 圧縮機能
                                      |
                                      v
                               dlopen(libssh2) ----------------> SSH2通信機能
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LibSSH2_jll.jl | `stdlib/LibSSH2_jll/src/LibSSH2_jll.jl` | ソース | メインモジュール定義。libssh2のLazyLibrary定義 |
| Project.toml | `stdlib/LibSSH2_jll/Project.toml` | 設定 | パッケージメタデータ・依存関係・バージョン情報 |
| OpenSSL_jll.jl | `stdlib/OpenSSL_jll/src/OpenSSL_jll.jl` | ソース | 暗号化依存ライブラリ |
| Zlib_jll.jl | `stdlib/Zlib_jll/src/Zlib_jll.jl` | ソース | 圧縮依存ライブラリ |
| libdl.jl | `base/libdl.jl` | ソース | LazyLibrary基盤実装 |
