# 機能設計書 96-コマンドラインインタフェース

## 概要

本ドキュメントは、Julia言語のコマンドラインインタフェース（CLI）機能の設計を記述する。`julia`実行ファイルからの起動処理、コマンドラインオプション解析、REPL起動までの流れを管理する機能である。

### 本機能の処理概要

**業務上の目的・背景**：ユーザがターミナルから`julia`コマンドを実行してJuliaセッションを開始する際に、コマンドラインオプションを解析し、適切な動作モード（REPL、スクリプト実行、コンパイル等）でランタイムを起動する必要がある。CLI機能はこの入口部分を担当する。

**機能の利用シーン**：`julia`コマンドの直接実行、`julia script.jl`によるスクリプト実行、`julia -e 'expr'`による式評価、`julia --project=@. -i`による対話モード起動、`julia -J sysimage.so`によるカスタムシステムイメージ使用。

**主要な処理内容**：
1. `main`/`mainCRTStartup`からの起動（`loader_exe.c`）
2. Windowsでの引数UTF-8変換
3. `jl_load_repl`経由でのREPLエントリーポイント呼び出し
4. コマンドラインオプション解析（`jl_parse_opts`/`jl_init_options`）
5. `jl_options_t`構造体への値設定
6. ヘルプメッセージの出力
7. ヒープサイズオプションの解析（`parse_heap_size_option`）

**関連システム・外部連携**：動的ローダー（`loader_lib.c`）、libjulia-internal、libjulia-codegen。

**権限による制御**：特にない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIツールのため関連画面なし |

## 機能種別

コマンドライン処理 / オプション解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| argc | int | Yes | コマンドライン引数の数 | >= 1 |
| argv | char** | Yes | コマンドライン引数配列 | NULLでないこと |

主要なコマンドラインオプション：

| オプション | 説明 | デフォルト |
|----------|------|----------|
| `-v, --version` | バージョン情報表示 | - |
| `-h, --help` | ヘルプ表示 | - |
| `-J, --sysimage <file>` | システムイメージ指定 | デフォルトsysimage |
| `-H, --home <dir>` | Julia実行ファイルの場所指定 | 自動検出 |
| `--project=<dir>` | プロジェクト/環境指定 | NULL |
| `-e <expr>` | 式の評価 | - |
| `-t, --threads <n>` | スレッド数指定 | auto |
| `-p, --procs <n>` | ワーカープロセス数 | 0 |
| `--startup-file={yes\|no}` | startup.jlのロード | yes |
| `--compiled-modules={yes\|no\|existing\|strict}` | プリコンパイル制御 | yes |
| `-O, --optimize <level>` | 最適化レベル（0-3） | 2 |
| `-g <level>` | デバッグ情報レベル（0-2） | 1（release）/ 2（debug） |
| `--check-bounds={yes\|no\|auto}` | 境界チェック制御 | auto |
| `--heap-size-hint=<size>` | ヒープサイズヒント | 0 |

### 入力データソース

- OSからのコマンドライン引数
- 環境変数（`JULIA_DEPOT_PATH`, `JULIA_NUM_THREADS`等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| jl_options | jl_options_t | 解析済みオプション構造体 |
| 終了コード | int | プロセスの終了コード |

### 出力先

`jl_options`グローバル変数、プロセス終了コード

## 処理フロー

### 処理シーケンス

```
1. main/mainCRTStartup（loader_exe.c）
   ├─ Windows: CommandLineToArgv → UTF-8変換
   └─ ASAN/TSAN: LBT_USE_RTLD_DEEPBIND=0設定
2. jl_load_repl呼出（loader_lib.c）
   └─ libjulia-internal内のjl_repl_entrypointを呼出
3. jl_parse_opts（jloptions.c）
   ├─ jl_init_optionsでデフォルト値設定
   ├─ getopt_longで引数解析
   └─ 各オプションをjl_options構造体に格納
4. ランタイム初期化（jl_init_）
5. REPL/スクリプト実行
```

### フローチャート

```mermaid
flowchart TD
    A[main / mainCRTStartup] --> B{Windows?}
    B -->|Yes| C[CommandLineToArgv + wchar_to_utf8]
    B -->|No| D[argv直接使用]
    C --> E[jl_load_repl]
    D --> E
    E --> F[jl_repl_entrypoint]
    F --> G[jl_parse_opts]
    G --> H[jl_init_options デフォルト設定]
    H --> I[getopt_long ループ]
    I --> J{オプション解析}
    J -->|--version| K[バージョン出力して終了]
    J -->|--help| L[ヘルプ出力して終了]
    J -->|その他| M[jl_optionsに値設定]
    M --> N[jl_init_ ランタイム初期化]
    N --> O[REPL/スクリプト実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-96-01 | デフォルト値初期化 | jl_init_optionsでjl_options_t全フィールドにデフォルト値を設定 | 1回のみ実行（jl_options_initializedフラグ） |
| BR-96-02 | ヒープサイズ解析 | 数値+単位（B/K/M/G/T/%）を解析、UINT64_MAX上限 | --heap-size-hint等 |
| BR-96-03 | ascii_tolower | ロケール非依存のASCII小文字変換を使用 | ユニット文字の比較時 |
| BR-96-04 | shared_ext | プラットフォーム固有の共有ライブラリ拡張子（.dll/.dylib/.so） | sysimage検索時 |

### 計算ロジック

- `parse_heap_size_option`: `value * multiplier`を計算、`multiplier`は単位に応じて`1<<10`(K)、`1<<20`(M)、`1<<30`(G)、`1<<40`(T)、またはメモリ割合（%時は`uv_get_total_memory()/100`）

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 無効なオプション | 認識できないオプション指定 | ヘルプメッセージ出力しexit(1) |
| - | ヒープサイズ解析エラー | 無効な数値/単位指定 | jl_errorfでエラーメッセージ出力 |
| - | UTF-8変換失敗 | Windows引数変換失敗 | stderrにエラー出力しreturn 1 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

オプション解析は起動時に1回のみ実行されるため、パフォーマンス要件は緩い。

## セキュリティ考慮事項

- 環境変数`JULIA_DEPOT_PATH`等が設定パスに影響するため、信頼できない環境では注意が必要
- `--handle-signals=no`はセキュリティ上のリスクではないが、GCセーフポイントが機能しなくなる

## 備考

- `system_image_path`は256バイトの固定バッファにコンパイル時に設定される
- `--help-hidden`で非公開オプションを表示可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | jloptions.h | `src/jloptions.h` | jl_options_t構造体の全フィールド定義 |

**読解のコツ**: `jl_options_t`は約50フィールドを持つ大きな構造体である。各フィールドのコメントに説明があるので、まず概観を把握すること。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | loader_exe.c | `cli/loader_exe.c` | main/mainCRTStartup（28-63行目） |

**主要処理フロー**:
1. **28-31行目**: Windows: `CommandLineToArgv`で引数取得
2. **39-43行目**: ASAN/TSAN: `LBT_USE_RTLD_DEEPBIND=0`設定
3. **47-54行目**: Windows: `wchar_to_utf8`で各引数をUTF-8変換
4. **58行目**: `jl_load_repl(argc, argv)`呼び出し

#### Step 3: オプション解析を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | jloptions.c | `src/jloptions.c` | jl_init_options（89行目）、parse_heap_size_option（39行目） |

**主要処理フロー**:
- **89-171行目**: `jl_init_options` - 全フィールドのデフォルト値設定
- **39-85行目**: `parse_heap_size_option` - サイズ文字列の解析
- **173-207行目**: usage/optsメッセージ定義

### プログラム呼び出し階層図

```
main (loader_exe.c:35)
    +-- CommandLineToArgv()  [Windows]
    +-- wchar_to_utf8()      [Windows]
    +-- jl_load_repl(argc, argv) (loader_lib.c:442)
            +-- jl_repl_entrypoint() [libjulia-internal]
                    +-- jl_parse_opts() (jloptions.c)
                    |       +-- jl_init_options()
                    |       +-- getopt_long() ループ
                    |       +-- parse_heap_size_option()
                    +-- jl_init_()
                    +-- REPL/スクリプト実行
```

### データフロー図

```
[入力]                    [処理]                           [出力]

argc/argv ──────────────> jl_parse_opts ─────────────────> jl_options (グローバル)
  (コマンドライン)            |
                             +-- getopt_long
                             +-- parse_heap_size_option

環境変数 ───────────────> 各init関数 ──────────────────> ランタイム設定
  JULIA_NUM_THREADS
  JULIA_DEPOT_PATH
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| loader_exe.c | `cli/loader_exe.c` | ソース | main関数（実行ファイルエントリーポイント） |
| jloptions.c | `src/jloptions.c` | ソース | コマンドラインオプション解析 |
| jloptions.h | `src/jloptions.h` | ヘッダ | jl_options_t構造体定義 |
| loader.h | `cli/loader.h` | ヘッダ | ローダー共通定義 |
| loader_lib.c | `cli/loader_lib.c` | ソース | jl_load_repl実装 |
