---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-プリミティブ型定義

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **C-17**: jl_init_types()の具体的な処理順序について、Cソースの直接確認が不足
  2. **C-18**: 起動時の型初期化所要時間（数ミリ秒以内）の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/boot.jl` 248-253行目（抽象型階層定義）
- E-02: `base/boot.jl` 255-274行目（primitive type宣言）
- E-03: `base/boot.jl` 276-280行目（Int/UIntプラットフォームエイリアス）
- E-04: `base/boot.jl` 207-243行目（export文）
- E-05: `base/boot.jl` 18-30行目（DataType構造体コメント）
- E-06: `base/boot.jl` 259行目（BFloat16の定義）
- E-07: `base/float.jl` 3行目（IEEEFloat定義）
- E-08: `base/float.jl` 15-97行目（Inf/NaN定数定義）
- E-09: `base/float.jl` 107-138行目（ビットマスク関数）
- E-10: `base/boot.jl` 261行目（Bool型のコメント）
- E-11: `機能一覧.csv` 1行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 抽象型階層がNumber > Real > Integer/AbstractFloat > Signed/Unsignedである | E-01 | ○ |
| C-02 | primitive typeでビット幅を指定して型を宣言する | E-02 | ○ |
| C-03 | Float16/32/64がAbstractFloatのサブタイプである | E-02 | ○ |
| C-04 | Int8/16/128がSignedのサブタイプ、UInt128がUnsignedのサブタイプである | E-02 | ○ |
| C-05 | Int/UIntがプラットフォーム依存で32/64ビットに設定される | E-03 | ○ |
| C-06 | 型がCoreモジュールからexportされる | E-04 | ○ |
| C-07 | DataType構造体がname, super, parameters等のフィールドを持つ | E-05 | ○ |
| C-08 | BFloat16型が追加されている | E-06 | ○ |
| C-09 | IEEEFloatがFloat16/32/64のUnionとして定義されている | E-07 | ○ |
| C-10 | Inf/NaN定数が各精度で定義されている | E-08 | ○ |
| C-11 | ビットマスク関数が浮動小数点型に対して定義されている | E-09 | ○ |
| C-12 | BoolがIntegerのサブタイプとしてCで定義されている | E-10 | ○ |
| C-13 | 一部の型はCランタイムで直接定義されboot.jlではコメント | E-02, E-10 | ○ |
| C-14 | プリミティブ型のビット幅は8の倍数 | E-02 | ○ |
| C-15 | 型定義はbase/boot.jlで行われる | E-11, E-01 | ○ |
| C-16 | IEEE 754準拠のビット表現を持つ | E-08, E-09 | ○ |
| C-17 | jl_init_types()でDataTypeオブジェクトが生成される | **根拠なし** | △ |
| C-18 | 起動時の型初期化は数ミリ秒以内に完了する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: src/jltypes.cのソースコードを直接読み込んでいないため、jl_init_types()の内部処理の正確な記述が確認できていない
  - 候補：src/jltypes.c / src/init.c / src/datatype.c
- C-18: パフォーマンス計測データが存在しないため、初期化時間の具体的数値は推定値である
  - 候補：ベンチマークデータ / CI計測ログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型階層の記述はソースコードと整合
- 0: 低リスク - export文の記載はソースコードと一致
- 1: 中リスク - Cランタイムの処理詳細はJuliaソースからの推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] boot.jlの型定義行番号が最新のソースと一致しているか確認
- [ ] BFloat16がJulia 1.11以降で追加された記述が正しいか確認
- [ ] src/jltypes.cのjl_init_types()の記述が実際のCコードと一致するか確認
