---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：10-有理数演算

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**: checked.jlの存在とchecked_neg/checked_mulの定義場所

## 2) 参照した情報（Evidence一覧）

- E-01: `base/rational.jl` 9-15行目（Rational{T}構造体定義）
- E-02: `base/rational.jl` 14行目（unsafe_rational内部コンストラクタ）
- E-03: `base/rational.jl` 17-18行目（unsafe_rational外部コンストラクタ）
- E-04: `base/rational.jl` 20-26行目（checked_den関数）
- E-05: `base/rational.jl` 30行目（ゼロエラーヘルパー）
- E-06: `base/rational.jl` 31-46行目（Rational{T}メインコンストラクタ）
- E-07: `base/rational.jl` 48-50行目（Rational外部コンストラクタ）
- E-08: `base/rational.jl` 52-62行目（divgcd関数）
- E-09: `base/rational.jl` 64-91行目（//演算子定義）
- E-10: `base/rational.jl` 93-105行目（//の各種オーバーロード）
- E-11: `base/rational.jl` 107-143行目（Complex対応//演算子）
- E-12: `base/rational.jl` 147行目以降（show関数）
- E-13: `base/intfuncs.jl` 44-95行目（gcd関数）
- E-14: `機能一覧.csv` 10行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Rational{T<:Integer}がRealのサブタイプとして定義 | E-01 | ○ |
| C-02 | num::Tとden::Tの2フィールドを持つ | E-01 | ○ |
| C-03 | unsafe_rationalがチェックをバイパスする内部コンストラクタ | E-02 | ○ |
| C-04 | checked_denが分母の符号正規化を行う | E-04 | ○ |
| C-05 | 0//0でArgumentErrorが投げられる | E-05, E-06 | ○ |
| C-06 | Unsigned型で負の結果はInexactError | E-06 | ○ |
| C-07 | divgcdがgcdで約分を行う | E-08 | ○ |
| C-08 | //(n::Integer, d::Integer) = Rational(n, d) | E-09 | ○ |
| C-09 | Rational/Integer, Integer/Rational等の//オーバーロード | E-10 | ○ |
| C-10 | Complex対応の//演算子が定義されている | E-11 | ○ |
| C-11 | show関数がnum//den形式で表示する | E-12 | ○ |
| C-12 | gcd関数がSteinのバイナリアルゴリズムで実装 | E-13 | ○ |
| C-13 | AbstractFloat引数の//はMethodError | E-09 | ○ |
| C-14 | 自動約分が構築時に行われる | E-06, E-08 | ○ |
| C-15 | 分母は常に正に正規化される | E-04 | ○ |
| C-16 | checked_mulでオーバーフロー検査が行われる | E-10 | ○ |
| C-17 | 定義はbase/rational.jlで行われる | E-14 | ○ |
| C-18 | checked.jlにchecked_neg/checked_mulが定義されている | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: base/checked.jlの存在と内容を直接確認していない（checked_neg, checked_mulはrational.jl内で使用されているが定義元は未確認）
  - 候補：base/checked.jl / base/int.jl

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Rational型定義の記述はソースと高い整合性
- 0: 低リスク - //演算子と約分処理の記述は正確
- 0: 低リスク - エラー処理の記述はソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] rational.jlの行番号が最新ソースと一致しているか確認
- [ ] checked_neg/checked_mulの定義元ファイルを確認
- [ ] 四則演算の具体的な実装（rational.jlの後半）を確認
