---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：101-Printf

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **BigFloat最大出力バイト数の根拠**：8192は定数として定義されているが、その妥当性の根拠が不明

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/Printf/src/Printf.jl` 33-43行目 -- Spec構造体定義
- E-02: `stdlib/Printf/src/Printf.jl` 82-93行目 -- Format構造体定義
- E-03: `stdlib/Printf/src/Printf.jl` 99-125行目 -- InvalidFormatStringError定義
- E-04: `stdlib/Printf/src/Printf.jl` 128-275行目 -- Formatコンストラクタ（パーサー）
- E-05: `stdlib/Printf/src/Printf.jl` 500-676行目 -- 浮動小数点フォーマット（Ryu/MPFR連携）
- E-06: `stdlib/Printf/src/Printf.jl` 386-462行目 -- 整数フォーマット
- E-07: `stdlib/Printf/src/Printf.jl` 1009-1021行目 -- @printfマクロ定義
- E-08: `stdlib/Printf/src/Printf.jl` 1034-1038行目 -- @sprintfマクロ定義
- E-09: `stdlib/Printf/src/Printf.jl` 935-948行目 -- format関数定義
- E-10: `stdlib/Printf/src/Printf.jl` 297-311行目 -- rmdynamic関数（動的幅・精度）
- E-11: `stdlib/Printf/src/Printf.jl` 486-488行目 -- tofloat関数
- E-12: `stdlib/Printf/src/Printf.jl` 490-492行目 -- mpfr_snprintf ccall
- E-13: `stdlib/Printf/src/Printf.jl` 498行目 -- __BIG_FLOAT_MAX__定数
- E-14: `stdlib/Printf/src/Printf.jl` 815行目 -- UNROLL_UPTO定数
- E-15: `stdlib/Printf/src/Printf.jl` 901-919行目 -- computelen関数
- E-16: `stdlib/Printf/src/Printf.jl` 14-20行目 -- 指定子カテゴリ型定義
- E-17: `stdlib/Printf/src/Printf.jl` 7行目 -- using Base.Ryu

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Spec{T}構造体がフォーマット指定子を型パラメータで表現 | E-01 | ○ |
| C-02 | Format{S,T}がフォーマット文字列全体を表現 | E-02 | ○ |
| C-03 | InvalidFormatStringErrorで不正指定子をエラー報告 | E-03 | ○ |
| C-04 | フォーマット文字列パーサーがフラグ・幅・精度・型を解析 | E-04 | ○ |
| C-05 | %d,%i,%u,%x,%X,%o等の整数指定子をサポート | E-06, E-16 | ○ |
| C-06 | %e,%E,%f,%F,%g,%G,%a,%A等の浮動小数点指定子をサポート | E-05, E-16 | ○ |
| C-07 | 動的幅・精度（*）をサポート | E-10 | ○ |
| C-08 | @printfマクロがIOへ出力 | E-07 | ○ |
| C-09 | @sprintfマクロがStringを返す | E-08 | ○ |
| C-10 | format関数がバッファ確保と書き込みを行う | E-09 | ○ |
| C-11 | Base.Ryuを浮動小数点フォーマットに使用 | E-17, E-05 | ○ |
| C-12 | BigFloatはMPFRのmpfr_snprintfを使用 | E-12 | ○ |
| C-13 | tofloatでカスタム数値型の拡張が可能 | E-11 | ○ |
| C-14 | BigFloat出力が8192バイトを超過した場合にArgumentError | E-13 | ○ |
| C-15 | 16個までのフォーマット指定子でループアンロール | E-14, E-15 | ○ |
| C-16 | computelenでバッファサイズを事前計算 | E-15 | ○ |
| C-17 | 引数数の不一致でArgumentError | E-09 | ○ |
| C-18 | 8192バイト制限の妥当性根拠 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 8192バイト制限の妥当性：コード中のコメントでは "Arbitrary constant" と記載されており、明確な根拠は不明
  - 候補：MPFR仕様書 / Juliaのイシュートラッカー / パフォーマンスベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全体的にソースコードとの整合性が高い
- 0: 低リスク -- フォーマット指定子のサポート範囲はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Spec構造体のフィールドが設計書の記載と一致するか確認
- [ ] サポートするフォーマット指定子の一覧が網羅的か確認
- [ ] BigFloat制限値（8192）の妥当性を確認
