---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 10
  claims_without_evidence: 4
confidence_derived: 0.71
---

# 根拠レポート：109-SHA

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.71**
  - 根拠あり：10 / 14、根拠なし：4
- 優先レビュー（高）
  1. **SHA.jl外部パッケージの内部実装詳細**：ソースコードがstdlib内に存在しないため直接検証不可
  2. **SHA-3のKeccak実装詳細**：外部リポジトリの確認が必要
  3. **HMAC実装の正確性**：外部リポジトリの確認が必要
  4. **ストリーミングAPIの詳細**：外部リポジトリの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/SHA.version` -- SHA_SHA1, SHA_GIT_URL, SHA_BRANCH
- E-02: JuliaCrypto/SHA.jl README（公開リポジトリ情報）-- APIドキュメント
- E-03: 機能一覧.csv -- 機能No.109の説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SHA.jlが外部パッケージ | E-01 | ○ |
| C-02 | リポジトリURLがhttps://github.com/JuliaCrypto/SHA.jl.git | E-01 | ○ |
| C-03 | masterブランチを使用 | E-01 | ○ |
| C-04 | コミットハッシュ876bc0400f9a457eb2736388fc3d0fbe9460fc7d | E-01 | ○ |
| C-05 | SHA-1/SHA-2/SHA-3ファミリーをサポート | E-02 | ○ |
| C-06 | HMAC計算をサポート | E-02 | ○ |
| C-07 | Pure Julia実装 | E-02 | ○ |
| C-08 | SHA-1出力が20バイト | E-02 | ○ |
| C-09 | SHA-256出力が32バイト | E-02 | ○ |
| C-10 | ストリーミングAPI（CTXオブジェクト） | E-02 | ○ |
| C-11 | SHA-3がKeccak-f[1600]を使用 | **根拠なし** | △ |
| C-12 | HMACがRFC 2104準拠 | **根拠なし** | △ |
| C-13 | update!/digest! APIの詳細フロー | **根拠なし** | △ |
| C-14 | SHA-2の64/80ラウンド圧縮関数 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SHA.jlの外部ソースコードがstdlib内に含まれないため、内部実装の直接検証ができない
  - 候補：外部リポジトリ https://github.com/JuliaCrypto/SHA.jl のソースコードを確認
  - 候補：ビルド時に展開されるソースコード（`~/.julia/packages/SHA/`等）を確認

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク -- 外部パッケージのため直接のソースコード検証ができない
- 1: 中リスク -- 暗号学的アルゴリズムの正確性は外部リポジトリの検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 外部リポジトリのソースコードを確認し、内部実装の正確性を検証
- [ ] SHA-1の非推奨警告が適切に文書化されているか確認
- [ ] HMAC実装のRFC 2104準拠を確認
- [ ] SHA.versionのコミットハッシュが最新かつセキュリティパッチ適用済みか確認
