---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：11-多倍長整数（BigInt）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **C-25**: パッチ版GMPのALLOC_OVERFLOW_FUNCTION動作の実機検証が根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `base/gmp.jl` 64-74行目（BigInt構造体定義）
- E-02: `base/gmp.jl` 108-139行目（__init__関数）
- E-03: `base/gmp.jl` 142-274行目（MPZモジュール）
- E-04: `base/gmp.jl` 315-346行目（BigIntコンストラクタ群）
- E-05: `base/gmp.jl` 496-503行目（二項演算定義）
- E-06: `base/gmp.jl` 548-563行目（混合型演算）
- E-07: `base/gmp.jl` 637-672行目（冪乗・powermod）
- E-08: `base/gmp.jl` 407-434行目（Float64変換）
- E-09: `base/gmp.jl` 763-780行目（string変換）
- E-10: `base/gmp.jl` 915-953行目（hash最適化）
- E-11: `base/gmp.jl` 956-1109行目（MPQモジュール）
- E-12: `base/gmp.jl` 280-281行目（widen定義）
- E-13: `base/gmp.jl` 479行目（promote_rule定義）
- E-14: `base/gmp.jl` 715行目（factorial定義）
- E-15: `base/gmp.jl` 717-726行目（binomial定義）
- E-16: `base/gmp.jl` 518-535行目（invmod定義）
- E-17: `base/gmp.jl` 674-685行目（gcdx定義）
- E-18: `base/gmp.jl` 691-713行目（prod分割統治法）
- E-19: `base/gmp.jl` 688-689行目（sum foldl実装）
- E-20: `base/gmp.jl` 289-313行目（tryparse_internal）
- E-21: `base/gmp.jl` 100-106行目（ALLOC_OVERFLOW_FUNCTION定義）
- E-22: `base/gmp.jl` 858行目（deepcopy_internal定義）
- E-23: `docs/code-to-docs/機能一覧/機能一覧.csv` 12行目
- E-24: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BigIntはGMPのmpz系関数をccallで呼び出す | E-03 | ○ |
| C-02 | BigInt構造体はalloc, size, dの3フィールド | E-01 | ○ |
| C-03 | __init__でGMPメモリ関数をJulia GC関数に差し替え | E-02 | ○ |
| C-04 | finalizerに__gmpz_clearを登録 | E-01 (71行目) | ○ |
| C-05 | Clong範囲のIntegerはset_si/set_uiで高速変換 | E-04 (315-316行目) | ○ |
| C-06 | 範囲外IntegerはLimb単位の手動設定 | E-04 (329-346行目) | ○ |
| C-07 | Float64変換時にisinteger(x)チェック | E-04 (321-323行目) | ○ |
| C-08 | 文字列パースで基数2-62をサポート | E-20 (294行目) | ○ |
| C-09 | widen(Int128) = widen(UInt128) = BigInt | E-12 | ○ |
| C-10 | promote_rule(BigInt, Integer) = BigInt | E-13 | ○ |
| C-11 | 二項演算（+,-,*等）はMPZ関数経由 | E-05 | ○ |
| C-12 | BigIntとCulongMax/ClongMaxの直接演算を提供 | E-06 | ○ |
| C-13 | powermodはMPZ.powmで計算、m<0時に結果調整 | E-07 (667-670行目) | ○ |
| C-14 | gcdxはMPZ.gcdextで計算、a==b時の補正あり | E-17 | ○ |
| C-15 | Float64変換はlimb数から指数計算、上位54ビット抽出 | E-08 | ○ |
| C-16 | factorial(n)でn<0はDomainError | E-14 | ○ |
| C-17 | invmod(n,m)でm==0またはgcd!=1はDomainError | E-16 | ○ |
| C-18 | prod(Array{BigInt})は分割統治法 | E-18 | ○ |
| C-19 | sum(Array{BigInt})はfoldlによるin-place加算 | E-19 | ○ |
| C-20 | string変換はMPZ.get_str!による | E-09 | ○ |
| C-21 | 64ビットシステムでhash関数の特殊最適化あり | E-10 | ○ |
| C-22 | MPQモジュールでRational{BigInt}の高速演算 | E-11 | ○ |
| C-23 | add/subでビット数事前計算による最適割り当て | E-03 (164-165行目) | ○ |
| C-24 | deepcopy_internalはMPZ.setでコピー | E-22 | ○ |
| C-25 | ALLOC_OVERFLOW_FUNCTIONでOutOfMemoryError変換 | E-21 | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: ALLOC_OVERFLOW_FUNCTIONの動作はパッチ版GMPでのみ有効。実際のJuliaビルドでこのパッチが適用されているかは環境依存であり、コード上はtry-catchで対応している（128-138行目）が、実機での動作確認は本レポートの範囲外。
  - 候補：GMPビルドスクリプト / deps/patches/ / BinaryBuilder設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - BigInt構造体定義とGMP関数ラッパーはコードから明確に確認可能
- 0: 低リスク - 算術演算の定義はメタプログラミングを使用しているが、パターンは明確
- 1: 中リスク - Float64変換のビット操作は複雑で、丸めの正確性は実行テストでの検証が望ましい
- 0: 低リスク - メモリ管理はGMP初期化時の一度の設定で完結

## 6) レビュアーチェックリスト（最小）
- [ ] BigInt構造体のフィールドがGMP mpz_structと正しく対応しているか
- [ ] __init__でのメモリ関数設定がGMP仕様に準拠しているか
- [ ] Float64変換の丸めモード（RoundNearest）が正しく実装されているか
- [ ] ALLOC_OVERFLOW_FUNCTIONの環境依存性が運用上問題ないか
- [ ] MPQモジュールのsync_rational!がデータの一貫性を保っているか
