---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：113-Profile

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **サンプリングオーバーヘッド5%以下**：定量的根拠なし
  2. **デフォルトサンプリング間隔**：Profile.jl内のinit()実装詳細の確認が必要
  3. **ヒープスナップショットのChrome DevTools互換性**：heapsnapshot.jlの実装確認が必要

## 2) 参照した情報（Evidence一覧）
- E-01: `stdlib/Profile/src/Profile.jl` -- メインソースコード
- E-02: `stdlib/Profile/src/Allocs.jl` -- アロケーションプロファイラ
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` -- 機能一覧での記載

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @profileマクロでCPUサンプリングプロファイリングを実行 | E-01 | ○ |
| C-02 | Profile.printでフラット/ツリー表示を提供 | E-01 | ○ |
| C-03 | Profile.initでバッファサイズとサンプリング間隔を設定 | E-01 | ○ |
| C-04 | Profile.clearでバッファをクリア | E-01 | ○ |
| C-05 | Allocs.@profileでアロケーションプロファイリングを実行 | E-02 | ○ |
| C-06 | sample_rateパラメータでサンプリング率を制御 | E-02 | ○ |
| C-07 | RawBacktrace, RawAlloc, RawResultsはC側構造体と対応 | E-02 | ○ |
| C-08 | Allocs.@profileのデフォルトsample_rateは0.1 | E-02 | ○ |
| C-09 | Profile.Allocs.fetchで結果を取得 | E-02 | ○ |
| C-10 | ccallでCランタイムのプロファイリング機能を呼び出す | E-01, E-02 | ○ |
| C-11 | Julia 1.8でアロケーションプロファイラが追加 | E-02 | ○ |
| C-12 | Julia 1.11以降、全アロケーションの型を正しく報告 | E-02 | ○ |
| C-13 | サンプリングオーバーヘッドは通常5%以下 | **根拠なし** | △ |
| C-14 | デフォルトサンプリング間隔は約1ミリ秒 | **根拠なし** | △ |
| C-15 | ヒープスナップショットはChrome DevTools互換JSON形式 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- サンプリングオーバーヘッドの定量的計測データ
  - 候補：Juliaドキュメント / ベンチマーク結果
- デフォルトサンプリング間隔の実装値
  - 候補：Profile.jl内のinit()関数デフォルト引数
- ヒープスナップショットの出力形式詳細
  - 候補：stdlib/Profile/src/heapsnapshot.jl

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 基本API、構造体定義は正確
- 1: 中リスク -- パフォーマンス数値は要検証
- 1: 中リスク -- ヒープスナップショット形式の互換性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] Profile.init()のデフォルトパラメータを確認
- [ ] heapsnapshot.jlの出力形式を確認
- [ ] サンプリングオーバーヘッドの実測値を確認
