---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：114-InteractiveUtils

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **エディタ優先順位の詳細**：editless.jlの実装確認が必要
  2. **varinfo()の実装詳細**：出力フォーマットの確認

## 2) 参照した情報（Evidence一覧）
- E-01: `stdlib/InteractiveUtils/src/InteractiveUtils.jl` -- メインモジュール
- E-02: `stdlib/InteractiveUtils/src/codeview.jl` -- コード表示ロジック
- E-03: `stdlib/InteractiveUtils/src/macros.jl` -- マクロ定義
- E-04: `stdlib/InteractiveUtils/src/clipboard.jl` -- クリップボード操作
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` -- 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @code_warntypeで型推論結果を色付き表示 | E-02 | ○ |
| C-02 | @code_llvmでLLVM IRを表示 | E-01, E-02 | ○ |
| C-03 | @code_nativeでネイティブアセンブリを表示 | E-01, E-02 | ○ |
| C-04 | ArgInfo構造体で関数シグネチャを解決 | E-02 | ○ |
| C-05 | highlighting辞書でハイライト設定を管理 | E-02 | ○ |
| C-06 | warntype_type_printerで型安定性に基づく色付け | E-02 | ○ |
| C-07 | Core.Builtinの場合ArgumentError | E-02 | ○ |
| C-08 | macOSでpbcopy/pbpasteを使用 | E-04 | ○ |
| C-09 | tmux内でreattach-to-user-namespaceに対応 | E-04 | ○ |
| C-10 | Linux/FreeBSDでxsel/xclip/wl-clipboardに対応 | E-04 | ○ |
| C-11 | typesof_exprで引数から型タプルを構築 | E-03 | ○ |
| C-12 | extract_where_parametersでwhere句を処理 | E-03 | ○ |
| C-13 | @time_imports等はBaseからre-export | E-03 | ○ |
| C-14 | エディタ優先順位: JULIA_EDITOR > VISUAL > EDITOR | **根拠なし** | △ |
| C-15 | varinfo()で変数情報を表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- edit()の実装詳細（editless.jl）の直接確認が必要
  - 候補：stdlib/InteractiveUtils/src/editless.jl
- varinfo()の実装と出力フォーマット
  - 候補：stdlib/InteractiveUtils/src/InteractiveUtils.jl内の実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- コード検査マクロ群、クリップボード操作は正確
- 0: 低リスク -- ハイライト設定の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] editless.jlのエディタ優先順位を確認
- [ ] varinfo()の実装と出力を確認
- [ ] @code_typed等の追加マクロの網羅性を確認
