---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：116-FileWatching

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **libuv内部のOS分岐詳細**：inotify/FSEvents/ReadDirectoryChangesの使い分け
  2. **poll_fileのポーリング実装**：statベースの詳細動作

## 2) 参照した情報（Evidence一覧）
- E-01: `stdlib/FileWatching/src/FileWatching.jl` -- メインソースコード
- E-02: `stdlib/FileWatching/src/pidfile.jl` -- Pidfileサブモジュール
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` -- 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | watch_fileでファイルの変更・名前変更を監視 | E-01 | ○ |
| C-02 | watch_folderでディレクトリ内の変更を監視 | E-01 | ○ |
| C-03 | poll_fdでFD読み書き可能状態をポーリング | E-01 | ○ |
| C-04 | FileEvent構造体にchanged/renamed/timedoutフラグ | E-01 | ○ |
| C-05 | mkpidlockでPIDファイルベースの排他ロック | E-02 | ○ |
| C-06 | trymkpidlockは非ブロッキング版 | E-02 | ○ |
| C-07 | LockMonitor構造体（path, fd, update） | E-02 | ○ |
| C-08 | open_exclusiveでO_EXCLフラグを使用 | E-02 | ○ |
| C-09 | refreshタイマーでmtime更新 | E-02 | ○ |
| C-10 | stale_age/2がデフォルトのrefresh間隔 | E-02 | ○ |
| C-11 | trymkpidlockはJulia 1.10で追加 | E-02 | ○ |
| C-12 | libuvのuv_fs_eventを使用 | E-01 | ○ |
| C-13 | inotify/FSEvents/ReadDirectoryChangesの使い分け | **根拠なし** | △ |
| C-14 | poll_fileはstatベースのポーリング | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- libuvの内部でのOS固有ファイル監視APIの使い分け詳細
  - 候補：libuvドキュメント / libuv ソースコード
- poll_file関数の実装詳細
  - 候補：FileWatching.jl内のpoll_file実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 基本API、Pidfileの記述は正確
- 0: 低リスク -- LockMonitorの構造は正確

## 6) レビュアーチェックリスト（最小）
- [ ] poll_fileの実装詳細を確認
- [ ] libuvのOS固有ファイル監視APIの動作を確認
- [ ] watch_folderの再帰性について確認
