---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：118-Libdl

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **macOSでのRTLD_GLOBALデフォルト追加**：Cランタイム側の確認が必要

## 2) 参照した情報（Evidence一覧）
- E-01: `base/libdl.jl` -- 実装本体（534行を読了）
- E-02: `stdlib/Libdl/src/Libdl.jl` -- stdlib版re-export
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` -- 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dlopen()でccall(:jl_load_dynamic_library)を呼び出す | E-01 (120行目) | ○ |
| C-02 | dlsym()でccall(:jl_dlsym)を呼び出す | E-01 (62行目) | ○ |
| C-03 | dlclose()でccall(:jl_dlclose)を呼び出す | E-01 (168行目) | ○ |
| C-04 | RTLD_*定数が定義されている | E-01 (24-31行目) | ○ |
| C-05 | デフォルトフラグ=RTLD_LAZY\|RTLD_DEEPBIND | E-01 (49行目) | ○ |
| C-06 | find_libraryでDL_LOAD_PATHを先に検索 | E-01 (199-216行目) | ○ |
| C-07 | dlpathでjl_pathname_for_handleを使用 | E-01 (226行目) | ○ |
| C-08 | dlextはプラットフォーム固有（so/dll/dylib） | E-01 (249-256行目) | ○ |
| C-09 | dllistはOS固有API使用 | E-01 (294-318行目) | ○ |
| C-10 | LazyLibrary構造体に@atomic handle | E-01 (445行目) | ○ |
| C-11 | LazyLibraryのdlopenはReentrantLockで排他制御 | E-01 (490-529行目) | ○ |
| C-12 | 依存ライブラリが先にロードされる | E-01 (497-499行目) | ○ |
| C-13 | on_load_callbackはロードスレッドのみで実行 | E-01 (506-508行目) | ○ |
| C-14 | add_dependency!で動的に依存追加 | E-01 (480-484行目) | ○ |
| C-15 | jl_libdl_dlopen_funcグローバルを設定 | E-01 (488行目) | ○ |
| C-16 | macOSではRTLD_GLOBALもデフォルトに含まれる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- macOSでのデフォルトフラグにRTLD_GLOBALが含まれるかどうかはCランタイム側（src/dlload.c）で処理される可能性
  - 候補：src/dlload.c

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- ソースコードの詳細参照により高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] macOSのデフォルトフラグをCランタイム側で確認
- [ ] dlopen(f::Function)のdo構文サポートを確認
