---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-多倍長浮動小数点（BigFloat）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **C-20**: 算術演算・数学関数の網羅的な列挙はmpfr.jlの後半部分（未読）に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `base/mpfr.jl` 124-137行目（BigFloatLayout/オフセット定数）
- E-02: `base/mpfr.jl` 144-172行目（BigFloat構造体定義）
- E-03: `base/mpfr.jl` 66-73行目（MPFRRoundingMode列挙型）
- E-04: `base/mpfr.jl` 112-115行目（ROUNDING_MODE/DEFAULT_PRECISION定数）
- E-05: `base/mpfr.jl` 303-312行目（BigFloat(::BigFloat)コンストラクタ）
- E-06: `base/mpfr.jl` 321-329行目（Clong/Culongコンストラクタ）
- E-07: `base/mpfr.jl` 331-373行目（Float64コンストラクタ）
- E-08: `base/mpfr.jl` 375-379行目（BigIntコンストラクタ）
- E-09: `base/mpfr.jl` 394-399行目（Rationalコンストラクタ）
- E-10: `base/mpfr.jl` 300-301行目（widen定義）
- E-11: `base/mpfr.jl` 183-197行目（getproperty定義）
- E-12: `base/mpfr.jl` 201-212行目（setproperty!定義）
- E-13: `base/mpfr.jl` 245行目（rawbigfloats.jlのinclude）
- E-14: `base/mpfr.jl` 247-256行目（rounding/setrounding定義）
- E-15: `docs/code-to-docs/機能一覧/機能一覧.csv` 13行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BigFloatはMPFRライブラリを基盤とする | E-02, E-06 | ○ |
| C-02 | Memory{Limb}ベースのインライン格納方式 | E-01, E-02 | ○ |
| C-03 | デフォルト精度は256ビット | E-04 (114行目) | ○ |
| C-04 | MPFRRoundingModeで5種の丸めモードを提供 | E-03 | ○ |
| C-05 | ScopedValueによるタスクローカル管理 | E-04 (113, 115行目) | ○ |
| C-06 | getproperty/setproperty!でフィールドアクセスをエミュレート | E-11, E-12 | ○ |
| C-07 | 新規BigFloatはNaNで初期化 | E-02 (167行目) | ○ |
| C-08 | precision < 1でDomainError | E-02 (155行目) | ○ |
| C-09 | Float64変換でprecision > 52の場合は手動ビット設定 | E-07 (335-373行目) | ○ |
| C-10 | BigInt変換はmpfr_set_z | E-08 | ○ |
| C-11 | Rational変換は分子分母個別変換後除算 | E-09 | ○ |
| C-12 | widen(Float64) = BigFloat | E-10 | ○ |
| C-13 | rawbigfloats.jlのinclude | E-13 | ○ |
| C-14 | rounding_rawはScopedValueを優先参照 | E-14 (247行目) | ○ |
| C-15 | BigFloatLayoutでprec/sign/exp/dのオフセット管理 | E-01 | ○ |
| C-16 | mpfr_custom_get_sizeで必要バイト数を計算 | E-02 (156行目) | ○ |
| C-17 | BigFloat(::BigFloat)は精度が同じなら自身を返す | E-05 (304-305行目) | ○ |
| C-18 | signbit(x)でNaN符号を保持 | E-07 (337-339行目) | ○ |
| C-19 | __init__で指数範囲を最大に設定 | E-02の前 (47-56行目) | ○ |
| C-20 | 三角関数・指数関数・対数関数等のMPFR経由実装 | **mpfr.jl後半未読** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: 数学関数の実装はmpfr.jlの400行目以降にあるが、本レポートの検証では200-400行目までを重点的に確認した。算術演算や数学関数の網羅的な列挙はファイル後半部分の読み込みが必要。
  - 候補：`base/mpfr.jl` 400行目以降 / MPFR公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - BigFloat構造体定義とメモリレイアウトはコードから明確
- 1: 中リスク - Float64からの手動ビット設定（331-373行目）は複雑で精度に関わる
- 0: 低リスク - 精度・丸めモード管理は標準的なグローバル/ScopedValueパターン
- 1: 中リスク - unsafe_convert(Ref{BigFloat})のポインタ整合性検証（220-229行目）

## 6) レビュアーチェックリスト（最小）
- [ ] BigFloatのメモリレイアウトがMPFR mpfr_t構造体と正しく対応しているか
- [ ] Float64からの手動ビット設定が精度を正しく保っているか
- [ ] ScopedValueによるタスクローカル精度管理がスレッドセーフか
- [ ] unsafe_convert(Ref{BigFloat})のポインタ更新がデシリアライズ後も正しく機能するか
- [ ] 数学関数（sin, cos, exp, log等）の網羅性を確認
