---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-高速数学演算（FastMath）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/fastmath.jl` 35-93行目（fast_opディクショナリ）
- E-02: `base/fastmath.jl` 95-100行目（rewrite_opディクショナリ）
- E-03: `base/fastmath.jl` 102-133行目（make_fastmath関数）
- E-04: `base/fastmath.jl` 156-158行目（@fastmathマクロ定義）
- E-05: `base/fastmath.jl` 30-32行目（Core.Intrinsicsインポート）
- E-06: `base/fastmath.jl` 163-172行目（FloatTypes向けfast版）
- E-07: `base/fastmath.jl` 180-185行目（比較演算fast版）
- E-08: `base/fastmath.jl` 187-190行目（isinf_fast等の前提）
- E-09: `base/fastmath.jl` 196-241行目（複素数演算fast版）
- E-10: `base/fastmath.jl` 246-291行目（フォールバック・型昇格）
- E-11: `base/fastmath.jl` 294-296行目（exp2_fast等のBase.Math参照）
- E-12: `base/fastmath.jl` 1-25行目（LLVMフラグの説明コメント）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` 14行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fast_opで40以上の関数マッピング | E-01 | ○ |
| C-02 | rewrite_opで5種の複合代入書き換え | E-02 | ○ |
| C-03 | make_fastmathでAST再帰変換 | E-03 | ○ |
| C-04 | 冪乗の整数リテラルをpow_fast+Valに変換 | E-03 (105-110行目) | ○ |
| C-05 | Core.Intrinsicsの*_float_fast関数を使用 | E-05, E-06 | ○ |
| C-06 | FloatTypes=Union{Float16,Float32,Float64} | E-06 (163行目) | ○ |
| C-07 | isinf_fast=false, isnan_fast=false等の前提 | E-08 | ○ |
| C-08 | 複素数演算のfast版を提供 | E-09 | ○ |
| C-09 | 非数値型へのフォールバック | E-10 | ○ |
| C-10 | 型昇格付きの汎用ディスパッチ | E-10 (260-264行目) | ○ |
| C-11 | LLVMのnnan,ninf,nsz,arcp,fastフラグに対応 | E-12 | ○ |
| C-12 | exp2_fast等はBase.Math内の専用実装 | E-11 | ○ |
| C-13 | @fastmathマクロはesc(make_fastmath(esc(expr))) | E-04 | ○ |
| C-14 | :quoteは変換しない | E-03 (103-104行目) | ○ |
| C-15 | ComplexTypes=Union{ComplexF32,ComplexF64} | E-09 (194行目) | ○ |
| C-16 | max_float_fast/min_float_fastのLLVM intrinsics | E-06 (171-172行目) | ○ |
| C-17 | リダクション演算maximum_fast/minimum_fast | E-01 (91-93行目) | ○ |
| C-18 | マクロ展開はコンパイル時に行われる | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - fast_op/rewrite_opの定義は静的で検証容易
- 0: 低リスク - make_fastmathのAST変換は再帰的だが構造は明確
- 1: 中リスク - NaN/Inf前提の安全性はユーザーの責任（ドキュメントで明記済み）

## 6) レビュアーチェックリスト（最小）
- [ ] fast_opの全マッピングが意図通りか（特に比較演算子の方向性）
- [ ] make_fastmathの再帰変換で取りこぼしがないか
- [ ] 複素数演算fast版の数学的正確性
- [ ] フォールバック実装が無限ループを起こさないか（型昇格の収束性）
