---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：134-ハッシュ関数

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **HashDoS 保護に関する記述**：HASH_SECRET が固定値である点のセキュリティ影響

## 2) 参照した情報（Evidence一覧）

- E-01: `base/hashing.jl` -- ハッシュ関数の全実装（638行）
- E-02: `base/hashing.jl:3` -- HASH_SEED 定数
- E-03: `base/hashing.jl:4-9` -- HASH_SECRET タプル
- E-04: `base/hashing.jl:40` -- `hash(data::Any) = hash(data, HASH_SEED)`
- E-05: `base/hashing.jl:48-61` -- mul_parts / hash_mix / hash_mix_linear / hash_finalizer
- E-06: `base/hashing.jl:75-77` -- UInt64 / Int64 / 小型整数のハッシュ
- E-07: `base/hashing.jl:164-196` -- 浮動小数点ハッシュ
- E-08: `base/hashing.jl:200-245` -- Real 型の汎用ハッシュ
- E-09: `base/hashing.jl:288-361` -- hash_bytes ポインタベース版
- E-10: `base/hashing.jl:384-458` -- hash_bytes 配列ベース版
- E-11: `base/hashing.jl:494-632` -- hash_bytes イテレータベース版
- E-12: `base/hashing.jl:634-638` -- 文字列ハッシュ
- E-13: `base/hashing.jl:44` -- _jl_type_hash
- E-14: `base/hashing.jl:282` -- Symbol のハッシュ（objectid）
- E-15: `base/hashing.jl:46` -- フォールバックハッシュ（objectid）
- E-16: `base/hashing.jl:147-159` -- hash_integer / _hash_integer
- E-17: `base/hashing.jl:11-38` -- hash 関数の docstring（不変条件の記述）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | hash(data) は HASH_SEED をデフォルトシードとして使用 | E-04 | ○ |
| C-02 | HASH_SEED は UInt64/UInt32 で異なる値 | E-02 | ○ |
| C-03 | HASH_SECRET は4つの UInt64 定数タプル | E-03 | ○ |
| C-04 | hash_mix は widemul の上下ビットのXOR | E-05 | ○ |
| C-05 | hash_mix_linear は 3h - x | E-05 | ○ |
| C-06 | UInt64 のハッシュは hash_uint64(hash_mix_linear(x, h)) | E-06 | ○ |
| C-07 | 小型整数は Int64 に拡張してハッシュ | E-06 | ○ |
| C-08 | Float64 で整数等価な場合は整数ハッシュに委譲 | E-07 | ○ |
| C-09 | NaN は専用ハッシュ値 hx_NaN を使用 | E-07 | ○ |
| C-10 | Real 型は decompose で分解してハッシュ | E-08 | ○ |
| C-11 | String は hash_bytes をポインタベースで呼び出す | E-12 | ○ |
| C-12 | Symbol のハッシュは直接 objectid | E-14 | ○ |
| C-13 | Type のハッシュは ccall(:jl_type_hash) を使用 | E-13 | ○ |
| C-14 | フォールバックは objectid ベース | E-15 | ○ |
| C-15 | isequal(x,y) => hash(x) == hash(y) の不変条件 | E-17 | ○ |
| C-16 | rapidhash アルゴリズムをベースにしている | E-09 (294行目コメント) | ○ |
| C-17 | hash_bytes は3つのオーバーロード（ptr/arr/iter） | E-09, E-10, E-11 | ○ |
| C-18 | HashDoS に対する保護は HASH_SECRET の固定値に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: HASH_SECRET がプロセス間で異なるかどうかの明確な根拠がない。ソースコードでは固定値として定義されているが、ランタイム初期化での変更があるかは確認できていない。
  - 候補：Julia ランタイム初期化コード（src/init.c） / セキュリティドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 機能仕様はソースコードから確認可能
- 1: 中リスク -- セキュリティ関連の記述（HashDoS保護）は追加確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] 浮動小数点ハッシュの数値等価性保証が正しく記述されているか
- [ ] rapidhash の3つのオーバーロードの使い分けが正確か
- [ ] hash_mix / hash_mix_linear / hash_finalizer の計算式が正確か
- [ ] HASH_SECRET / HASH_SEED のプロセス間安定性に関する記述を確認
