---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：135-深いコピー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠が存在する。

## 2) 参照した情報（Evidence一覧）

- E-01: `base/deepcopy.jl` -- deepcopy の全実装（183行）
- E-02: `base/deepcopy.jl:32-35` -- deepcopy 関数（エントリーポイント）
- E-03: `base/deepcopy.jl:33` -- isbitstype 高速パス
- E-04: `base/deepcopy.jl:37-38` -- 不変型の即時返却
- E-05: `base/deepcopy.jl:41` -- Module のエラー
- E-06: `base/deepcopy.jl:39-40` -- Tuple の再帰コピー
- E-07: `base/deepcopy.jl:52-59` -- String のバイトコピー
- E-08: `base/deepcopy.jl:61-98` -- 汎用 deepcopy_internal（mutable/immutable分岐）
- E-09: `base/deepcopy.jl:68` -- jl_new_struct_uninit
- E-10: `base/deepcopy.jl:76` -- jl_set_nth_field
- E-11: `base/deepcopy.jl:95` -- jl_new_structv
- E-12: `base/deepcopy.jl:100-127` -- Memory のコピー
- E-13: `base/deepcopy.jl:128-146` -- Array / MemoryRef のコピー
- E-14: `base/deepcopy.jl:149-164` -- Dict/IdDict のコピー
- E-15: `base/deepcopy.jl:166-182` -- Lock / Condition のコピー
- E-16: `base/deepcopy.jl:8-31` -- deepcopy の docstring
- E-17: `docs/code-to-docs/機能一覧/機能一覧.csv:136行目` -- 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isbitstype は即座にコピー不要で返す | E-03 | ○ |
| C-02 | IdDict で循環参照を追跡する | E-08 (65行目, 69行目) | ○ |
| C-03 | Symbol等の不変型はそのまま返す | E-04 | ○ |
| C-04 | Module の deepcopy はエラー | E-05 | ○ |
| C-05 | Tuple は各要素を再帰コピー | E-06 | ○ |
| C-06 | String は unsafe_string でバイトコピー | E-07 | ○ |
| C-07 | ミュータブル構造体は jl_new_struct_uninit + フィールドコピー | E-09, E-10 | ○ |
| C-08 | イミュータブル構造体は jl_new_structv で新規構築 | E-11 | ○ |
| C-09 | Memory の isbitstype 要素は copy で高速コピー | E-12 (109行目) | ○ |
| C-10 | Memory の非isbits要素は要素ごとに再帰コピー | E-12 (111-127行目) | ○ |
| C-11 | Array は undef 配列 + ref/size コピー | E-13 | ○ |
| C-12 | Dict は isbitstype(eltype) なら copy | E-14 (154-155行目) | ○ |
| C-13 | Dict の非isbits要素はキー・値ごとに再帰コピー | E-14 (160-162行目) | ○ |
| C-14 | Lock は新しいインスタンスとして再初期化 | E-15 (170行目) | ○ |
| C-15 | Condition は lock を再帰コピーして再構築 | E-15 (179行目) | ○ |
| C-16 | deepcopy は serialize/deserialize と概念的に等価 | E-16 (docstring) | ○ |
| C-17 | deepcopy の使用は非推奨（カスタム copy 推奨） | E-16 (docstring warning) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ミュータブル/イミュータブル構造体の処理フローが正しいか
- [ ] Array の deepcopy で ref と size の両方がコピーされているか
- [ ] Lock/Condition の再初期化が安全であるか
