---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：138-依存関係管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **common.mk / bb-install.mk の詳細**：staged-install / bb-install マクロの定義は直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `deps/Makefile` -- 依存ライブラリビルドの統括（先頭80行確認）
- E-02: `deps/gmp.mk` -- GMP ビルドルール（93行、全文確認）
- E-03: `deps/Makefile:1-14` -- ディレクトリ変数とインクルード
- E-04: `deps/Makefile:18-27` -- コメントによるターゲット構造の説明
- E-05: `deps/Makefile:34-80` -- DEP_LIBS リスト構築
- E-06: `deps/gmp.mk:26-33` -- ダウンロード・展開ルール
- E-07: `deps/gmp.mk:38-49` -- パッチ適用ルール
- E-08: `deps/gmp.mk:51-65` -- configure / compile / check ルール
- E-09: `deps/gmp.mk:67-71` -- staged-install マクロ呼び出し
- E-10: `deps/gmp.mk:89-93` -- bb-install マクロ（USE_BINARYBUILDER時）
- E-11: `deps/gmp.mk:61-64` -- ネイティブビルド時のみテスト
- E-12: `deps/gmp.mk:73-80` -- clean / distclean ルール
- E-13: `deps/` ディレクトリ一覧 -- .mk / .version ファイルの存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 各ライブラリに {lib}.mk と {lib}.version が対になる | E-13 | ○ |
| C-02 | get/extract/configure/compile/check/install パターン | E-04, E-06, E-07, E-08 | ○ |
| C-03 | BinaryBuilder のプリビルトバイナリがデフォルト | E-10 | ○ |
| C-04 | JLDOWNLOAD でダウンロード | E-06 | ○ |
| C-05 | JLCHECKSUM でチェックサム検証 | E-06 | ○ |
| C-06 | パッチは patch -p1 で適用 | E-07 | ○ |
| C-07 | テストはネイティブビルド時のみ実行 | E-11 | ○ |
| C-08 | staged-install マクロでインストール | E-09 | ○ |
| C-09 | bb-install マクロで BB インストール | E-10 | ○ |
| C-10 | DEP_LIBS リストが条件付きで構築される | E-05 | ○ |
| C-11 | clean / distclean ルールが存在する | E-12 | ○ |
| C-12 | deps/srccache/ にソースがキャッシュされる | E-03 (4行目) | ○ |
| C-13 | tools/common.mk と tools/bb-install.mk が include される | E-03 (12-14行目) | ○ |
| C-14 | staged-install マクロの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: `deps/tools/common.mk` の staged-install マクロの定義内容は直接確認していない
  - 候補：`deps/tools/common.mk` ファイルの読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- GMP のビルドルールを例として全パターンを確認済み
- 1: 中リスク -- staged-install / bb-install マクロの内部実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] 全依存ライブラリの .mk ファイルが網羅されているか
- [ ] staged-install マクロの動作が正しく記述されているか
- [ ] BinaryBuilder 使用時の動作フローが正確か
