---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：139-テストスイート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **テスト並列実行の詳細**：runtests.jl の後半部分（100行目以降）は直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `test/runtests.jl` -- テスト実行エントリーポイント（先頭100行確認）
- E-02: `test/choosetests.jl` -- テスト選択ロジック（先頭100行確認）
- E-03: `test/choosetests.jl:8-35` -- TESTNAMES リスト
- E-04: `test/choosetests.jl:37-48` -- INTERNET_REQUIRED_LIST / NETWORK_REQUIRED_LIST
- E-05: `test/choosetests.jl:50-54` -- TOP_LEVEL_PKGS
- E-06: `test/choosetests.jl:56-79` -- test_path 関数
- E-07: `test/runtests.jl:17` -- choosetests(ARGS) 呼び出し
- E-08: `test/runtests.jl:20-27` -- running_under_rr() 関数
- E-09: `test/runtests.jl:32-49` -- Revise 統合セットアップ
- E-10: `test/runtests.jl:70-77` -- move_to_node1 関数
- E-11: `test/runtests.jl:80-91` -- node1 テストの移動
- E-12: `test/runtests.jl:95-99` -- 長時間テストの先頭配置
- E-13: `test/runtests.jl:56-61` -- JULIA_TEST_MAXRSS_MB 処理
- E-14: `AGENTS.md` -- テスト実行手順の記述

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TESTNAMES に全コアテスト名が定義 | E-03 | ○ |
| C-02 | INTERNET_REQUIRED_LIST にネットワーク依存テストが定義 | E-04 | ○ |
| C-03 | test_path でテスト名からファイルパスを解決 | E-06 | ○ |
| C-04 | choosetests(ARGS) がテスト選択を行う | E-07 | ○ |
| C-05 | ccall/precompile/SharedArrays/threads/gc/stress がnode1に移動 | E-10, E-11 | ○ |
| C-06 | LinearAlgebra/Pkg が先頭に移動 | E-12 | ○ |
| C-07 | Revise 統合がサポートされている | E-09 | ○ |
| C-08 | running_under_rr() で rr 環境を検出 | E-08 | ○ |
| C-09 | JULIA_TEST_MAXRSS_MB でメモリ制限可能 | E-13 | ○ |
| C-10 | STDLIBS は実行時に動的生成 | E-02 (6行目) | ○ |
| C-11 | TOP_LEVEL_PKGS に Compiler/JuliaSyntax/JuliaLowering | E-05 | ○ |
| C-12 | JuliaSyntax / JuliaLowering のテストは runtests_vendored を使用 | E-06 (72-76行目) | ○ |
| C-13 | テストファイル存在確認が行われる | E-01 (64-68行目) | ○ |
| C-14 | Distributed モジュールで並列テスト実行 | E-01 (4行目, using Distributed) | ○ |
| C-15 | addprocs によるワーカー管理の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: runtests.jl の100行目以降にある addprocs / ワーカー管理の詳細実装は確認していない
  - 候補：`test/runtests.jl` の後半部分

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- テスト選択ロジックとnode1テスト分離は確認済み
- 1: 中リスク -- テスト並列実行エンジンの詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] TESTNAMES リストが最新か
- [ ] node1 テストの選択基準が正しいか
- [ ] Revise 統合の動作フローが正確か
- [ ] 並列テスト実行のワーカー管理を確認
