---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：14-組み合わせ数学

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **C-20**: powermod(Int64版)の実装場所の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `base/combinatorics.jl` 5-19行目（階乗テーブル定義）
- E-02: `base/combinatorics.jl` 21-41行目（factorial実装）
- E-03: `base/combinatorics.jl` 76-101行目（isperm実装）
- E-04: `base/combinatorics.jl` 286-316行目（invperm実装）
- E-05: `base/combinatorics.jl` 214行目（permute!実装）
- E-06: `base/combinatorics.jl` 243行目（invpermute!実装）
- E-07: `base/combinatorics.jl` 337-373行目（nextprod実装）
- E-08: `base/intfuncs.jl` 44-51行目（gcd汎用版）
- E-09: `base/intfuncs.jl` 53-64行目（gcd BitInteger版）
- E-10: `base/intfuncs.jl` 80-95行目（_gcd二進GCD）
- E-11: `base/intfuncs.jl` 136-144行目（lcm）
- E-12: `base/intfuncs.jl` 232-257行目（gcdx）
- E-13: `base/intfuncs.jl` 286行目以降（invmod）
- E-14: `base/gmp.jl` 715行目（BigInt factorial）
- E-15: `base/gmp.jl` 717-726行目（BigInt binomial）
- E-16: `base/gmp.jl` 667-672行目（BigInt powermod）
- E-17: `docs/code-to-docs/機能一覧/機能一覧.csv` 15行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 階乗テーブル: Int64で20!, Int128で34! | E-01, E-02 | ○ |
| C-02 | factorial_lookupでgetfield(table, idx) | E-02 (28行目) | ○ |
| C-03 | 二進GCD（Stein's algorithm）使用 | E-10 | ○ |
| C-04 | _gcdに@assume_effects :terminates_locally | E-10 (80行目) | ○ |
| C-05 | Int64で約1.7x高速 | E-10 (77行目コメント) | ○ |
| C-06 | lcmはgcdベース、checked_abs/checked_mul使用 | E-11 | ○ |
| C-07 | lcm(0, x) = 0 | E-11 (139-140行目) | ○ |
| C-08 | gcdxでベズー係数を計算 | E-12 | ○ |
| C-09 | gcdxのループ不変条件: s0*a0+t0*b0==a | E-12 (244行目コメント) | ○ |
| C-10 | gcd(typemin(T), typemin(T))でOverflowError | E-09 (57-58行目) | ○ |
| C-11 | ispermは1-basedインデックスのboolベクトルで検証 | E-03 | ○ |
| C-12 | invpermは逆置換を計算 | E-04 | ○ |
| C-13 | permute!(v, p) = v .= v[p] | E-05 | ○ |
| C-14 | nextprodはDSPで使用 | E-07 (318行目コメント) | ○ |
| C-15 | BigInt factorialはMPZ.fac_ui | E-14 | ○ |
| C-16 | BigInt binomialはMPZ.bin_ui | E-15 | ○ |
| C-17 | BigInt powermodはMPZ.powm | E-16 | ○ |
| C-18 | gcd/lcmはRational型もサポート | E-08 (gcd汎用版), E-11 | ○ |
| C-19 | gcdxは3引数以上サポート（Julia 1.12） | E-12以降 (261-271行目) | ○ |
| C-20 | powermod(Int64版)の実装 | **intfuncs.jl後半未読** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: powermodのInt64向け実装はintfuncs.jlの300行目以降にあると推測されるが、本レポートでは200行目までを重点的に確認した。
  - 候補：`base/intfuncs.jl` 300行目以降

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 階乗テーブルは事前計算で検証容易
- 0: 低リスク - 二進GCDは標準的アルゴリズム
- 1: 中リスク - typemin(Signed)の取り扱い（gcd/gcdx）
- 0: 低リスク - 順列操作は標準的なアルゴリズム

## 6) レビュアーチェックリスト（最小）
- [ ] 階乗テーブルの値が正しいか（_fact_table64, _fact_table128）
- [ ] 二進GCDがtypemin(Signed)を正しく処理するか
- [ ] gcdxのベズー係数がu*a+v*b=gcd(a,b)を正しく満たすか
- [ ] invmodの符号調整が正しいか
- [ ] permute!/invpermute!がin-placeで正しく動作するか
