---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：140-GMP_jll

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠が存在する。

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/GMP_jll/src/GMP_jll.jl` -- GMP_jll モジュール全体（70行）
- E-02: `stdlib/GMP_jll/Project.toml` -- パッケージメタデータ
- E-03: `stdlib/GMP_jll/src/GMP_jll.jl:4` -- baremodule GMP_jll
- E-04: `stdlib/GMP_jll/src/GMP_jll.jl:5-8` -- using Base, Libdl, CSL_jll（条件付き）
- E-05: `stdlib/GMP_jll/src/GMP_jll.jl:10` -- export libgmp, libgmpxx
- E-06: `stdlib/GMP_jll/src/GMP_jll.jl:20-28` -- libgmp LazyLibrary 定義
- E-07: `stdlib/GMP_jll/src/GMP_jll.jl:31-46` -- libgmpxx LazyLibrary 定義（依存設定含む）
- E-08: `stdlib/GMP_jll/src/GMP_jll.jl:39-45` -- プラットフォーム別の依存ライブラリ
- E-09: `stdlib/GMP_jll/src/GMP_jll.jl:48-54` -- eager_mode() 関数
- E-10: `stdlib/GMP_jll/src/GMP_jll.jl:55` -- is_available() = true
- E-11: `stdlib/GMP_jll/src/GMP_jll.jl:57-63` -- __init__() 関数
- E-12: `stdlib/GMP_jll/src/GMP_jll.jl:65-68` -- precompile 宣言
- E-13: `stdlib/GMP_jll/Project.toml:3` -- version = "6.3.0+2"
- E-14: `stdlib/GMP_jll/Project.toml:5-8` -- 依存パッケージ
- E-15: `deps/gmp.mk` -- GMP ソースビルドルール
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv:141行目` -- 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | baremodule で定義されている | E-03 | ○ |
| C-02 | macOS では CSL_jll を使用しない | E-04 (6行目) | ○ |
| C-03 | libgmp / libgmpxx がエクスポートされる | E-05 | ○ |
| C-04 | Windows: libgmp-10.dll | E-06 (22行目) | ○ |
| C-05 | macOS: libgmp.10.dylib | E-06 (24行目) | ○ |
| C-06 | Linux: libgmp.so.10 | E-06 (26行目) | ○ |
| C-07 | libgmpxx は libgmp に依存 | E-07 | ○ |
| C-08 | FreeBSD では libgmp と libgcc_s のみ依存 | E-08 (39-40行目) | ○ |
| C-09 | macOS では libgmpxx は libgmp のみ依存 | E-08 (41-42行目) | ○ |
| C-10 | 非macOS/非FreeBSD では libstdcxx と libgcc_s にも依存 | E-08 (43-44行目) | ○ |
| C-11 | eager_mode で CSL_jll.eager_mode + dlopen | E-09 | ○ |
| C-12 | is_available() は常に true | E-10 | ○ |
| C-13 | __init__ で libgmp_path / libgmpxx_path / artifact_dir を設定 | E-11 | ○ |
| C-14 | precompile で eager_mode と is_available が事前コンパイル | E-12 | ○ |
| C-15 | バージョンは 6.3.0+2 | E-13 | ○ |
| C-16 | 依存パッケージは Artifacts / CSL_jll / Libdl | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。GMP_jll は小規模なモジュールであり、全体を確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全主張がソースコードから直接確認可能。モジュール全体（70行）を確認済み。

## 6) レビュアーチェックリスト（最小）
- [ ] プラットフォーム別のライブラリファイル名が正しいか
- [ ] 依存ライブラリのプラットフォーム別分岐が正確か
- [ ] __init__ でのパス設定が正しいか
