---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：147-LibGit2_jll

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **macOS/WindowsのOS標準SSL使用**：コードからOpenSSL非依存は確認できるが、代替手段は推測
  2. **Pkg.jlがlibgit2を使用**：一般的知識に基づく
  3. **依存チェーンの完全性**：プラットフォーム別の依存条件が正しいか

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/LibGit2_jll/src/LibGit2_jll.jl` - メインモジュールソースコード
- E-02: `stdlib/LibGit2_jll/Project.toml` - パッケージメタデータ
- E-03: `base/libdl.jl` - LazyLibrary定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LibGit2_jllはlibgit2のJLLバイナリラッパー | E-01 (3行目コメント), E-04 | ○ |
| C-02 | バージョンは1.9.2+0 | E-02 (3行目) | ○ |
| C-03 | LibSSH2_jll, PCRE2_jll, Zlib_jllに依存 | E-01 (6行目), E-02 | ○ |
| C-04 | Windows/macOS以外でOpenSSL_jll使用 | E-01 (7-9行目) | ○ |
| C-05 | Windows 32bitでCompilerSupportLibraries_jll使用 | E-01 (10-12行目) | ○ |
| C-06 | Windows: libgit2.dll | E-01 (26行目) | ○ |
| C-07 | macOS: libgit2.1.9.dylib | E-01 (28行目) | ○ |
| C-08 | Linux/FreeBSD: libgit2.so.1.9 | E-01 (30行目) | ○ |
| C-09 | Windows 32bitの依存にlibgcc_s追加 | E-01 (36行目) | ○ |
| C-10 | Linux/FreeBSD依存にlibssl, libcrypto追加 | E-01 (41行目) | ○ |
| C-11 | eager_mode()でLibSSH2_jll.eager_mode()を呼び出す | E-01 (48行目) | ○ |
| C-12 | プリコンパイル対応 | E-01 (66-69行目) | ○ |
| C-13 | is_available()は常にtrueを返す | E-01 (57行目) | ○ |
| C-14 | macOS/WindowsではOS標準SSL実装を使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: macOS（SecureTransport）/Windows（WinHTTP/Schannel）でのOS標準SSL使用はlibgit2のビルド設定に依存し、このソースコードからは確認不可
  - 候補：deps/patches/libgit2/ のビルド設定 / libgit2公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JLLラッパーの基本構造は定型的
- 1: 中リスク - 依存チェーンが深い（LibGit2 -> LibSSH2 -> OpenSSL）
- 0: 低リスク - プラットフォーム別分岐は明確

## 6) レビュアーチェックリスト（最小）
- [ ] macOS/WindowsでのSSL/TLS実装方式の確認
- [ ] libgit2バージョンのSOバージョン（1.9）が正しいか
- [ ] PCRE2依存の理由確認（libgit2がPCRE2を使用する場面）
- [ ] 依存ライブラリのロード順序が正しいか
