---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：148-LibSSH2_jll

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **WindowsでのWinCNG暗号化**：コードからOpenSSL非依存は確認できるが、代替手段は推測
  2. **プラットフォーム別依存の差異理由**：依存の違いは確認済みだが理由は推測
  3. **Linux/FreeBSD間のZlib依存差異**：コードからは確認済みだが理由は不明

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/LibSSH2_jll/src/LibSSH2_jll.jl` - メインモジュールソースコード
- E-02: `stdlib/LibSSH2_jll/Project.toml` - パッケージメタデータ
- E-03: `base/libdl.jl` - LazyLibrary定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LibSSH2_jllはlibssh2のJLLバイナリラッパー | E-01 (3行目コメント), E-04 | ○ |
| C-02 | バージョンは1.11.3+1 | E-02 (3行目) | ○ |
| C-03 | FreeBSD/macOSでZlib_jll使用 | E-01 (7-9行目) | ○ |
| C-04 | 非WindowsでOpenSSL_jll使用 | E-01 (13-15行目) | ○ |
| C-05 | Windows 32bitでCompilerSupportLibraries_jll使用 | E-01 (10-12行目) | ○ |
| C-06 | Windows: libssh2.dll | E-01 (29行目) | ○ |
| C-07 | macOS: libssh2.1.dylib | E-01 (31行目) | ○ |
| C-08 | Linux/FreeBSD: libssh2.so.1 | E-01 (33行目) | ○ |
| C-09 | Windows 64bit依存は空配列 | E-01 (41行目) | ○ |
| C-10 | Windows 32bit依存にlibgcc_s | E-01 (39行目) | ○ |
| C-11 | Linux依存にlibcryptoのみ | E-01 (44行目) | ○ |
| C-12 | FreeBSD/macOS依存にlibz+libcrypto | E-01 (46行目) | ○ |
| C-13 | プリコンパイル対応 | E-01 (71-74行目) | ○ |
| C-14 | WindowsではOS標準暗号化ライブラリ（WinCNG）を使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: WindowsでOpenSSLを使わないことはコードから確認できるが、代替としてWinCNG（Windows Cryptography API: Next Generation）を使うかどうかはlibssh2のビルド設定に依存
  - 候補：deps/patches/libssh2/ のビルド設定 / libssh2公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JLLラッパーの基本構造は定型的
- 1: 中リスク - プラットフォーム間での依存差異が大きい（4パターン）
- 0: 低リスク - コードが76行と比較的短い

## 6) レビュアーチェックリスト（最小）
- [ ] WindowsでのSSH暗号化実装方式の確認
- [ ] Linux/FreeBSD間でZlib依存の差異がある理由の確認
- [ ] LibGit2_jllとLibCURL_jllの両方から正しく依存されているか
- [ ] Windows 64bitで依存が空配列であることの妥当性確認
