---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：149-OpenSSL_jll

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **OpenSSL 3.5.5のセキュリティ修正内容**：バージョン番号は確認済みだが最新性は外部情報必要
  2. **BinaryPlatformsのarch()関数動作**：コードからは使用を確認、動作詳細は未確認
  3. **被依存関係の網羅性**：主要なものは確認済みだが全体は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/OpenSSL_jll/src/OpenSSL_jll.jl` - メインモジュールソースコード
- E-02: `stdlib/OpenSSL_jll/Project.toml` - パッケージメタデータ
- E-03: `base/libdl.jl` - LazyLibrary定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `stdlib/LibCURL_jll/src/LibCURL_jll.jl` - 被依存確認
- E-06: `stdlib/LibSSH2_jll/src/LibSSH2_jll.jl` - 被依存確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenSSL_jllはOpenSSLのJLLバイナリラッパー | E-01 (3行目コメント), E-04 | ○ |
| C-02 | バージョンは3.5.5+0 | E-02 (3行目) | ○ |
| C-03 | libcryptoとlibsslの2つをエクスポート | E-01 (8行目) | ○ |
| C-04 | Base.BinaryPlatformsを使用 | E-01 (6行目) | ○ |
| C-05 | Windows x86_64でlibcrypto-3-x64.dll | E-01 (21行目) | ○ |
| C-06 | Windows非x86_64でlibcrypto-3.dll | E-01 (23行目) | ○ |
| C-07 | macOS: libcrypto.3.dylib / libssl.3.dylib | E-01 (26行目, 43行目) | ○ |
| C-08 | Linux/FreeBSD: libcrypto.so.3 / libssl.so.3 | E-01 (28行目, 45行目) | ○ |
| C-09 | libsslはlibcryptoに依存 | E-01 (49行目) | ○ |
| C-10 | eager_mode()でlibcrypto->libsslの順にdlopen | E-01 (53-54行目) | ○ |
| C-11 | LibCURL_jllから依存される | E-05 (8行目, 41行目) | ○ |
| C-12 | LibSSH2_jllから依存される | E-06 (14行目, 44-46行目) | ○ |
| C-13 | プリコンパイル対応 | E-01 (66-69行目) | ○ |
| C-14 | is_available()は常にtrueを返す | E-01 (56行目) | ○ |
| C-15 | OpenSSL 3.5.5が最新セキュリティ修正を含む | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: OpenSSL 3.5.5の具体的なセキュリティ修正内容は外部のOpenSSLリリースノートを確認する必要がある
  - 候補：OpenSSL公式リリースノート / CVEデータベース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JLLラッパーの基本構造は定型的
- 1: 中リスク - Windows x86_64固有のDLL命名規則は他のJLLに見られない特殊パターン
- 1: 中リスク - セキュリティクリティカルなライブラリのためバージョン管理が重要

## 6) レビュアーチェックリスト（最小）
- [ ] Windows x86_64のDLL名（-x64サフィックス）が実際のビルド成果物と一致するか
- [ ] OpenSSL 3.5.5が最新の安定版であるか
- [ ] libcrypto -> libsslの依存順序が正しいか
- [ ] BinaryPlatforms.arch()がWindows環境で正しくアーキテクチャを返すか
