---
generated_at: 2026-02-04 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-SubArray（ビュー）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/subarray.jl` 8-24行目（SubArray構造体定義）
- E-02: `base/subarray.jl` 26-39行目（SubArrayコンストラクタ）
- E-03: `base/subarray.jl` 41-44行目（check_parent_index_match）
- E-04: `base/subarray.jl` 47-62行目（viewindexing関数群）
- E-05: `base/subarray.jl` 65行目（size定義）
- E-06: `base/subarray.jl` 73-79行目（copy定義）
- E-07: `base/subarray.jl` 81-82行目（parent/parentindices）
- E-08: `base/views.jl` 210-228行目（@viewマクロ）
- E-09: `base/views.jl` 332-334行目（@viewsマクロ）
- E-10: `base/views.jl` 235-239行目（maybeview関数）
- E-11: `base/views.jl` 248-294行目（_views関数）
- E-12: `base/views.jl` 17-160行目（replace_ref_begin_end!）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` 18行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SubArray{T,N,P,I,L}はparent/indices/offset1/stride1を持つ | E-01 | ○ |
| C-02 | viewindexingでIndexLinear/IndexCartesian判定 | E-04 | ○ |
| C-03 | L==trueでリニアインデックス有効 | E-02 (34-38行目) | ○ |
| C-04 | check_parent_index_matchで次元数検証 | E-03 | ○ |
| C-05 | @viewマクロはref式をview呼び出しに変換 | E-08 | ○ |
| C-06 | @viewsマクロは全ref式をmaybeviewに変換 | E-09, E-11 | ○ |
| C-07 | maybeviewはスカラーインデックスでgetindex | E-10 (237行目) | ○ |
| C-08 | maybeviewはスライスでview | E-10 (236行目) | ○ |
| C-09 | replace_ref_begin_end!でbegin/endをfirstindex/lastindexに変換 | E-12 | ○ |
| C-10 | _viewsは代入左辺ではビューを生成しない | E-11 (249-255行目) | ○ |
| C-11 | SubArray.copyは親配列の該当部分コピーを返す | E-06 | ○ |
| C-12 | parent(V)で親配列取得 | E-07 | ○ |
| C-13 | parentindices(V)でインデックス取得 | E-07 | ○ |
| C-14 | 先頭スカラーインデックスはskipしてtail再帰 | E-04 (49行目) | ○ |
| C-15 | 連続Sliceはskipしてtail再帰 | E-04 (51行目) | ○ |
| C-16 | AbstractArrayインデックスはIndexCartesian | E-04 (62行目) | ○ |
| C-17 | @viewsのop=代入で一時変数使用 | E-11 (261-289行目) | ○ |
| C-18 | size(V) = map(length, axes(V)) | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SubArray構造体定義はシンプルで明確
- 0: 低リスク - viewindexingの判定ルールはパターンマッチで検証容易
- 1: 中リスク - replace_ref_begin_end!のAST変換は複雑（再帰的、引用コンテキスト対応）
- 0: 低リスク - @viewsのop=代入処理の正確性

## 6) レビュアーチェックリスト（最小）
- [ ] viewindexingの全パターンが正しくIndexLinear/IndexCartesianを返すか
- [ ] compute_stride1/compute_offset1の計算が正しいか
- [ ] replace_ref_begin_end!がネストしたref式を正しく処理するか
- [ ] @viewsのop=代入で評価順序が保持されているか
