---
generated_at: 2026-02-04 11:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-配列ソート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/sort.jl` 3行目（Sortモジュール定義）
- E-02: `base/sort.jl` 17-44行目（export一覧）
- E-03: `base/sort.jl` 46行目（Algorithm抽象型）
- E-04: `base/sort.jl` 50-97行目（issorted関数）
- E-05: `base/sort.jl` 186-240行目（searchsortedfirst/searchsortedlast/searchsorted二分探索実装）
- E-06: `base/sort.jl` 245-304行目（AbstractRange向けsearchsorted最適化）
- E-07: `base/sort.jl` 557-576行目（SubArrayOptimization）
- E-08: `base/sort.jl` 587-688行目（MissingOptimization, WithoutMissingVector, send_to_end!）
- E-09: `base/sort.jl` 701-742行目（IEEEFloatOptimization）
- E-10: `base/sort.jl` 744-770行目（BoolOptimization）
- E-11: `base/sort.jl` 791-804行目（Small構造体）
- E-12: `base/sort.jl` 807-854行目（InsertionSortAlg, InsertionSort, _sort!実装）
- E-13: `base/sort.jl` 863-881行目（CheckSorted）
- E-14: `base/sort.jl` 892-918行目（ComputeExtrema）
- E-15: `base/sort.jl` 920-978行目（ConsiderCountingSort, CountingSort）
- E-16: `base/sort.jl` 980-1050行目（ConsiderRadixSort, RadixSort）
- E-17: `base/sort.jl` 1076-1170行目（ScratchQuickSort構造体, partition!, _sort!）
- E-18: `base/sort.jl` 1475-1480行目（InitialOptimizations構築関数）
- E-19: `base/sort.jl` 1550-1597行目（DefaultStable, DefaultUnstable, _DEFAULT_ALGORITHMS_FOR_VECTORS, SMALL_THRESHOLD）
- E-20: `base/sort.jl` 1622-1626行目（defalg関数）
- E-21: `base/sort.jl` 1734-1743行目（sort!関数）
- E-22: `base/sort.jl` 1782行目（sort関数）
- E-23: `base/sort.jl` 1787-1810行目（NTupleソート、_mergesort）
- E-24: `base/sort.jl` 1968-1996行目（sortperm関数）
- E-25: `base/sort.jl` 2189-2220行目（sort!多次元配列版）
- E-26: `base/sort.jl` 2320-2401行目（後方互換: QuickSort, MergeSort, PartialQuickSort）
- E-27: `base/sort.jl` 1090-1121行目（partition!関数、ハッシュベースピボット）
- E-28: `docs/code-to-docs/機能一覧/機能一覧.csv` 21行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Algorithm抽象型がソートアルゴリズムの基底 | E-03 | ○ |
| C-02 | sort, sort!, sortperm, issorted, searchsorted等をexport | E-02 | ○ |
| C-03 | InsertionSort, QuickSort, MergeSort, PartialQuickSortをexport | E-02 | ○ |
| C-04 | defalg: Number/MissingはDEFAULT_UNSTABLE、その他はDEFAULT_STABLE | E-20 | ○ |
| C-05 | InitialOptimizations: SubArray→Missing→Bool→Small{10}→IEEEFloat | E-18 | ○ |
| C-06 | _DEFAULT_ALGORITHMS_FOR_VECTORS: IsUIntMappable分岐 | E-19 (1582-1592行目) | ○ |
| C-07 | InsertionSort._sort!: シンプルな挿入ソート実装 | E-12 (837-854行目) | ○ |
| C-08 | ScratchQuickSort: スクラッチスペース使用のクイックソート | E-17 | ○ |
| C-09 | partition!: mod(hash(lo), lo:hi)でピボット選択 | E-27 (1094行目) | ○ |
| C-10 | CountingSort: 値域が配列長の半分未満で適用 | E-15 (925-946行目) | ○ |
| C-11 | RadixSort: UIntマッピング可能な場合の基数ソート | E-16 | ○ |
| C-12 | CheckSorted: 500要素以上で逆順検出+reverse! | E-13 (874行目) | ○ |
| C-13 | BoolOptimization: Bool配列のカウントベースO(n)ソート | E-10 | ○ |
| C-14 | MissingOptimization: Missing値をDirectOrderingで末尾に移動 | E-08 | ○ |
| C-15 | IEEEFloatOptimization: NaN末尾移動+符号分割+UInt変換 | E-09 | ○ |
| C-16 | SMALL_THRESHOLD = 20 | E-19 (1597行目) | ○ |
| C-17 | sort!: defalg→ord→maybe_apply_initial_optimizations→_sort! | E-21 | ○ |
| C-18 | sort: copymutable(v)のコピー→sort! | E-22 | ○ |
| C-19 | sortperm: Perm orderingでインデックスをソート | E-24 | ○ |
| C-20 | searchsorted系: AbstractRangeでO(1)最適化 | E-06 | ○ |
| C-21 | NTuple: 9要素以下はアンロールmergesort | E-23 (1801-1814行目) | ○ |
| C-22 | QuickSort/MergeSortは後方互換で残存、InitialOptimizationsにラップ | E-26 (2398-2401行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開API（sort!, sort, sortperm等）は明確に定義
- 0: 低リスク - InsertionSortの実装はシンプルで検証容易
- 0: 低リスク - 二分探索の実装は標準的
- 1: 中リスク - ScratchQuickSortのpartition!におけるハッシュベースピボット選択の偏り
- 1: 中リスク - RadixSortのチャンクサイズ計算（_radix_sort_chunk_size_heuristic）の最適性

## 6) レビュアーチェックリスト（最小）
- [ ] defalg の選択が適切なアルゴリズムを返すか
- [ ] InitialOptimizationsの各パスが正しい条件で発火するか
- [ ] ScratchQuickSortのpartition!が安定性を保証するか
- [ ] CountingSort/RadixSortの適用条件が効率的か
- [ ] searchsorted系のAbstractRange最適化が全ケースで正しいか
- [ ] 多次元配列sort!のdims処理が正しいか
