---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-リダクション演算

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18 simdloop.jlの参照**: 関連ファイルとして挙げたが直接コード確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/reduce.jl` 1-150行目 - 基本構造体とfoldl実装
- E-02: `base/reduce.jl` 150-349行目 - mapreduce, reduce, Transducerパターン
- E-03: `base/reduce.jl` 349-498行目 - reduce_empty, reduce_first, _mapreduce, reduce
- E-04: `base/reducedim.jl` 1-150行目 - 次元リダクションの初期化と実装
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 22行目 - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | reduce/mapreduce/foldl/foldrが汎用畳み込み関数として提供される | E-02, E-03 | ○ |
| C-02 | sum/prod/maximum/minimum/any/all等の特化型集約関数が提供される | E-03 | ○ |
| C-03 | dims引数で次元指定リダクションが可能 | E-04 | ○ |
| C-04 | BottomRFは最初の要素をreduce_firstで処理するラッパー | E-01 (79-84行目) | ○ |
| C-05 | MappingRFはマッピング+リダクションの合成 | E-01 (91-98行目) | ○ |
| C-06 | FilteringRFはフィルタリング+リダクションの合成 | E-01 (105-110行目) | ○ |
| C-07 | FlatteningRFはフラット化+リダクションの合成 | E-01 (118-125行目) | ○ |
| C-08 | 空コレクションでinit未指定の場合ArgumentError | E-03 (317行目) | ○ |
| C-09 | add_sumは小整数をInt/UIntに昇格する | E-01 (16-19行目) | ○ |
| C-10 | ペアワイズ分割統治法でブロックサイズ1024 | E-02 (310行目) | ○ |
| C-11 | abs2+の場合ブロックサイズ4096 | E-02 (313行目) | ○ |
| C-12 | 16要素未満の配列はインライン逐次処理 | E-03 (435行目) | ○ |
| C-13 | _xfadjointでGenerator/Filter/FlattenをRF変換に変換 | E-02 (151-164行目) | ○ |
| C-14 | mapreduceは左畳み込みmapfoldlに委譲 | E-02 (305行目) | ○ |
| C-15 | reduceはmapreduce(identity, op, itr)に委譲 | E-03 (489行目) | ○ |
| C-16 | reduced_indexでリダクション後の軸サイズ計算 | E-04 (6-7行目) | ○ |
| C-17 | reducedim_initで次元リダクションの初期配列生成 | E-04 (69-86行目) | ○ |
| C-18 | simdloop.jlで@simdマクロが定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- simdloop.jl のコード確認が未実施
  - 候補：`base/simdloop.jl` を直接読み込んで確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なリダクション処理ロジックは全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] sum/prod/maximum/minimum/any/all/count の公開APIが正確に記述されているか
- [ ] ペアワイズアルゴリズムの説明が正確か
- [ ] 次元リダクションの初期化ロジックが正確に反映されているか
- [ ] Transducerパターンの説明が十分に明確か
