---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-累積演算

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/accumulate.jl` 1-150行目 - ペアワイズ累積、cumsum の定義
- E-02: `base/accumulate.jl` 150-350行目 - cumprod、accumulate、accumulate! の定義
- E-03: `base/reduce.jl` 70-84行目 - BottomRF の定義
- E-04: `base/reduce.jl` 16-30行目 - add_sum, mul_prod の定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 23行目 - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | accumulate/accumulate!が汎用累積関数として提供される | E-02 (234-346行目) | ○ |
| C-02 | cumsum/cumprodが特化型累積関数として提供される | E-01, E-02 | ○ |
| C-03 | dims引数で次元沿い累積が可能 | E-02 (281-294行目) | ○ |
| C-04 | ペアワイズ加算アルゴリズムが128要素で分割 | E-01 (8行目) | ○ |
| C-05 | ArithmeticRounds型の場合ペアワイズ版を使用 | E-01 (59-61行目) | ○ |
| C-06 | 小整数型のcumsumでInt/UIntへ昇格 | E-04, E-01 (117行目) | ○ |
| C-07 | accumulate!でBとAのサイズ不一致はDimensionMismatch | E-01 (27行目) | ○ |
| C-08 | Tuple版accumulateはafoldlで展開 | E-02 (296-303行目) | ○ |
| C-09 | init指定時に最初の要素がop(init, A[1])として計算 | E-02 (296-303行目) | ○ |
| C-10 | 非配列イテレータではIterators.accumulateを使用 | E-02 (284行目) | ○ |
| C-11 | reduce_firstで初回要素を特別処理 | E-01 (31行目), E-03 | ○ |
| C-12 | cumprod(itr)はaccumulate(mul_prod, itr)に委譲 | E-02 (231行目) | ○ |
| C-13 | cumsum(x::AbstractVector)はcumsum(x, dims=1)に委譲 | E-01 (149行目) | ○ |
| C-14 | _accumulate_pairwise!は再帰的に半分に分割 | E-01 (18-20行目) | ○ |
| C-15 | Julia 1.5以降で非配列イテレータ対応 | E-01 (128-129行目 docstring) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ペアワイズ加算の分割閾値（128）が正しいか
- [ ] cumsumの型昇格ルールが正確に記述されているか
- [ ] dims指定時の_accumulate!の挙動が正しく説明されているか
