---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-辞書（Dict）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16 WeakKeyDict のGC連携**: weakkeydict.jl を直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `base/dict.jl` 1-150行目 - Dict 構造体、hashindex、スロット管理
- E-02: `base/dict.jl` 150-350行目 - rehash!, sizehint!, empty!, ht_keyindex, ht_keyindex2_shorthash!, _setindex!
- E-03: `base/iddict.jl` 1-80行目 - IdDict 構造体と基本操作
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 24行目 - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Dict{K,V}はオープンアドレス法のハッシュテーブル | E-01, E-02 | ○ |
| C-02 | スロットメタデータは3状態（0x00, 0x7f, 0x80+） | E-01 (134-136行目) | ○ |
| C-03 | ショートハッシュは上位7ビット | E-01 (122行目) | ○ |
| C-04 | hashindexでハッシュ下位ビットからインデックス計算 | E-01 (127-132行目) | ○ |
| C-05 | 充填率 > 2/3 でリハッシュ | E-02 (337行目) | ○ |
| C-06 | count > 64000 なら2倍、それ以外は4倍リサイズ | E-02 (339行目) | ○ |
| C-07 | isequal/hash ベースの等値比較 | E-01 (35-36行目 docstring) | ○ |
| C-08 | rehash!で全エントリを再配置 | E-02 (138-192行目) | ○ |
| C-09 | h.age による並行書き込み検出 | E-02 (183行目) | ○ |
| C-10 | maxprobe で探査上限を管理 | E-02 (243行目) | ○ |
| C-11 | IdDict は objectid/=== ベース | E-03 (6-8行目 docstring) | ○ |
| C-12 | IdDict の rehash は C ランタイムに委譲 | E-03 (62行目) | ○ |
| C-13 | テーブルサイズは2のべき乗 | E-02 (143行目, _tablesz) | ○ |
| C-14 | delete!でtombstone 0x7f に設定 | E-01 (136行目) | ○ |
| C-15 | Dict 構造体のフィールド一覧が正確 | E-01 (65-89行目) | ○ |
| C-16 | WeakKeyDict はキーがGC回収時にエントリ除去 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- WeakKeyDict の詳細実装確認が未実施
  - 候補：`base/weakkeydict.jl` を直接読み込んで確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Dict の核心的な実装はソースコードで十分確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Dict のスロットメタデータ方式の説明が正確か
- [ ] ハッシュテーブルのリサイズ条件が正確か
- [ ] IdDict と WeakKeyDict の説明が正確か
- [ ] ImmutableDict の連結リスト形式の説明を確認
