---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：28-検索・探索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **C-13 searchsorted の二分探索実装**: sort.jl の詳細を確認していない
  2. **C-14 findall の Bool配列最適化**: array.jl の詳細を確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `base/strings/search.jl` 1-150行目 - 文字列検索の findnext 実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 29行目 - 機能定義（array.jl, sort.jl で定義）
- E-03: Julia 公式ドキュメント（docstring）- searchsorted, findfirst 等の仕様

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | findfirst は findnext に firstindex で委譲 | E-03 (標準パターン) | ○ |
| C-02 | findnext は線形走査で pred チェック | E-03 | ○ |
| C-03 | findall は結果配列に push! しながら全走査 | E-03 | ○ |
| C-04 | 見つからない場合 nothing を返す | E-03 | ○ |
| C-05 | searchsorted はソート済み配列を前提 | E-03 | ○ |
| C-06 | searchsorted は UnitRange を返す | E-03 | ○ |
| C-07 | insorted は searchsorted の結果が空でないか判定 | E-03 | ○ |
| C-08 | 文字列版 findnext は strings/search.jl で実装 | E-01 (146-150行目) | ○ |
| C-09 | FwCharPosIter / RvCharPosIter による文字列検索 | E-01 (48-139行目) | ○ |
| C-10 | memchr ベースの高速バイト検索 | E-01 (73行目, _search) | ○ |
| C-11 | Fix2 パターンによる isequal の最適化 | E-01 (147行目) | ○ |
| C-12 | 線形探索 O(n)、二分探索 O(log n) | E-03 (標準計算量) | ○ |
| C-13 | searchsortedfirst の二分探索実装の詳細 | **根拠なし** | △ |
| C-14 | findall の Bool配列最適化 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- sort.jl の searchsorted 実装詳細が未確認
  - 候補：`base/sort.jl` の searchsorted 関連コードを確認
- array.jl の findall Bool最適化パスが未確認
  - 候補：`base/array.jl` の findall 実装を確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 二分探索の実装詳細が未確認。searchsorted の正確なアルゴリズムは sort.jl で要確認

## 6) レビュアーチェックリスト（最小）
- [ ] searchsorted 系関数の二分探索アルゴリズムが正確に記述されているか
- [ ] findall の Bool配列最適化の有無を確認
- [ ] findfirst/findnext の文字列版が正しく説明されているか
- [ ] Fix2 パターンの説明が正確か
