---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：3-抽象型・Union型

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **C-15**: Union型の部分型判定キャッシュ機構の詳細
  2. **C-16**: Union型が4型以下で効率的という閾値の根拠

## 2) 参照した情報（Evidence一覧）

- E-01: `base/boot.jl` 5-8行目（Any, Type{T}, Varargコメント）
- E-02: `base/boot.jl` 32-35行目（Union構造体定義）
- E-03: `base/boot.jl` 248-253行目（抽象型階層定義）
- E-04: `base/essentials.jl` 7行目（Bottom = Union{}）
- E-05: `base/int.jl` 26-40行目（BitSigned等Union型定義）
- E-06: `base/promotion.jl` 20-141行目（typejoin関数）
- E-07: `base/promotion.jl` 147-158行目（typesplit関数）
- E-08: `base/boot.jl` 365行目（Union{}のコンストラクタエラー）
- E-09: `機能一覧.csv` 3行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Any, Type{T}が最上位の抽象型として定義されている | E-01 | ○ |
| C-02 | Union構造体はa, bフィールドの二分木表現を持つ | E-02 | ○ |
| C-03 | Number > Real > AbstractFloat/Integer > Signed/Unsignedの階層が存在 | E-03 | ○ |
| C-04 | Union{}がBottomとして定義されている | E-04 | ○ |
| C-05 | BitSigned等がUnion型として定義されている | E-05 | ○ |
| C-06 | typejoinが2つの型の最近共通祖先を計算する | E-06 | ○ |
| C-07 | typesplitがUnion型から特定の型を除去する | E-07 | ○ |
| C-08 | Union{}のインスタンス化はArgumentErrorを投げる | E-08 | ○ |
| C-09 | 抽象型はインスタンス化できない | E-03 | ○ |
| C-10 | typejoinがTypeVar, UnionAll, Union, DataTypeを場合分けで処理 | E-06 | ○ |
| C-11 | Union{A, Union{B, C}} が正規化される | E-06 | ○ |
| C-12 | Union{T}はTに等しい | E-04 | ○ |
| C-13 | Bottom（Union{}）はすべての型のサブタイプ | E-04, E-06 | ○ |
| C-14 | 定義はCoreモジュールで行われる | E-09 | ○ |
| C-15 | 部分型判定にキャッシュ機構がある | **根拠なし** | △ |
| C-16 | Union型は4型以下で効率的にディスパッチされる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: src/subtype.cのキャッシュ実装を直接確認していない
  - 候補：src/subtype.c / src/gf.c
- C-16: ディスパッチ効率の閾値はコンパイラの実装詳細に依存し、ドキュメント化されていない可能性がある
  - 候補：Compiler/src/ / Julia公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 抽象型階層の記述はソースコードと整合
- 0: 低リスク - Union型の内部構造はboot.jlコメントと整合
- 1: 中リスク - パフォーマンス特性の記述は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] boot.jlのUnion構造体定義コメントが最新ソースと一致しているか確認
- [ ] typejoin関数の行番号が最新ソースと一致しているか確認
- [ ] Union型のディスパッチ効率に関する記述が正確か確認
