---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：30-文字列検索・置換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16 replace の詳細実装**: replace の IOBuffer パターンは推定に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `base/strings/search.jl` 1-150行目 - AbstractPattern, FwCharPosIter, RvCharPosIter, findnext
- E-02: `base/strings/util.jl` 1-100行目 - startswith, endswith, Chars 型
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 40-41行目, 47行目 - 履歴検索・プレフィックス検索
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 31行目 - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FwCharPosIter は末尾UTF-8バイトを memchr で検索 | E-01 (48-55行目, 65-96行目) | ○ |
| C-02 | RvCharPosIter は逆方向に _rsearch を使用 | E-01 (99-139行目) | ○ |
| C-03 | is_standalone_byte は (x < 0x80) \| (x > 0xf7) | E-01 (42行目) | ○ |
| C-04 | last_utf8_byte で Char の最終UTF-8バイトを取得 | E-01 (34-38行目) | ○ |
| C-05 | 単独バイト文字は memchr で直接確定 | E-01 (71-74行目) | ○ |
| C-06 | マルチバイト文字は memchr + isvalid + 文字確認 | E-01 (76-94行目) | ○ |
| C-07 | findnext(Fix2{isequal,Char}, String, i) が最適化パス | E-01 (146-150行目) | ○ |
| C-08 | startswith(String, String) は _memcmp で高速比較 | E-02 (69-79行目) | ○ |
| C-09 | startswith の汎用版は iterate による文字ごと比較 | E-02 (31-39行目) | ○ |
| C-10 | endswith は Iterators.Reverse を使用 | E-02 (57-67行目) | ○ |
| C-11 | Chars 型は Union{AbstractChar, Tuple, Vector, Set} | E-02 (4-12行目) | ○ |
| C-12 | startswith(IO, prefix) も対応 | E-02 (87-99行目) | ○ |
| C-13 | 履歴検索モードで contains/occursin が使用される | E-03 (40行目) | ○ |
| C-14 | プレフィックス検索モードで startswith が使用される | E-03 (47行目) | ○ |
| C-15 | AbstractPattern は正規表現等のパターンマッチング抽象型 | E-01 (3-11行目) | ○ |
| C-16 | replace は IOBuffer に書き込みながら処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- replace の実装詳細が未確認
  - 候補：`base/strings/util.jl` の replace 関数実装を確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 検索の核心的な最適化（FwCharPosIter/RvCharPosIter）はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] FwCharPosIter の末尾バイト検索最適化の説明が正確か
- [ ] startswith の _memcmp 最適化の説明が正確か
- [ ] replace の実装詳細（IOBuffer パターン）を確認
- [ ] PCRE2 による正規表現処理の説明が十分か
- [ ] split / join / strip の説明が十分か
