---
generated_at: 2026-02-04 12:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-正規表現

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張にソースコードの根拠が存在する。

## 2) 参照した情報（Evidence一覧）

- E-01: `base/regex.jl` 23-46行目 - Regex 構造体定義
- E-02: `base/regex.jl` 226-232行目 - RegexMatch 構造体定義
- E-03: `base/regex.jl` 600-602行目 - SubstitutionString 構造体定義
- E-04: `base/regex.jl` 635-639行目 - RegexAndMatchData 構造体定義
- E-05: `base/regex.jl` 48-67行目 - Regex(pattern, flags) コンストラクタ
- E-06: `base/regex.jl` 70-89行目 - compile 関数
- E-07: `base/regex.jl` 123行目 - @r_str マクロ
- E-08: `base/regex.jl` 430-449行目 - match 関数実装
- E-09: `base/regex.jl` 306-314行目 - occursin 関数
- E-10: `base/regex.jl` 338-346行目 - startswith(::AbstractString, ::Regex)
- E-11: `base/regex.jl` 370-378行目 - endswith(::AbstractString, ::Regex)
- E-12: `base/regex.jl` 730-742行目 - RegexMatchIterator 構造体
- E-13: `base/regex.jl` 744-772行目 - RegexMatchIterator.iterate
- E-14: `base/regex.jl` 670-728行目 - _replace for SubstitutionString
- E-15: `base/regex.jl` 7-8行目 - DEFAULT_COMPILER_OPTS / DEFAULT_MATCH_OPTS
- E-16: `base/regex.jl` 568-580行目 - count 関数
- E-17: `base/regex.jl` 851-870行目 - Regex * 演算子
- E-18: `base/regex.jl` 924行目 - Regex ^ 演算子
- E-19: `base/regex.jl` 631行目 - @s_str マクロ
- E-20: `docs/code-to-docs/機能一覧/機能一覧.csv` 33行目 - 機能No.32の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Regex は mutable struct で pattern, compile_options, match_options, regex フィールドを持つ | E-01 | ○ |
| C-02 | RegexMatch は match, captures, offset, offsets, regex フィールドを持つ | E-02 | ○ |
| C-03 | デフォルトオプションは UTF + MATCH_INVALID_UTF + ALT_BSUX + UCP | E-15 | ○ |
| C-04 | フラグ 'a' で UTF/UCP/MATCH_INVALID_UTF を無効化 | E-05 (52-57行目) | ○ |
| C-05 | compile() は PCRE.compile + PCRE.jit_compile を実行 | E-06 | ○ |
| C-06 | compile() はスレッドセーフ（PCRE_COMPILE_LOCK 使用） | E-06 (76-86行目) | ○ |
| C-07 | @r_str マクロで r"..." リテラルが展開される | E-07 | ○ |
| C-08 | match は PCRE.exec_r_data でマッチを実行する | E-08 (434行目) | ○ |
| C-09 | PCRE.UNSET のキャプチャは nothing に変換される | E-08 (442行目) | ○ |
| C-10 | match は String/SubString{String} のみをサポート | E-08 (478-480行目) | ○ |
| C-11 | occursin は PCRE.exec_r で存在チェックを行う | E-09 | ○ |
| C-12 | startswith は PCRE.ANCHORED オプションを使用 | E-10 (340行目) | ○ |
| C-13 | endswith は PCRE.ENDANCHORED オプションを使用 | E-11 (372行目) | ○ |
| C-14 | eachmatch は RegexMatchIterator を構築して返す | E-12 | ○ |
| C-15 | RegexMatchIterator.iterate はオーバーラップ対応 | E-13 (759-762行目) | ○ |
| C-16 | SubstitutionString で \1, \g<name> によるキャプチャ参照が可能 | E-14 | ○ |
| C-17 | @s_str マクロで s"..." リテラルが展開される | E-19 | ○ |
| C-18 | RegexAndMatchData でマッチデータの事前確保を行う | E-04 | ○ |
| C-19 | Regex の * 演算子で正規表現を連結可能 | E-17 | ○ |
| C-20 | Regex の ^ 演算子で正規表現を繰り返し可能 | E-18 | ○ |
| C-21 | 異なる非imsx オプションの Regex 連結は ArgumentError | E-17 (863行目) | ○ |
| C-22 | finalizer で PCRE.free_re を登録してリソース解放 | E-01 (41-43行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードにより裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - regex.jl は単一ファイルに全機能が集約されており、根拠の確認が容易

## 6) レビュアーチェックリスト（最小）
- [ ] PCRE2 のバージョンとオプション定数が正しく対応しているか確認
- [ ] RegexMatch の行番号が正しいか確認
- [ ] AnnotatedString 対応メソッドの記述が正確か確認
