---
generated_at: 2026-02-04 12:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：33-文字（Char）操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **isletter/isdigit 等の文字分類関数**：char.jl には定義がなく stdlib/Unicode に委譲されている。Unicode モジュールの具体的な実装は未確認。

## 2) 参照した情報（Evidence一覧）

- E-01: `base/char.jl` 5-37行目 - AbstractChar docstring
- E-02: `base/char.jl` 39-52行目 - Char docstring
- E-03: `base/char.jl` 190-198行目 - Char(u::UInt32) コンストラクタ
- E-04: `base/char.jl` 158-171行目 - UInt32(c::Char) 変換
- E-05: `base/char.jl` 71-78行目 - ncodeunits(c::Char)
- E-06: `base/char.jl` 80-100行目 - codepoint 関数
- E-07: `base/char.jl` 111-124行目 - ismalformed / isoverlong
- E-08: `base/char.jl` 242-250行目 - ==, isless, hash
- E-09: `base/char.jl` 253-274行目 - +, - 演算子
- E-10: `base/char.jl` 310-344行目 - show(io, c::AbstractChar)
- E-11: `base/char.jl` 346-366行目 - show(io, ::MIME"text/plain", c)
- E-12: `base/char.jl` 279-280行目 - print(io, c::Char)
- E-13: `base/char.jl` 102-107行目 - InvalidCharError / CodePointError
- E-14: `base/char.jl` 54-58行目 - 型変換メソッド群
- E-15: `base/char.jl` 282-285行目 - hex_chars 定数配列
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv` 34行目 - 機能No.33の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractChar は抽象型で codepoint と T(::UInt32) の実装を要求 | E-01 | ○ |
| C-02 | Char は 32 ビットの AbstractChar サブタイプ | E-02 | ○ |
| C-03 | Char(u::UInt32) は u < 0x80 で ASCII 高速パス | E-03 (190行目) | ○ |
| C-04 | Char(u::UInt32) は u >= 0x00200000 で CodePointError | E-03 (192行目) | ○ |
| C-05 | UInt32(c::Char) は u < 0x80000000 で ASCII 高速パス | E-04 (161行目) | ○ |
| C-06 | 不正エンコーディング時に InvalidCharError をスロー | E-04, E-13 | ○ |
| C-07 | ncodeunits は trailing_zeros でゼロバイト数を算出 | E-05 | ○ |
| C-08 | codepoint(c::Char) = UInt32(c) | E-06 (100行目) | ○ |
| C-09 | ismalformed はビット演算で不正エンコーディングを検出 | E-07 | ○ |
| C-10 | isoverlong は is_overlong_enc で検出 | E-07 (119-124行目) | ○ |
| C-11 | == は bitcast(UInt32, x) == bitcast(UInt32, y) で比較 | E-08 (242行目) | ○ |
| C-12 | isless は bitcast(UInt32, x) < bitcast(UInt32, y) で比較 | E-08 (243行目) | ○ |
| C-13 | + 演算子は ASCII 高速パスを持つ | E-09 (264-273行目) | ○ |
| C-14 | show はエスケープシーケンス文字を特別処理する | E-10 (311-327行目) | ○ |
| C-15 | show は isoverlong/ismalformed で show_invalid を呼ぶ | E-10 (328-329行目) | ○ |
| C-16 | show(MIME"text/plain") は Unicode カテゴリ情報を表示 | E-11 (363-365行目) | ○ |
| C-17 | print(io, c::Char) は write + nothing | E-12 (279行目) | ○ |
| C-18 | @constprop :aggressive で定数畳み込みを促進 | E-03, E-04, E-14 | ○ |
| C-19 | hex_chars は show 等で共有使用される定数配列 | E-15 | ○ |
| C-20 | isletter/isdigit 等は stdlib/Unicode で実装されている | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- isletter, isdigit, isspace, isprint 等の文字分類関数の具体的な実装場所
  - 候補：stdlib/Unicode/src/Unicode.jl / base/strings/unicode.jl

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Char 型の核心機能は char.jl に集約されており、根拠が明確
- 1: 中リスク - 文字分類関数が stdlib/Unicode に委譲されている部分の詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] UTF-8 エンコード/デコードのビット演算が正確に記述されているか確認
- [ ] isletter/isdigit 等の文字分類関数の実装場所を確認
- [ ] Char コンストラクタの上限値 0x00200000 が正確か確認
