---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：4-パラメトリック型

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **C-14**: jl_apply_type()の具体的な処理フロー
  2. **C-15**: 型キャッシュの実装詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `base/boot.jl` 37-41行目（TypeVar構造体コメント）
- E-02: `base/boot.jl` 43-46行目（UnionAll構造体コメント）
- E-03: `base/boot.jl` 335-338行目（TypeVar/UnionAllコンストラクタ）
- E-04: `base/boot.jl` 354行目（has_free_typevars関数）
- E-05: `base/complex.jl` 13-16行目（Complex{T}定義）
- E-06: `base/rational.jl` 9-15行目（Rational{T}定義）
- E-07: `機能一覧.csv` 4行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TypeVarがname, lb, ubフィールドを持つ | E-01 | ○ |
| C-02 | UnionAllがvar, bodyフィールドを持つ | E-02 | ○ |
| C-03 | TypeVarのデフォルト下界がUnion{}、上界がAny | E-03 | ○ |
| C-04 | UnionAll構築がccall(:jl_type_unionall)で行われる | E-03 | ○ |
| C-05 | has_free_typevarsで型変数の未束縛判定が可能 | E-04 | ○ |
| C-06 | Complex{T<:Real}がパラメトリック型の実例 | E-05 | ○ |
| C-07 | Rational{T<:Integer}がパラメトリック型の実例 | E-06 | ○ |
| C-08 | パラメトリック型は不変（invariant） | E-07 | ○ |
| C-09 | TypeVarコンストラクタが3つのオーバーロードを持つ | E-03 | ○ |
| C-10 | UnionAllは全称量化型を表す | E-02, E-03 | ○ |
| C-11 | 型パラメータの上下界はlb <: ubを満たす必要がある | E-01 | ○ |
| C-12 | base/essentials.jlで定義される | E-07 | ○ |
| C-13 | ネストされたwhere句は外側から適用される | E-02 | ○ |
| C-14 | jl_apply_type()で型特殊化が行われる | **根拠なし** | △ |
| C-15 | 同一パラメータの型はキャッシュされる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: src/jltypes.cのjl_apply_type()実装を直接確認していない
  - 候補：src/jltypes.c / src/builtins.c
- C-15: 型キャッシュの具体的な実装（ハッシュテーブル等）を確認していない
  - 候補：src/jltypes.c / src/typemap.c

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TypeVar/UnionAllの構造はboot.jlコメントと整合
- 0: 低リスク - コンストラクタの記述はソースコードと一致
- 1: 中リスク - Cランタイムの型特殊化処理の詳細は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] boot.jlのTypeVar/UnionAllコンストラクタの行番号が最新ソースと一致しているか確認
- [ ] jl_apply_type()の記述が実際のCコードと一致するか確認
- [ ] パラメトリック型の不変性に関する記述が正確か確認
